/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.scheduling.v1;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMeta;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass;

public class PriorityClassFluent<A extends PriorityClassFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String description;
    private Boolean globalDefault;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String preemptionPolicy;
    private Integer value;
    private Map<String, Object> additionalProperties;

    public PriorityClassFluent() {
    }

    public PriorityClassFluent(PriorityClass instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PriorityClass instance) {
        PriorityClass priorityClass = instance = instance != null ? instance : new PriorityClass();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDescription(instance.getDescription());
            this.withGlobalDefault(instance.getGlobalDefault());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withPreemptionPolicy(instance.getPreemptionPolicy());
            this.withValue(instance.getValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public Boolean getGlobalDefault() {
        return this.globalDefault;
    }

    public A withGlobalDefault(Boolean globalDefault) {
        this.globalDefault = globalDefault;
        return (A)this;
    }

    public boolean hasGlobalDefault() {
        return this.globalDefault != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return (A)this;
    }

    public boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    public Integer getValue() {
        return this.value;
    }

    public A withValue(Integer value) {
        this.value = value;
        return (A)this;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PriorityClassFluent that = (PriorityClassFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.globalDefault, that.globalDefault)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.preemptionPolicy, that.preemptionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.description, this.globalDefault, this.kind, this.metadata, this.preemptionPolicy, this.value, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.globalDefault != null) {
            sb.append("globalDefault:");
            sb.append(this.globalDefault + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.preemptionPolicy != null) {
            sb.append("preemptionPolicy:");
            sb.append(this.preemptionPolicy + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withGlobalDefault() {
        return this.withGlobalDefault(true);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PriorityClassFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

