/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.dsv2.join;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.dsv2.Sink;
import org.apache.flink.api.connector.dsv2.Source;
import org.apache.flink.api.connector.dsv2.WrappedSink;
import org.apache.flink.api.connector.dsv2.WrappedSource;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.datastream.api.ExecutionEnvironment;
import org.apache.flink.datastream.api.builtin.BuiltinFuncs;
import org.apache.flink.datastream.api.common.Collector;
import org.apache.flink.datastream.api.context.RuntimeContext;
import org.apache.flink.datastream.api.extension.join.JoinFunction;
import org.apache.flink.datastream.api.stream.NonKeyedPartitionStream;
import org.apache.flink.formats.csv.CsvReaderFormat;
import org.apache.flink.streaming.api.functions.sink.PrintSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.util.ParameterTool;

public class Join {
    public static void main(String[] args) throws Exception {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        boolean fileOutput = params.has("output");
        ExecutionEnvironment env = ExecutionEnvironment.getInstance();
        String gradesInputFilePath = Objects.requireNonNull(Join.class.getClassLoader().getResource("datas/dsv2/join/JoinGrades.csv")).getPath();
        FileSource gradesFileSource = FileSource.forRecordStreamFormat((StreamFormat)CsvReaderFormat.forPojo(GradePojo.class), (Path[])new Path[]{new Path(gradesInputFilePath)}).build();
        NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream grades = env.fromSource((Source)new WrappedSource((org.apache.flink.api.connector.source.Source)gradesFileSource), "grade source");
        String salariesInputFilePath = Objects.requireNonNull(Join.class.getClassLoader().getResource("datas/dsv2/join/JoinSalaries.csv")).getPath();
        FileSource salariesFileSource = FileSource.forRecordStreamFormat((StreamFormat)CsvReaderFormat.forPojo(SalaryPojo.class), (Path[])new Path[]{new Path(salariesInputFilePath)}).build();
        NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream salaries = env.fromSource((Source)new WrappedSource((org.apache.flink.api.connector.source.Source)salariesFileSource), "salary source");
        NonKeyedPartitionStream joinedStream = BuiltinFuncs.join((NonKeyedPartitionStream)grades, (KeySelector)new GradeKeySelector(), (NonKeyedPartitionStream)salaries, (KeySelector)new SalaryKeySelector(), (JoinFunction)new JoinGradeAndSalaryFunction());
        if (fileOutput) {
            joinedStream.toSink((Sink)new WrappedSink((org.apache.flink.api.connector.sink2.Sink)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(params.get("output")), (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build())).build())).withName("output");
        } else {
            joinedStream.toSink((Sink)new WrappedSink((org.apache.flink.api.connector.sink2.Sink)new PrintSink())).withName("print-sink");
        }
        env.execute("Join Grade and Salary");
    }

    public static class GradePojo {
        public int grade;
        public String name;
    }

    public static class SalaryPojo {
        public String name;
        public long salary;
    }

    private static class GradeKeySelector
    implements KeySelector<GradePojo, String> {
        private GradeKeySelector() {
        }

        public String getKey(GradePojo value) throws Exception {
            return value.name;
        }
    }

    private static class SalaryKeySelector
    implements KeySelector<SalaryPojo, String> {
        private SalaryKeySelector() {
        }

        public String getKey(SalaryPojo value) throws Exception {
            return value.name;
        }
    }

    private static class JoinGradeAndSalaryFunction
    implements JoinFunction<GradePojo, SalaryPojo, GradeAndSalaryPojo> {
        private JoinGradeAndSalaryFunction() {
        }

        public void processRecord(GradePojo leftRecord, SalaryPojo rightRecord, Collector<GradeAndSalaryPojo> output, RuntimeContext ctx) throws Exception {
            output.collect((Object)new GradeAndSalaryPojo(leftRecord.name, leftRecord.grade, rightRecord.salary));
        }
    }

    public static class GradeAndSalaryPojo {
        public String name;
        public int grade;
        public long salary;

        public GradeAndSalaryPojo(String name, int grade, long salary) {
            this.name = name;
            this.grade = grade;
            this.salary = salary;
        }

        public String toString() {
            return String.format("%s,%d,%d", this.name, this.grade, this.salary);
        }
    }
}

