/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.common.TimeFormats;
import org.apache.flink.formats.csv.AbstractCsvInputFormat;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.jackson.JacksonMapperFactory;

public class RowCsvInputFormat
extends AbstractCsvInputFormat<Row> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation[] fieldTypes;
    private final String[] selectedFieldNames;
    private final boolean ignoreParseErrors;
    private transient RuntimeConverter runtimeConverter;
    private transient MappingIterator<JsonNode> iterator;
    private transient boolean end;

    private RowCsvInputFormat(Path[] filePaths, TypeInformation[] fieldTypes, CsvSchema csvSchema, int[] selectedFields, boolean ignoreParseErrors) {
        super(filePaths, csvSchema);
        this.fieldTypes = (TypeInformation[])Preconditions.checkNotNull((Object)fieldTypes);
        Preconditions.checkArgument((fieldTypes.length == csvSchema.size() ? 1 : 0) != 0);
        this.ignoreParseErrors = ignoreParseErrors;
        this.selectedFieldNames = (String[])Arrays.stream((int[])Preconditions.checkNotNull((Object)selectedFields)).mapToObj(arg_0 -> ((CsvSchema)csvSchema).columnName(arg_0)).toArray(String[]::new);
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.prepareConverter();
        this.iterator = JacksonMapperFactory.createCsvMapper().readerFor(JsonNode.class).with((FormatSchema)this.csvSchema).readValues(this.csvInputStream);
    }

    private void prepareConverter() {
        RuntimeConverter[] fieldConverters = RowCsvInputFormat.createFieldRuntimeConverters(this.ignoreParseErrors, this.fieldTypes);
        this.runtimeConverter = node -> {
            int nodeSize = node.size();
            RowCsvInputFormat.validateArity(this.csvSchema.size(), nodeSize, this.ignoreParseErrors);
            Row row = new Row(this.selectedFieldNames.length);
            for (int i = 0; i < Math.min(this.selectedFieldNames.length, nodeSize); ++i) {
                row.setField(i, fieldConverters[i].convert(node.get(this.selectedFieldNames[i])));
            }
            return row;
        };
    }

    public boolean reachedEnd() {
        return this.end;
    }

    public Row nextRecord(Row record) throws IOException {
        Row returnRecord = null;
        do {
            try {
                JsonNode root = (JsonNode)this.iterator.nextValue();
                returnRecord = (Row)this.runtimeConverter.convert(root);
            }
            catch (NoSuchElementException e) {
                this.end = true;
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) continue;
                throw new IOException("Failed to deserialize CSV row.", t);
            }
        } while (returnRecord == null && !this.reachedEnd());
        return returnRecord;
    }

    private static RuntimeConverter createRowRuntimeConverter(RowTypeInfo rowTypeInfo, boolean ignoreParseErrors, boolean isTopLevel) {
        TypeInformation[] fieldTypes = rowTypeInfo.getFieldTypes();
        String[] fieldNames = rowTypeInfo.getFieldNames();
        RuntimeConverter[] fieldConverters = RowCsvInputFormat.createFieldRuntimeConverters(ignoreParseErrors, fieldTypes);
        return RowCsvInputFormat.assembleRowRuntimeConverter(ignoreParseErrors, isTopLevel, fieldNames, fieldConverters);
    }

    static RuntimeConverter[] createFieldRuntimeConverters(boolean ignoreParseErrors, TypeInformation<?>[] fieldTypes) {
        RuntimeConverter[] fieldConverters = new RuntimeConverter[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            fieldConverters[i] = RowCsvInputFormat.createNullableRuntimeConverter(fieldTypes[i], ignoreParseErrors);
        }
        return fieldConverters;
    }

    private static RuntimeConverter assembleRowRuntimeConverter(boolean ignoreParseErrors, boolean isTopLevel, String[] fieldNames, RuntimeConverter[] fieldConverters) {
        int rowArity = fieldNames.length;
        return node -> {
            int nodeSize = node.size();
            if (nodeSize == 0) {
                return null;
            }
            RowCsvInputFormat.validateArity(rowArity, nodeSize, ignoreParseErrors);
            Row row = new Row(rowArity);
            for (int i = 0; i < Math.min(rowArity, nodeSize); ++i) {
                if (isTopLevel) {
                    row.setField(i, fieldConverters[i].convert(node.get(fieldNames[i])));
                    continue;
                }
                row.setField(i, fieldConverters[i].convert(node.get(i)));
            }
            return row;
        };
    }

    private static RuntimeConverter createNullableRuntimeConverter(TypeInformation<?> info, boolean ignoreParseErrors) {
        RuntimeConverter valueConverter = RowCsvInputFormat.createRuntimeConverter(info, ignoreParseErrors);
        return node -> {
            if (node.isNull()) {
                return null;
            }
            try {
                return valueConverter.convert(node);
            }
            catch (Throwable t) {
                if (!ignoreParseErrors) {
                    throw t;
                }
                return null;
            }
        };
    }

    private static RuntimeConverter createRuntimeConverter(TypeInformation<?> info, boolean ignoreParseErrors) {
        if (info.equals((Object)Types.VOID)) {
            return node -> null;
        }
        if (info.equals((Object)Types.STRING)) {
            return JsonNode::asText;
        }
        if (info.equals((Object)Types.BOOLEAN)) {
            return node -> Boolean.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.BYTE)) {
            return node -> Byte.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.SHORT)) {
            return node -> Short.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.INT)) {
            return node -> Integer.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.LONG)) {
            return node -> Long.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.FLOAT)) {
            return node -> Float.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.DOUBLE)) {
            return node -> Double.valueOf(node.asText().trim());
        }
        if (info.equals((Object)Types.BIG_DEC)) {
            return node -> new BigDecimal(node.asText().trim());
        }
        if (info.equals((Object)Types.BIG_INT)) {
            return node -> new BigInteger(node.asText().trim());
        }
        if (info.equals((Object)Types.SQL_DATE)) {
            return node -> Date.valueOf(node.asText());
        }
        if (info.equals((Object)Types.SQL_TIME)) {
            return node -> Time.valueOf(node.asText());
        }
        if (info.equals((Object)Types.SQL_TIMESTAMP)) {
            return node -> Timestamp.valueOf(node.asText());
        }
        if (info.equals((Object)Types.LOCAL_DATE)) {
            return node -> Date.valueOf(node.asText()).toLocalDate();
        }
        if (info.equals((Object)Types.LOCAL_TIME)) {
            return node -> Time.valueOf(node.asText()).toLocalTime();
        }
        if (info.equals((Object)Types.LOCAL_DATE_TIME)) {
            return node -> LocalDateTime.parse(node.asText().trim(), TimeFormats.SQL_TIMESTAMP_FORMAT);
        }
        if (info.equals((Object)Types.INSTANT)) {
            return node -> LocalDateTime.parse(node.asText(), TimeFormats.SQL_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT).toInstant(ZoneOffset.UTC);
        }
        if (info instanceof RowTypeInfo) {
            RowTypeInfo rowTypeInfo = (RowTypeInfo)info;
            return RowCsvInputFormat.createRowRuntimeConverter(rowTypeInfo, ignoreParseErrors, false);
        }
        if (info instanceof BasicArrayTypeInfo) {
            return RowCsvInputFormat.createObjectArrayRuntimeConverter(((BasicArrayTypeInfo)info).getComponentInfo(), ignoreParseErrors);
        }
        if (info instanceof ObjectArrayTypeInfo) {
            return RowCsvInputFormat.createObjectArrayRuntimeConverter(((ObjectArrayTypeInfo)info).getComponentInfo(), ignoreParseErrors);
        }
        if (info instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)info).getComponentType() == Types.BYTE) {
            return RowCsvInputFormat.createByteArrayRuntimeConverter(ignoreParseErrors);
        }
        throw new RuntimeException("Unsupported type information '" + info + "'.");
    }

    private static RuntimeConverter createObjectArrayRuntimeConverter(TypeInformation<?> elementType, boolean ignoreParseErrors) {
        Class elementClass = elementType.getTypeClass();
        RuntimeConverter elementConverter = RowCsvInputFormat.createNullableRuntimeConverter(elementType, ignoreParseErrors);
        return node -> {
            int nodeSize = node.size();
            Object[] array = (Object[])Array.newInstance(elementClass, nodeSize);
            for (int i = 0; i < nodeSize; ++i) {
                array[i] = elementConverter.convert(node.get(i));
            }
            return array;
        };
    }

    private static RuntimeConverter createByteArrayRuntimeConverter(boolean ignoreParseErrors) {
        return node -> {
            try {
                return node.binaryValue();
            }
            catch (IOException e) {
                if (!ignoreParseErrors) {
                    throw new RuntimeException("Unable to deserialize byte array.", e);
                }
                return null;
            }
        };
    }

    static void validateArity(int expected, int actual, boolean ignoreParseErrors) {
        if (expected != actual && !ignoreParseErrors) {
            throw new RuntimeException("Row length mismatch. " + expected + " fields expected but was " + actual + ".");
        }
    }

    public static Builder builder(TypeInformation<Row> typeInfo, Path ... filePaths) {
        return new Builder(typeInfo, filePaths);
    }

    static interface RuntimeConverter
    extends Serializable {
        public Object convert(JsonNode var1);
    }

    public static class Builder
    implements Serializable {
        private final Path[] filePaths;
        private final TypeInformation[] fieldTypes;
        private CsvSchema csvSchema;
        private boolean ignoreParseErrors;
        private int[] selectedFields;

        private Builder(TypeInformation<Row> typeInfo, Path ... filePaths) {
            Preconditions.checkNotNull((Object)filePaths, (String)"File paths must not be null.");
            Preconditions.checkNotNull(typeInfo, (String)"Type information must not be null.");
            if (!(typeInfo instanceof RowTypeInfo)) {
                throw new IllegalArgumentException("Row type information expected.");
            }
            this.filePaths = filePaths;
            this.fieldTypes = ((RowTypeInfo)typeInfo).getFieldTypes();
            this.csvSchema = CsvRowSchemaConverter.convert((RowTypeInfo)typeInfo);
        }

        public Builder setFieldDelimiter(char delimiter) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(delimiter).build();
            return this;
        }

        public Builder setAllowComments(boolean allowComments) {
            this.csvSchema = this.csvSchema.rebuild().setAllowComments(allowComments).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Array element delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            Preconditions.checkNotNull((Object)nullLiteral, (String)"Null literal must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setNullValue(nullLiteral).build();
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public Builder setSelectedFields(int[] selectedFields) {
            this.selectedFields = selectedFields;
            return this;
        }

        public RowCsvInputFormat build() {
            if (this.selectedFields == null) {
                this.selectedFields = new int[this.fieldTypes.length];
                for (int i = 0; i < this.fieldTypes.length; ++i) {
                    this.selectedFields[i] = i;
                }
            }
            return new RowCsvInputFormat(this.filePaths, this.fieldTypes, this.csvSchema, this.selectedFields, this.ignoreParseErrors);
        }
    }
}

