/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer.config;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.sink.writer.strategy.AIMDScalingStrategy;
import org.apache.flink.connector.base.sink.writer.strategy.CongestionControlRateLimitingStrategy;
import org.apache.flink.connector.base.sink.writer.strategy.RateLimitingStrategy;

@PublicEvolving
public class AsyncSinkWriterConfiguration {
    public static final long DEFAULT_REQUEST_TIMEOUT_MS = Duration.ofMinutes(10L).toMillis();
    public static final boolean DEFAULT_FAIL_ON_TIMEOUT = false;
    private final int maxBatchSize;
    private final int maxInFlightRequests;
    private final int maxBufferedRequests;
    private final long maxBatchSizeInBytes;
    private final long maxTimeInBufferMS;
    private final long maxRecordSizeInBytes;
    private final long requestTimeoutMS;
    private final boolean failOnTimeout;
    private final RateLimitingStrategy rateLimitingStrategy;

    private AsyncSinkWriterConfiguration(int maxBatchSize, int maxInFlightRequests, int maxBufferedRequests, long maxBatchSizeInBytes, long maxTimeInBufferMS, long maxRecordSizeInBytes, long requestTimeoutMS, boolean failOnTimeout, RateLimitingStrategy rateLimitingStrategy) {
        this.maxBatchSize = maxBatchSize;
        this.maxInFlightRequests = maxInFlightRequests;
        this.maxBufferedRequests = maxBufferedRequests;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
        this.maxTimeInBufferMS = maxTimeInBufferMS;
        this.maxRecordSizeInBytes = maxRecordSizeInBytes;
        this.rateLimitingStrategy = rateLimitingStrategy;
        this.requestTimeoutMS = requestTimeoutMS;
        this.failOnTimeout = failOnTimeout;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public int getMaxInFlightRequests() {
        return this.maxInFlightRequests;
    }

    public int getMaxBufferedRequests() {
        return this.maxBufferedRequests;
    }

    public long getMaxBatchSizeInBytes() {
        return this.maxBatchSizeInBytes;
    }

    public long getMaxTimeInBufferMS() {
        return this.maxTimeInBufferMS;
    }

    public long getMaxRecordSizeInBytes() {
        return this.maxRecordSizeInBytes;
    }

    public RateLimitingStrategy getRateLimitingStrategy() {
        return this.rateLimitingStrategy;
    }

    public long getRequestTimeoutMS() {
        return this.requestTimeoutMS;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    @PublicEvolving
    public static ConfigurationMaxBatchSize builder() {
        return new AsyncSinkWriterConfigurationBuilder();
    }

    @PublicEvolving
    public static class AsyncSinkWriterConfigurationBuilder
    implements ConfigurationMaxBatchSize,
    ConfigurationMaxInFlightRequests,
    ConfigurationMaxBufferedRequests,
    ConfigurationMaxBatchSizeInBytes,
    ConfigurationMaxTimeInBufferMS,
    ConfigurationMaxRecordSizeInBytes {
        private int maxBatchSize;
        private int maxInFlightRequests;
        private int maxBufferedRequests;
        private long maxBatchSizeInBytes;
        private long maxTimeInBufferMS;
        private long maxRecordSizeInBytes;
        private long requestTimeoutMS = DEFAULT_REQUEST_TIMEOUT_MS;
        private boolean failOnTimeout = false;
        private RateLimitingStrategy rateLimitingStrategy;

        @Override
        public ConfigurationMaxBatchSizeInBytes setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        @Override
        public ConfigurationMaxInFlightRequests setMaxBatchSizeInBytes(long maxBatchSizeInBytes) {
            this.maxBatchSizeInBytes = maxBatchSizeInBytes;
            return this;
        }

        @Override
        public ConfigurationMaxBufferedRequests setMaxInFlightRequests(int maxInFlightRequests) {
            this.maxInFlightRequests = maxInFlightRequests;
            return this;
        }

        @Override
        public ConfigurationMaxTimeInBufferMS setMaxBufferedRequests(int maxBufferedRequests) {
            this.maxBufferedRequests = maxBufferedRequests;
            return this;
        }

        @Override
        public ConfigurationMaxRecordSizeInBytes setMaxTimeInBufferMS(long maxTimeInBufferMS) {
            this.maxTimeInBufferMS = maxTimeInBufferMS;
            return this;
        }

        @Override
        public AsyncSinkWriterConfigurationBuilder setMaxRecordSizeInBytes(long maxRecordSizeInBytes) {
            this.maxRecordSizeInBytes = maxRecordSizeInBytes;
            return this;
        }

        public AsyncSinkWriterConfigurationBuilder setRequestTimeoutMS(long requestTimeoutMS) {
            this.requestTimeoutMS = requestTimeoutMS;
            return this;
        }

        public AsyncSinkWriterConfigurationBuilder setFailOnTimeout(boolean failOnTimeout) {
            this.failOnTimeout = failOnTimeout;
            return this;
        }

        public AsyncSinkWriterConfigurationBuilder setRateLimitingStrategy(RateLimitingStrategy rateLimitingStrategy) {
            this.rateLimitingStrategy = rateLimitingStrategy;
            return this;
        }

        public AsyncSinkWriterConfiguration build() {
            if (this.rateLimitingStrategy == null) {
                this.rateLimitingStrategy = CongestionControlRateLimitingStrategy.builder().setMaxInFlightRequests(this.maxInFlightRequests).setInitialMaxInFlightMessages(this.maxBatchSize).setScalingStrategy(AIMDScalingStrategy.builder(this.maxBatchSize * this.maxInFlightRequests).build()).build();
            }
            return new AsyncSinkWriterConfiguration(this.maxBatchSize, this.maxInFlightRequests, this.maxBufferedRequests, this.maxBatchSizeInBytes, this.maxTimeInBufferMS, this.maxRecordSizeInBytes, this.requestTimeoutMS, this.failOnTimeout, this.rateLimitingStrategy);
        }
    }

    @PublicEvolving
    public static interface ConfigurationMaxRecordSizeInBytes {
        public AsyncSinkWriterConfigurationBuilder setMaxRecordSizeInBytes(long var1);
    }

    @PublicEvolving
    public static interface ConfigurationMaxTimeInBufferMS {
        public ConfigurationMaxRecordSizeInBytes setMaxTimeInBufferMS(long var1);
    }

    @PublicEvolving
    public static interface ConfigurationMaxBufferedRequests {
        public ConfigurationMaxTimeInBufferMS setMaxBufferedRequests(int var1);
    }

    @PublicEvolving
    public static interface ConfigurationMaxInFlightRequests {
        public ConfigurationMaxBufferedRequests setMaxInFlightRequests(int var1);
    }

    @PublicEvolving
    public static interface ConfigurationMaxBatchSizeInBytes {
        public ConfigurationMaxInFlightRequests setMaxBatchSizeInBytes(long var1);
    }

    @PublicEvolving
    public static interface ConfigurationMaxBatchSize {
        public ConfigurationMaxBatchSizeInBytes setMaxBatchSize(int var1);
    }
}

