/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.batch.compact;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.connector.file.table.batch.compact.BatchCompactCoordinator;
import org.apache.flink.connector.file.table.stream.compact.AbstractCompactTestBase;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BatchCompactCoordinatorTest
extends AbstractCompactTestBase {
    @Test
    public void testCompactIsNotNeeded() throws Exception {
        long averageSize = 5L;
        long targetSize = 50L;
        BatchCompactCoordinator compactCoordinator = new BatchCompactCoordinator(() -> this.folder.getFileSystem(), averageSize, targetSize);
        try (OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)compactCoordinator);){
            testHarness.setup();
            testHarness.open();
            Path f1 = this.newFile("f1", 10);
            Path f2 = this.newFile("f2", 5);
            Path f3 = this.newFile("f3", 16);
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("", f1)));
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("", f2)));
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("", f3)));
            testHarness.endInput();
            this.assertCompactUnits(testHarness.extractOutputValues(), Arrays.asList(new CompactMessages.CompactionUnit(0, "", Collections.singletonList(f1)), new CompactMessages.CompactionUnit(1, "", Collections.singletonList(f2)), new CompactMessages.CompactionUnit(2, "", Collections.singletonList(f3))));
        }
    }

    @Test
    public void testCompactNonPartitionedTable() throws Exception {
        long averageSize = 14L;
        long targetSize = 16L;
        BatchCompactCoordinator compactCoordinator = new BatchCompactCoordinator(() -> this.folder.getFileSystem(), averageSize, targetSize);
        try (OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)compactCoordinator);){
            testHarness.setup();
            testHarness.open();
            Path f1 = this.newFile("f1", 10);
            Path f2 = this.newFile("f2", 5);
            Path f3 = this.newFile("f3", 20);
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("", f1)));
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("", f2)));
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("", f3)));
            testHarness.endInput();
            List coordinatorOutputs = testHarness.extractOutputValues();
            this.assertCompactUnits(coordinatorOutputs, Arrays.asList(new CompactMessages.CompactionUnit(0, "", Arrays.asList(f1, f2)), new CompactMessages.CompactionUnit(1, "", Collections.singletonList(f3))));
        }
    }

    @Test
    public void testCompactPartitionedTable() throws Exception {
        long averageSize = 10L;
        long targetSize = 16L;
        BatchCompactCoordinator compactCoordinator = new BatchCompactCoordinator(() -> this.folder.getFileSystem(), averageSize, targetSize);
        try (OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)compactCoordinator);){
            testHarness.setup();
            testHarness.open();
            Path f1 = this.newFile("f1", 10);
            Path f2 = this.newFile("f2", 5);
            Path f3 = this.newFile("f3", 20);
            Path f4 = this.newFile("f4", 8);
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("p1=1/", f1)));
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("p1=1/", f2)));
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("p1=2/", f3)));
            testHarness.processElement(new StreamRecord((Object)new CompactMessages.InputFile("p1=2/", f4)));
            testHarness.endInput();
            List coordinatorOutputs = testHarness.extractOutputValues();
            this.assertCompactUnits(coordinatorOutputs, Arrays.asList(new CompactMessages.CompactionUnit(0, "p1=1/", Arrays.asList(f1, f2)), new CompactMessages.CompactionUnit(1, "p1=2/", Collections.singletonList(f3)), new CompactMessages.CompactionUnit(2, "p1=2/", Collections.singletonList(f4))));
        }
    }

    private void assertCompactUnits(List<CompactMessages.CoordinatorOutput> coordinatorOutputs, List<CompactMessages.CompactionUnit> expectCompactionUnits) {
        Assertions.assertThat((int)coordinatorOutputs.size()).isEqualTo(expectCompactionUnits.size());
        coordinatorOutputs.sort(Comparator.comparing(o -> ((CompactMessages.CompactionUnit)o).getPartition()));
        expectCompactionUnits.sort(Comparator.comparing(CompactMessages.CompactionUnit::getPartition));
        for (int i = 0; i < coordinatorOutputs.size(); ++i) {
            CompactMessages.CoordinatorOutput coordinatorOutput = coordinatorOutputs.get(i);
            Assertions.assertThat((Object)coordinatorOutput).isInstanceOf(CompactMessages.CompactionUnit.class);
            CompactMessages.CompactionUnit compactionUnit = (CompactMessages.CompactionUnit)coordinatorOutput;
            CompactMessages.CompactionUnit expectCompactionUnit = expectCompactionUnits.get(i);
            Assertions.assertThat((String)compactionUnit.getPartition()).isEqualTo(expectCompactionUnit.getPartition());
            Assertions.assertThat((List)compactionUnit.getPaths()).isEqualTo((Object)expectCompactionUnit.getPaths());
        }
    }
}

