/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.hybrid;

import java.io.IOException;
import java.util.HashMap;
import org.apache.flink.api.connector.source.mocks.MockSource;
import org.apache.flink.connector.base.source.hybrid.HybridSourceSplit;
import org.apache.flink.connector.base.source.hybrid.HybridSourceSplitSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HybridSourceSplitSerializerTest {
    HybridSourceSplitSerializerTest() {
    }

    @Test
    void testSerialization() throws Exception {
        HashMap<Integer, MockSource> switchedSources = new HashMap<Integer, MockSource>();
        switchedSources.put(0, new MockSource(null, 0));
        byte[] splitBytes = new byte[]{1, 2, 3};
        HybridSourceSplitSerializer serializer = new HybridSourceSplitSerializer();
        HybridSourceSplit split = new HybridSourceSplit(0, splitBytes, 0, "splitId");
        byte[] serialized = serializer.serialize(split);
        HybridSourceSplit clonedSplit = serializer.deserialize(0, serialized);
        Assertions.assertThat((Object)clonedSplit).isEqualTo((Object)split);
        Assertions.assertThatThrownBy(() -> serializer.deserialize(1, serialized)).isInstanceOf(IOException.class);
    }
}

