/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.utils;

import java.util.List;
import java.util.Map;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.CepOperator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;

public class CepOperatorBuilder<OUT> {
    private final boolean isProcessingTime;
    private final NFACompiler.NFAFactory<Event> nfaFactory;
    private final EventComparator<Event> comparator;
    private final AfterMatchSkipStrategy skipStrategy;
    private final PatternProcessFunction<Event, OUT> function;
    private final OutputTag<Event> lateDataOutputTag;

    public static CepOperatorBuilder<Map<String, List<Event>>> createOperatorForNFA(final NFA<Event> nfa) {
        return new CepOperatorBuilder<Map<String, List<Event>>>(true, new NFACompiler.NFAFactory<Event>(){

            public NFA<Event> createNFA() {
                return nfa;
            }
        }, null, null, new PatternProcessFunction<Event, Map<String, List<Event>>>(){
            private static final long serialVersionUID = -7143807777582726991L;

            public void processMatch(Map<String, List<Event>> match, PatternProcessFunction.Context ctx, Collector<Map<String, List<Event>>> out) throws Exception {
                out.collect(match);
            }
        }, null);
    }

    public static CepOperatorBuilder<Map<String, List<Event>>> createOperatorForNFAFactory(NFACompiler.NFAFactory<Event> nfaFactory) {
        return new CepOperatorBuilder<Map<String, List<Event>>>(true, nfaFactory, null, null, new PatternProcessFunction<Event, Map<String, List<Event>>>(){
            private static final long serialVersionUID = -7143807777582726991L;

            public void processMatch(Map<String, List<Event>> match, PatternProcessFunction.Context ctx, Collector<Map<String, List<Event>>> out) throws Exception {
                out.collect(match);
            }
        }, null);
    }

    private CepOperatorBuilder(boolean isProcessingTime, NFACompiler.NFAFactory<Event> nfaFactory, EventComparator<Event> comparator, AfterMatchSkipStrategy skipStrategy, PatternProcessFunction<Event, OUT> processFunction, OutputTag<Event> lateDataOutputTag) {
        this.isProcessingTime = isProcessingTime;
        this.nfaFactory = nfaFactory;
        this.comparator = comparator;
        this.skipStrategy = skipStrategy;
        this.function = processFunction;
        this.lateDataOutputTag = lateDataOutputTag;
    }

    public CepOperatorBuilder<OUT> inProcessingTime() {
        return new CepOperatorBuilder<OUT>(true, this.nfaFactory, this.comparator, this.skipStrategy, this.function, this.lateDataOutputTag);
    }

    public CepOperatorBuilder<OUT> inEventTime() {
        return new CepOperatorBuilder<OUT>(false, this.nfaFactory, this.comparator, this.skipStrategy, this.function, this.lateDataOutputTag);
    }

    public CepOperatorBuilder<OUT> withComparator(EventComparator<Event> comparator) {
        return new CepOperatorBuilder<OUT>(false, this.nfaFactory, comparator, this.skipStrategy, this.function, this.lateDataOutputTag);
    }

    public CepOperatorBuilder<OUT> withSkipStrategy(AfterMatchSkipStrategy skipStrategy) {
        return new CepOperatorBuilder<OUT>(false, this.nfaFactory, this.comparator, skipStrategy, this.function, this.lateDataOutputTag);
    }

    public CepOperatorBuilder<OUT> withLateDataOutputTag(OutputTag<Event> lateDataOutputTag) {
        return new CepOperatorBuilder<OUT>(false, this.nfaFactory, this.comparator, this.skipStrategy, this.function, lateDataOutputTag);
    }

    public CepOperatorBuilder<OUT> withNFA(final NFA<Event> nfa) {
        return new CepOperatorBuilder<OUT>(false, new NFACompiler.NFAFactory<Event>(){

            public NFA<Event> createNFA() {
                return nfa;
            }
        }, this.comparator, this.skipStrategy, this.function, this.lateDataOutputTag);
    }

    public <T> CepOperatorBuilder<T> withFunction(PatternProcessFunction<Event, T> processFunction) {
        return new CepOperatorBuilder<T>(this.isProcessingTime, this.nfaFactory, this.comparator, this.skipStrategy, processFunction, this.lateDataOutputTag);
    }

    public <K> CepOperator<Event, K, OUT> build() {
        return new CepOperator(Event.createTypeSerializer(), this.isProcessingTime, this.nfaFactory, this.comparator, this.skipStrategy, this.function, this.lateDataOutputTag);
    }
}

