/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterators;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SameElementITCase
extends TestLogger {
    @Test
    public void testEagerZeroOrMoreSameElement() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(50, "d", 6.0), 5L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)end1, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1, middleEvent1, middleEvent2, middleEvent3, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1, middleEvent1, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, end1})}));
    }

    @Test
    public void testClearingBuffer() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event b1 = new Event(41, "b", 2.0);
        Event c1 = new Event(41, "c", 2.0);
        Event d = new Event(41, "d", 2.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 2L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)d, 2L));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedBy("c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, b1, c1, d})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"a", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testClearingBufferWithUntilAtTheEnd() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event d1 = new Event(41, "d", 2.0);
        Event d2 = new Event(41, "d", 2.0);
        Event d3 = new Event(41, "d", 2.0);
        Event d4 = new Event(41, "d", 2.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)d1, 2L));
        inputEvents.add(new StreamRecord((Object)d2, 2L));
        inputEvents.add(new StreamRecord((Object)d3, 2L));
        inputEvents.add(new StreamRecord((Object)d4, 4L));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).oneOrMore().until((IterativeCondition)new IterativeCondition<Event>(){

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                return Iterators.size(ctx.getEventsForPattern("d").iterator()) == 3;
            }
        });
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, d1, d2, d3}), Lists.newArrayList((Object[])new Event[]{a1, d1, d2}), Lists.newArrayList((Object[])new Event[]{a1, d1})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"a", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testZeroOrMoreSameElement() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent1a = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event middleEvent3a = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent1a, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(50, "d", 6.0), 5L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)middleEvent3a, 6L));
        inputEvents.add(new StreamRecord((Object)end1, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().allowCombinations().followedByAny("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent2, middleEvent3, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent2, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent3, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent2, middleEvent3, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, middleEvent3, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent2, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent3, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3a, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, end1})}));
    }

    @Test
    public void testSimplePatternWSameElement() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)end1, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1})}));
    }

    @Test
    public void testIterativeConditionWSameElement() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent1a = new Event(41, "a", 2.0);
        Event middleEvent1b = new Event(41, "a", 2.0);
        Event end = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent1a, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent1b, 3L));
        inputEvents.add(new StreamRecord((Object)end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().allowCombinations().followedBy("end").where((IterativeCondition)new IterativeCondition<Event>(){
            private static final long serialVersionUID = -5566639743229703237L;

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                double sum = 0.0;
                for (Event event : ctx.getEventsForPattern("middle")) {
                    sum += event.getPrice();
                }
                return Double.compare(sum, 4.0) == 0;
            }
        });
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent1b}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent1b, end})}));
    }

    @Test
    public void testEndWLoopingWSameElement() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent1a = new Event(41, "a", 2.0);
        Event middleEvent1b = new Event(41, "a", 2.0);
        Event end = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent1a, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent1b, 3L));
        inputEvents.add(new StreamRecord((Object)end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1b}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1a, middleEvent1b}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent1a, middleEvent1b})}));
    }

    @Test
    public void testRepeatingPatternWSameElement() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middle1Event1 = new Event(40, "a", 2.0);
        Event middle1Event2 = new Event(40, "a", 3.0);
        Event middle1Event3 = new Event(40, "a", 4.0);
        Event middle2Event1 = new Event(40, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middle1Event1, 3L));
        inputEvents.add(new StreamRecord((Object)middle1Event1, 3L));
        inputEvents.add(new StreamRecord((Object)middle1Event2, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(40, "d", 6.0), 5L));
        inputEvents.add(new StreamRecord((Object)middle2Event1, 6L));
        inputEvents.add(new StreamRecord((Object)middle1Event3, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middle1Event1}), Lists.newArrayList((Object[])new Event[]{startEvent, middle1Event1, middle1Event1}), Lists.newArrayList((Object[])new Event[]{startEvent, middle2Event1, middle1Event3}), Lists.newArrayList((Object[])new Event[]{startEvent, middle1Event1, middle1Event1, middle1Event2}), Lists.newArrayList((Object[])new Event[]{startEvent, middle1Event1, middle2Event1, middle1Event3}), Lists.newArrayList((Object[])new Event[]{startEvent, middle1Event1, middle1Event1, middle1Event2, middle1Event3}), Lists.newArrayList((Object[])new Event[]{startEvent, middle1Event1, middle1Event1, middle2Event1, middle1Event3}), Lists.newArrayList((Object[])new Event[]{startEvent, middle1Event1, middle1Event1, middle1Event2, middle2Event1, middle1Event3})}));
    }
}

