/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.avro.generic.GenericData;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AvroKryoSerializerRegistrationsTest {
    AvroKryoSerializerRegistrationsTest() {
    }

    @Test
    void testDefaultKryoRegisteredClassesDidNotChange() throws Exception {
        Kryo kryo = new KryoSerializer(Integer.class, (SerializerConfig)new SerializerConfigImpl()).getKryo();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("flink_11-kryo_registrations")));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(",");
                int tag = Integer.parseInt(split[0]);
                String registeredClass = split[1];
                Registration registration = kryo.getRegistration(tag);
                if (registration == null) {
                    Assertions.fail((String)String.format("Registration for %d = %s got lost", tag, registeredClass));
                    continue;
                }
                if (registeredClass.equals(registration.getType().getName())) continue;
                Assertions.fail((String)String.format("Registration for %d = %s changed to %s", tag, registeredClass, registration.getType().getName()));
            }
        }
    }

    @Test
    void testEnableForceKryoAvroRegister() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        ((SerializerConfigImpl)executionConfig.getSerializerConfig()).setForceKryoAvro(true);
        Kryo kryo = new KryoSerializer(Integer.class, executionConfig.getSerializerConfig()).getKryo();
        kryo.setRegistrationRequired(true);
        Assertions.assertThatCode(() -> kryo.getRegistration(GenericData.Array.class)).doesNotThrowAnyException();
    }

    @Test
    void testDefaultForceKryoAvroRegister() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        Kryo kryo = new KryoSerializer(Integer.class, executionConfig.getSerializerConfig()).getKryo();
        kryo.setRegistrationRequired(true);
        Assertions.assertThatCode(() -> kryo.getRegistration(GenericData.Array.class)).doesNotThrowAnyException();
    }

    @Test
    void testDisableForceKryoAvroRegister() {
        Configuration configuration = new Configuration();
        configuration.set(PipelineOptions.FORCE_KRYO_AVRO, (Object)false);
        ExecutionConfig executionConfig = new ExecutionConfig(configuration);
        Kryo kryo = new KryoSerializer(Integer.class, executionConfig.getSerializerConfig()).getKryo();
        kryo.setRegistrationRequired(true);
        Assertions.assertThatThrownBy(() -> kryo.getRegistration(GenericData.Array.class)).isInstanceOf(IllegalArgumentException.class);
    }

    private void writeDefaultKryoRegistrations(String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists()) {
            Assertions.assertThat((boolean)file.delete()).isTrue();
        }
        Kryo kryo = new KryoSerializer(Integer.class, (SerializerConfig)new SerializerConfigImpl()).getKryo();
        int nextId = kryo.getNextRegistrationId();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (int i = 0; i < nextId; ++i) {
                Registration registration = kryo.getRegistration(i);
                String str = registration.getId() + "," + registration.getType().getName();
                writer.write(str, 0, str.length());
                writer.newLine();
            }
            System.out.println("Created file with registrations at " + file.getAbsolutePath());
        }
    }
}

