/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.formats.avro.AvroRowDataDeserializationSchema;
import org.apache.flink.formats.avro.AvroRowDataSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.TestDynamicTableFactory;
import org.apache.flink.table.factories.utils.FactoryMocks;
import org.apache.flink.table.runtime.connector.source.ScanRuntimeProviderContext;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

class AvroFormatFactoryTest {
    private static final ResolvedSchema SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.BOOLEAN()), Column.physical((String)"d", (DataType)DataTypes.TIMESTAMP((int)3))});
    private static final ResolvedSchema NEW_SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.BOOLEAN()), Column.physical((String)"d", (DataType)DataTypes.TIMESTAMP((int)3)), Column.physical((String)"e", (DataType)DataTypes.TIMESTAMP((int)6)), Column.physical((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)), Column.physical((String)"g", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)6))});
    private static final RowType ROW_TYPE = (RowType)SCHEMA.toPhysicalRowDataType().getLogicalType();
    private static final RowType NEW_ROW_TYPE = (RowType)NEW_SCHEMA.toPhysicalRowDataType().getLogicalType();

    AvroFormatFactoryTest() {
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSeDeSchema(AvroFormatOptions.AvroEncoding encoding) {
        AvroRowDataDeserializationSchema expectedDeser = new AvroRowDataDeserializationSchema(ROW_TYPE, (TypeInformation)InternalTypeInfo.of((RowType)ROW_TYPE), encoding);
        Map<String, String> options = this.getAllOptions(true);
        DynamicTableSource actualSource = FactoryMocks.createTableSource((ResolvedSchema)SCHEMA, options);
        Assertions.assertThat((Object)actualSource).isInstanceOf(TestDynamicTableFactory.DynamicTableSourceMock.class);
        TestDynamicTableFactory.DynamicTableSourceMock scanSourceMock = (TestDynamicTableFactory.DynamicTableSourceMock)actualSource;
        DeserializationSchema actualDeser = (DeserializationSchema)scanSourceMock.valueFormat.createRuntimeDecoder((DynamicTableSource.Context)ScanRuntimeProviderContext.INSTANCE, SCHEMA.toPhysicalRowDataType());
        Assertions.assertThat((Object)actualDeser).isEqualTo((Object)expectedDeser);
        AvroRowDataSerializationSchema expectedSer = new AvroRowDataSerializationSchema(ROW_TYPE, encoding);
        DynamicTableSink actualSink = FactoryMocks.createTableSink((ResolvedSchema)SCHEMA, options);
        Assertions.assertThat((Object)actualSink).isInstanceOf(TestDynamicTableFactory.DynamicTableSinkMock.class);
        TestDynamicTableFactory.DynamicTableSinkMock sinkMock = (TestDynamicTableFactory.DynamicTableSinkMock)actualSink;
        SerializationSchema actualSer = (SerializationSchema)sinkMock.valueFormat.createRuntimeEncoder(null, SCHEMA.toPhysicalRowDataType());
        Assertions.assertThat((Object)actualSer).isEqualTo((Object)expectedSer);
    }

    @Test
    void testOldSeDeNewSchema() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new AvroRowDataDeserializationSchema(NEW_ROW_TYPE, (TypeInformation)InternalTypeInfo.of((RowType)NEW_ROW_TYPE))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Avro does not support TIMESTAMP type with precision: 6, it only supports precision less than 3.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new AvroRowDataSerializationSchema(NEW_ROW_TYPE)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Avro does not support TIMESTAMP type with precision: 6, it only supports precision less than 3.");
    }

    @Test
    void testNewSeDeNewSchema() {
        this.testSeDeSchema(NEW_ROW_TYPE, NEW_SCHEMA, false);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSeDeSchema(boolean legacyTimestampMapping) {
        this.testSeDeSchema(ROW_TYPE, SCHEMA, legacyTimestampMapping);
    }

    void testSeDeSchema(RowType rowType, ResolvedSchema schema, boolean legacyTimestampMapping) {
        AvroRowDataDeserializationSchema expectedDeser = new AvroRowDataDeserializationSchema(rowType, (TypeInformation)InternalTypeInfo.of((RowType)rowType), AvroFormatOptions.AvroEncoding.BINARY, legacyTimestampMapping);
        Map<String, String> options = this.getAllOptions(legacyTimestampMapping);
        DynamicTableSource actualSource = FactoryMocks.createTableSource((ResolvedSchema)schema, options);
        Assertions.assertThat((Object)actualSource).isInstanceOf(TestDynamicTableFactory.DynamicTableSourceMock.class);
        TestDynamicTableFactory.DynamicTableSourceMock scanSourceMock = (TestDynamicTableFactory.DynamicTableSourceMock)actualSource;
        DeserializationSchema actualDeser = (DeserializationSchema)scanSourceMock.valueFormat.createRuntimeDecoder((DynamicTableSource.Context)ScanRuntimeProviderContext.INSTANCE, schema.toPhysicalRowDataType());
        Assertions.assertThat((Object)actualDeser).isEqualTo((Object)expectedDeser);
        AvroRowDataSerializationSchema expectedSer = new AvroRowDataSerializationSchema(rowType, AvroFormatOptions.AvroEncoding.BINARY, legacyTimestampMapping);
        DynamicTableSink actualSink = FactoryMocks.createTableSink((ResolvedSchema)schema, options);
        Assertions.assertThat((Object)actualSink).isInstanceOf(TestDynamicTableFactory.DynamicTableSinkMock.class);
        TestDynamicTableFactory.DynamicTableSinkMock sinkMock = (TestDynamicTableFactory.DynamicTableSinkMock)actualSink;
        SerializationSchema actualSer = (SerializationSchema)sinkMock.valueFormat.createRuntimeEncoder(null, schema.toPhysicalRowDataType());
        Assertions.assertThat((Object)actualSer).isEqualTo((Object)expectedSer);
    }

    private Map<String, String> getAllOptions(boolean legacyTimestampMapping) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "test-connector");
        options.put("target", "MyTarget");
        options.put("buffer-size", "1000");
        if (!legacyTimestampMapping) {
            options.put("avro.timestamp_mapping.legacy", "false");
        }
        options.put("format", "avro");
        return options;
    }
}

