/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata.schema.parser;

import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DictColumnMetadata;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.schema.parser.SchemaExprParser;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaParser {
    @Test
    public void checkQuotedIdWithEscapes() throws Exception {
        String schemaWithEscapes = "`a\\\\b\\`c` INT";
        Assert.assertEquals((Object)schemaWithEscapes, (Object)SchemaExprParser.parseSchema((String)schemaWithEscapes).metadata(0).columnString());
        String schemaWithKeywords = "`INTEGER` INT";
        Assert.assertEquals((Object)schemaWithKeywords, (Object)SchemaExprParser.parseSchema((String)schemaWithKeywords).metadata(0).columnString());
    }

    @Test
    public void testSchemaWithParen() throws Exception {
        String schemaWithParen = "(`a` INT NOT NULL, `b` VARCHAR(10))";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)schemaWithParen);
        Assert.assertEquals((long)2L, (long)schema.size());
        Assert.assertEquals((Object)"`a` INT NOT NULL", (Object)schema.metadata("a").columnString());
        Assert.assertEquals((Object)"`b` VARCHAR(10)", (Object)schema.metadata("b").columnString());
    }

    @Test
    public void testSkip() throws Exception {
        String schemaString = "id\n/*comment*/int\r,//comment\r\nname\nvarchar\t\t\t";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)schemaString);
        Assert.assertEquals((long)2L, (long)schema.size());
        Assert.assertEquals((Object)"`id` INT", (Object)schema.metadata("id").columnString());
        Assert.assertEquals((Object)"`name` VARCHAR", (Object)schema.metadata("name").columnString());
    }

    @Test
    public void testCaseInsensitivity() throws Exception {
        String schema = "`Id` InTeGeR NoT NuLl";
        Assert.assertEquals((Object)"`Id` INT NOT NULL", (Object)SchemaExprParser.parseSchema((String)schema).metadata(0).columnString());
    }

    @Test
    public void testParseColumn() throws Exception {
        ColumnMetadata column = SchemaExprParser.parseColumn((String)"col int not null");
        Assert.assertEquals((Object)"`col` INT NOT NULL", (Object)column.columnString());
    }

    @Test
    public void testNumericTypes() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addNullable("int_col", TypeProtos.MinorType.INT).add("integer_col", TypeProtos.MinorType.INT).addNullable("bigint_col", TypeProtos.MinorType.BIGINT).add("float_col", TypeProtos.MinorType.FLOAT4).addNullable("double_col", TypeProtos.MinorType.FLOAT8).buildSchema();
        this.checkSchema("int_col int, integer_col integer not null, bigint_col bigint, float_col float not null, double_col double", schema);
    }

    @Test
    public void testDecimalTypes() {
        TupleMetadata schema = new SchemaBuilder().addNullable("col", TypeProtos.MinorType.VARDECIMAL).add("col_p", TypeProtos.MinorType.VARDECIMAL, 5).addDecimal("col_ps", TypeProtos.MinorType.VARDECIMAL, TypeProtos.DataMode.OPTIONAL, 10, 2).buildSchema();
        List<String> schemas = Arrays.asList("col dec, col_p dec(5) not null, col_ps dec(10, 2)", "col decimal, col_p decimal(5) not null, col_ps decimal(10, 2)", "col numeric, col_p numeric(5) not null, col_ps numeric(10, 2)");
        schemas.forEach(s -> {
            try {
                this.checkSchema((String)s, schema);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testBooleanType() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addNullable("col", TypeProtos.MinorType.BIT).buildSchema();
        this.checkSchema("col boolean", schema);
    }

    @Test
    public void testCharacterTypes() {
        String schemaPattern = "col %1$s, col_p %1$s(50) not null";
        HashMap<String, TypeProtos.MinorType> properties = new HashMap<String, TypeProtos.MinorType>();
        properties.put("char", TypeProtos.MinorType.VARCHAR);
        properties.put("character", TypeProtos.MinorType.VARCHAR);
        properties.put("character varying", TypeProtos.MinorType.VARCHAR);
        properties.put("varchar", TypeProtos.MinorType.VARCHAR);
        properties.put("binary", TypeProtos.MinorType.VARBINARY);
        properties.put("varbinary", TypeProtos.MinorType.VARBINARY);
        properties.forEach((key, value) -> {
            TupleMetadata schema = new SchemaBuilder().addNullable("col", value).add("col_p", value, 50).buildSchema();
            try {
                this.checkSchema(String.format(schemaPattern, key), schema);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testTimeTypes() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addNullable("time_col", TypeProtos.MinorType.TIME).addNullable("time_prec_col", TypeProtos.MinorType.TIME, 3).add("date_col", TypeProtos.MinorType.DATE).addNullable("timestamp_col", TypeProtos.MinorType.TIMESTAMP).addNullable("timestamp_prec_col", TypeProtos.MinorType.TIMESTAMP, 3).buildSchema();
        this.checkSchema("time_col time, time_prec_col time(3), date_col date not null, timestamp_col timestamp, timestamp_prec_col timestamp(3)", schema);
    }

    @Test
    public void testInterval() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addNullable("interval_year_col", TypeProtos.MinorType.INTERVALYEAR).addNullable("interval_month_col", TypeProtos.MinorType.INTERVALYEAR).addNullable("interval_day_col", TypeProtos.MinorType.INTERVALDAY).addNullable("interval_hour_col", TypeProtos.MinorType.INTERVALDAY).addNullable("interval_minute_col", TypeProtos.MinorType.INTERVALDAY).addNullable("interval_second_col", TypeProtos.MinorType.INTERVALDAY).addNullable("interval_col", TypeProtos.MinorType.INTERVAL).buildSchema();
        this.checkSchema("interval_year_col interval year, interval_month_col interval month, interval_day_col interval day, interval_hour_col interval hour, interval_minute_col interval minute, interval_second_col interval second, interval_col interval", schema);
    }

    @Test
    public void testAdditionalParquetTypes() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addNullable("uint1_col", TypeProtos.MinorType.UINT1).addNullable("uint2_col", TypeProtos.MinorType.UINT2).addNullable("uint4_col", TypeProtos.MinorType.UINT4).addNullable("uint8_col", TypeProtos.MinorType.UINT8).addNullable("tinyint_col", TypeProtos.MinorType.TINYINT).addNullable("smallint_col", TypeProtos.MinorType.SMALLINT).buildSchema();
        this.checkSchema("uint1_col uint1, uint2_col uint2, uint4_col uint4, uint8_col uint8, tinyint_col tinyint, smallint_col smallint", schema);
    }

    @Test
    public void testArray() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addArray("simple_array", TypeProtos.MinorType.INT).addRepeatedList("nested_array").addArray(TypeProtos.MinorType.INT).resumeSchema().addMapArray("struct_array").addNullable("s1", TypeProtos.MinorType.INT).addNullable("s2", TypeProtos.MinorType.VARCHAR).resumeSchema().addRepeatedList("nested_array_struct").addMapArray().addNullable("ns1", TypeProtos.MinorType.INT).addNullable("ns2", TypeProtos.MinorType.VARCHAR).resumeList().resumeSchema().addDictArray("map_array", TypeProtos.MinorType.VARCHAR).nullableValue(TypeProtos.MinorType.INT).resumeSchema().addRepeatedList("nested_map_array").addDictArray().key(TypeProtos.MinorType.VARCHAR).nullableValue(TypeProtos.MinorType.INT).resumeList().resumeSchema().addList("union_array").addType(TypeProtos.MinorType.BIGINT).addType(TypeProtos.MinorType.DATE).resumeSchema().buildSchema();
        this.checkSchema("simple_array array<int>, nested_array array<array<int>>, struct_array array<struct<s1 int, s2 varchar>>, nested_array_struct array<array<struct<ns1 int, ns2 varchar>>>, map_array array<map<varchar, int>>, nested_map_array array<array<map<varchar, int>>>, union_array array<union>", schema);
    }

    @Test
    public void testStruct() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addMap("struct_col").addNullable("int_col", TypeProtos.MinorType.INT).addArray("array_col", TypeProtos.MinorType.INT).addMap("nested_struct").addNullable("s1", TypeProtos.MinorType.INT).addNullable("s2", TypeProtos.MinorType.VARCHAR).resumeMap().addDict("map_col", TypeProtos.MinorType.VARCHAR).nullableValue(TypeProtos.MinorType.INT).resumeMap().addUnion("union_col").addType(TypeProtos.MinorType.INT).resumeMap().resumeSchema().buildSchema();
        this.checkSchema("struct_col struct<int_col int, array_col array<int>, nested_struct struct<s1 int, s2 varchar>, map_col map<varchar, int>, union_col union>", schema);
    }

    @Test
    public void testMap() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addDict("dict_col_simple", TypeProtos.MinorType.VARCHAR).nullableValue(TypeProtos.MinorType.INT).resumeSchema().addDict("dict_col_simple_ps", TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARCHAR).setPrecision(50).setMode(TypeProtos.DataMode.REQUIRED).build()).value(TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setPrecision(10).setScale(2).setMode(TypeProtos.DataMode.REQUIRED).build()).resumeSchema().addDict("dict_col_struct", TypeProtos.MinorType.INT).mapValue().add("sb", TypeProtos.MinorType.BIT).addNullable("si", TypeProtos.MinorType.INT).resumeDict().resumeSchema().addDict("dict_col_dict", TypeProtos.MinorType.VARCHAR).dictValue().key(TypeProtos.MinorType.INT).nullableValue(TypeProtos.MinorType.BIT).resumeDict().resumeSchema().addDict("dict_col_array", TypeProtos.MinorType.BIGINT).dictArrayValue().key(TypeProtos.MinorType.DATE).nullableValue(TypeProtos.MinorType.FLOAT8).resumeDict().resumeSchema().addDict("dict_col_union", TypeProtos.MinorType.BIGINT).unionValue().addType(TypeProtos.MinorType.INT).resumeDict().resumeSchema().buildSchema();
        this.checkSchema("dict_col_simple map<varchar, int>, dict_col_simple_ps map<varchar(50), decimal(10, 2) not null>, dict_col_struct map<int, struct<sb boolean not null, si int>>, dict_col_dict map<varchar, map<int, boolean>>, dict_col_array map<bigint, array<map<date, double>>>, dict_col_union map<bigint, union>", schema);
    }

    @Test
    public void testUnion() throws Exception {
        TupleMetadata schema = new SchemaBuilder().addUnion("col_union_not_null").addType(TypeProtos.MinorType.INT).addType(TypeProtos.MinorType.VARCHAR).resumeSchema().addUnion("col_union_null").addType(TypeProtos.MinorType.INT).resumeSchema().buildSchema();
        this.checkSchema("col_union_not_null union not null, col_union_null union", schema);
    }

    @Test
    public void testModeForSimpleType() throws Exception {
        TupleMetadata schema = SchemaExprParser.parseSchema((String)"id int not null, name varchar");
        Assert.assertFalse((boolean)schema.metadata("id").isNullable());
        Assert.assertTrue((boolean)schema.metadata("name").isNullable());
    }

    @Test
    public void testModeForStructType() throws Exception {
        TupleMetadata schema = SchemaExprParser.parseSchema((String)"s struct<s1 int not null, s2 varchar>");
        ColumnMetadata struct = schema.metadata("s");
        Assert.assertTrue((boolean)struct.isMap());
        Assert.assertEquals((Object)TypeProtos.DataMode.REQUIRED, (Object)struct.mode());
        TupleMetadata mapSchema = struct.tupleSchema();
        Assert.assertFalse((boolean)mapSchema.metadata("s1").isNullable());
        Assert.assertTrue((boolean)mapSchema.metadata("s2").isNullable());
    }

    @Test
    public void testModeForMapType() throws Exception {
        TupleMetadata schema = SchemaExprParser.parseSchema((String)"m1 map<varchar, int>, m2 map<varchar not null, int not null>");
        ColumnMetadata mapOptional = schema.metadata("m1");
        Assert.assertTrue((boolean)mapOptional.isDict());
        Assert.assertEquals((Object)TypeProtos.DataMode.REQUIRED, (Object)mapOptional.mode());
        DictColumnMetadata dictOptional = (DictColumnMetadata)mapOptional;
        Assert.assertEquals((Object)TypeProtos.DataMode.REQUIRED, (Object)dictOptional.keyColumnMetadata().mode());
        Assert.assertEquals((Object)TypeProtos.DataMode.OPTIONAL, (Object)dictOptional.valueColumnMetadata().mode());
        ColumnMetadata mapRequired = schema.metadata("m2");
        Assert.assertTrue((boolean)mapRequired.isDict());
        Assert.assertEquals((Object)TypeProtos.DataMode.REQUIRED, (Object)mapRequired.mode());
        DictColumnMetadata dictRequired = (DictColumnMetadata)mapRequired;
        Assert.assertEquals((Object)TypeProtos.DataMode.REQUIRED, (Object)dictRequired.keyColumnMetadata().mode());
        Assert.assertEquals((Object)TypeProtos.DataMode.REQUIRED, (Object)dictRequired.valueColumnMetadata().mode());
    }

    @Test
    public void testModeForRepeatedType() throws Exception {
        TupleMetadata schema = SchemaExprParser.parseSchema((String)"a array<int>, aa array<array<int>>, sa array<struct<s1 int not null, s2 varchar>>, ma array<map<varchar, array<int>>>");
        Assert.assertTrue((boolean)schema.metadata("a").isArray());
        ColumnMetadata nestedArray = schema.metadata("aa");
        Assert.assertTrue((boolean)nestedArray.isArray());
        Assert.assertTrue((boolean)nestedArray.childSchema().isArray());
        ColumnMetadata structArray = schema.metadata("sa");
        Assert.assertTrue((boolean)structArray.isArray());
        Assert.assertTrue((boolean)structArray.isMap());
        TupleMetadata structSchema = structArray.tupleSchema();
        Assert.assertFalse((boolean)structSchema.metadata("s1").isNullable());
        Assert.assertTrue((boolean)structSchema.metadata("s2").isNullable());
        ColumnMetadata mapArray = schema.metadata("ma");
        Assert.assertTrue((boolean)mapArray.isArray());
        Assert.assertTrue((boolean)mapArray.isDict());
        DictColumnMetadata dictMetadata = (DictColumnMetadata)mapArray;
        Assert.assertFalse((boolean)dictMetadata.keyColumnMetadata().isNullable());
        Assert.assertTrue((boolean)dictMetadata.valueColumnMetadata().isArray());
    }

    @Test
    public void testFormat() throws Exception {
        String value = "`a` DATE NOT NULL FORMAT 'yyyy-MM-dd'";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)value);
        ColumnMetadata columnMetadata = schema.metadata("a");
        Assert.assertEquals((Object)"yyyy-MM-dd", (Object)columnMetadata.format());
        Assert.assertEquals((Object)value, (Object)columnMetadata.columnString());
    }

    @Test
    public void testDefault() throws Exception {
        String value = "`a` INT NOT NULL DEFAULT '12'";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)value);
        ColumnMetadata columnMetadata = schema.metadata("a");
        Assert.assertTrue((boolean)(columnMetadata.decodeDefaultValue() instanceof Integer));
        Assert.assertEquals((Object)12, (Object)columnMetadata.decodeDefaultValue());
        Assert.assertEquals((Object)"12", (Object)columnMetadata.defaultValue());
        Assert.assertEquals((Object)value, (Object)columnMetadata.columnString());
    }

    @Test
    public void testFormatAndDefault() throws Exception {
        String value = "`a` DATE NOT NULL FORMAT 'yyyy-MM-dd' DEFAULT '2018-12-31'";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)value);
        ColumnMetadata columnMetadata = schema.metadata("a");
        Assert.assertTrue((boolean)(columnMetadata.decodeDefaultValue() instanceof LocalDate));
        Assert.assertEquals((Object)LocalDate.of(2018, 12, 31), (Object)columnMetadata.decodeDefaultValue());
        Assert.assertEquals((Object)"2018-12-31", (Object)columnMetadata.defaultValue());
        Assert.assertEquals((Object)value, (Object)columnMetadata.columnString());
    }

    @Test
    public void testColumnProperties() throws Exception {
        String value = "`a` INT NOT NULL PROPERTIES { 'k1' = 'v1', 'k2' = 'v2' }";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)value);
        ColumnMetadata columnMetadata = schema.metadata("a");
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("k1", "v1");
        properties.put("k2", "v2");
        Assert.assertEquals(properties, (Object)columnMetadata.properties());
        Assert.assertEquals((Object)value, (Object)columnMetadata.columnString());
    }

    @Test
    public void testEmptySchema() throws Exception {
        Assert.assertEquals((long)0L, (long)SchemaExprParser.parseSchema((String)"").size());
        Assert.assertEquals((long)0L, (long)SchemaExprParser.parseSchema((String)"  ").size());
        Assert.assertEquals((long)0L, (long)SchemaExprParser.parseSchema((String)"\n").size());
        Assert.assertEquals((long)0L, (long)SchemaExprParser.parseSchema((String)"  \n").size());
    }

    @Test
    public void testEmptySchemaWithParentheses() throws Exception {
        Assert.assertEquals((long)0L, (long)SchemaExprParser.parseSchema((String)"()").size());
        Assert.assertEquals((long)0L, (long)SchemaExprParser.parseSchema((String)"(  )").size());
        Assert.assertEquals((long)0L, (long)SchemaExprParser.parseSchema((String)"(\n)\n").size());
    }

    @Test
    public void testEmptySchemaWithProperties() throws Exception {
        String value = "() properties { `drill.strict` = `false` }";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)value);
        Assert.assertTrue((boolean)schema.isEmpty());
        Assert.assertEquals((Object)"false", (Object)schema.property("drill.strict"));
    }

    @Test
    public void testSchemaWithProperties() throws Exception {
        String value = "(col int properties { `drill.blank-as` = `0` } ) properties { `drill.strict` = `false`, `drill.my-prop` = `abc` }";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)value);
        Assert.assertEquals((long)1L, (long)schema.size());
        ColumnMetadata column = schema.metadata("col");
        Assert.assertEquals((Object)"0", (Object)column.property("drill.blank-as"));
        Assert.assertEquals((Object)"false", (Object)schema.property("drill.strict"));
        Assert.assertEquals((Object)"abc", (Object)schema.property("drill.my-prop"));
    }

    private void checkSchema(String schemaString, TupleMetadata expectedSchema) throws IOException {
        TupleMetadata actualSchema = SchemaExprParser.parseSchema((String)schemaString);
        Assert.assertEquals((long)expectedSchema.size(), (long)actualSchema.size());
        Assert.assertEquals((Object)expectedSchema.properties(), (Object)actualSchema.properties());
        expectedSchema.toMetadataList().forEach(expectedMetadata -> {
            ColumnMetadata actualMetadata = actualSchema.metadata(expectedMetadata.name());
            Assert.assertEquals((Object)expectedMetadata.columnString(), (Object)actualMetadata.columnString());
        });
    }

    @Test
    public void testDynamicColumn() throws IOException {
        String input = "(`a` LATE, `b` DYNAMIC)";
        TupleMetadata schema = SchemaExprParser.parseSchema((String)input);
        Assert.assertEquals((long)2L, (long)schema.size());
        Assert.assertEquals((Object)"`a` DYNAMIC", (Object)schema.metadata("a").columnString());
        Assert.assertEquals((Object)"`b` DYNAMIC", (Object)schema.metadata("b").columnString());
    }
}

