/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata.schema.parser;

import java.io.IOException;
import org.apache.drill.exec.record.metadata.schema.parser.SchemaExprParser;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestParserErrorHandling {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testUnsupportedType() throws Exception {
        String schema = "col unk_type";
        this.thrown.expect(IOException.class);
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testVarcharWithScale() throws Exception {
        String schema = "col varchar(1, 2)";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("missing ')' at ','");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testUnquotedKeyword() throws Exception {
        String schema = "int varchar";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("mismatched input 'int'");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testUnquotedId() throws Exception {
        String schema = "id with space varchar";
        this.thrown.expect(IOException.class);
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testUnescapedBackTick() throws Exception {
        String schema = "`c`o`l` varchar";
        this.thrown.expect(IOException.class);
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testUnescapedBackSlash() throws Exception {
        String schema = "`c\\o\\l` varchar";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("extraneous input '`'");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testMissingType() throws Exception {
        String schema = "col not null";
        this.thrown.expect(IOException.class);
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testIncorrectEOF() throws Exception {
        String schema = "col int not null footer";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("extraneous input 'footer'");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testSchemaWithOneParen() throws Exception {
        String schema = "(col int not null";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("missing ')' at '<EOF>'");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testMissingAngleBracket() throws Exception {
        String schema = "col array<int not null";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("missing '>' at 'not'");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testUnclosedAngleBracket() throws Exception {
        String schema = "col struct<m array<int> not null";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("missing '>' at '<EOF>'");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testMissingColumnNameForStruct() throws Exception {
        String schema = "col struct<int> not null";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("mismatched input 'int' expecting {ID, QUOTED_ID}");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testIncorrectMapKeyType() throws Exception {
        String schema = "col map<array<int>, varchar>";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("mismatched input 'array' expecting {'INT', 'INTEGER',");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testMapKeyWithName() throws Exception {
        String schema = "col map<`key` int, `value` varchar>";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("extraneous input '`key`' expecting {'INT', 'INTEGER',");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testMapMissingComma() throws Exception {
        String schema = "col map<int varchar>";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("missing ',' at 'varchar'");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testMissingNotBeforeNull() throws Exception {
        String schema = "col int null";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("extraneous input 'null'");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testExtraComma() throws Exception {
        String schema = "id int,, name varchar";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("extraneous input ',' expecting {ID, QUOTED_ID}");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void testExtraCommaEOF() throws Exception {
        String schema = "id int, name varchar,";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("mismatched input '<EOF>' expecting {ID, QUOTED_ID}");
        SchemaExprParser.parseSchema((String)schema);
    }

    @Test
    public void incorrectNumber() throws Exception {
        String schema = "id decimal(5, 02)";
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("extraneous input '2' expecting ')'");
        SchemaExprParser.parseSchema((String)schema);
    }
}

