/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import java.nio.charset.StandardCharsets;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.junit.Assert;
import org.junit.Test;

public class VariableLengthVectorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingSameValueCount() {
        try (RootAllocator allocator = new RootAllocator(10000000L);){
            MaterializedField field = MaterializedField.create((String)"stringCol", (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
            VarCharVector vector = new VarCharVector(field, (BufferAllocator)allocator);
            vector.allocateNew();
            try {
                int size = 1000;
                VarCharVector.Mutator mutator = vector.getMutator();
                VarCharVector.Accessor accessor = vector.getAccessor();
                VariableLengthVectorTest.setSafeIndexStrings("", 0, size, mutator);
                mutator.setValueCount(size);
                Assert.assertEquals((long)size, (long)accessor.getValueCount());
                VariableLengthVectorTest.checkIndexStrings("", 0, size, accessor);
            }
            finally {
                vector.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrunicateVectorSetValueCount() {
        try (RootAllocator allocator = new RootAllocator(10000000L);){
            MaterializedField field = MaterializedField.create((String)"stringCol", (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
            VarCharVector vector = new VarCharVector(field, (BufferAllocator)allocator);
            vector.allocateNew();
            try {
                int size = 1000;
                int fluffSize = 10000;
                VarCharVector.Mutator mutator = vector.getMutator();
                VarCharVector.Accessor accessor = vector.getAccessor();
                VariableLengthVectorTest.setSafeIndexStrings("", 0, size, mutator);
                VariableLengthVectorTest.setSafeIndexStrings("first cut ", size, fluffSize, mutator);
                mutator.setValueCount(fluffSize);
                Assert.assertEquals((long)fluffSize, (long)accessor.getValueCount());
                VariableLengthVectorTest.checkIndexStrings("", 0, size, accessor);
            }
            finally {
                vector.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDRILL7341() {
        try (RootAllocator allocator = new RootAllocator(10000000L);){
            MaterializedField field = MaterializedField.create((String)"stringCol", (TypeProtos.MajorType)Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
            NullableVarCharVector sourceVector = new NullableVarCharVector(field, (BufferAllocator)allocator);
            NullableVarCharVector targetVector = new NullableVarCharVector(field, (BufferAllocator)allocator);
            sourceVector.allocateNew();
            targetVector.allocateNew();
            try {
                NullableVarCharVector.Mutator sourceMutator = sourceVector.getMutator();
                sourceMutator.setValueCount(sourceVector.getValueCapacity() * 4);
                targetVector.exchange((ValueVector)sourceVector);
                NullableVarCharVector.Mutator targetMutator = targetVector.getMutator();
                targetMutator.setValueCount(targetVector.getValueCapacity() * 2);
            }
            finally {
                sourceVector.clear();
                targetVector.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetBackTracking() {
        try (RootAllocator allocator = new RootAllocator(10000000L);){
            MaterializedField field = MaterializedField.create((String)"stringCol", (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
            VarCharVector vector = new VarCharVector(field, (BufferAllocator)allocator);
            vector.allocateNew();
            try {
                int size = 1000;
                int fluffSize = 10000;
                VarCharVector.Mutator mutator = vector.getMutator();
                VarCharVector.Accessor accessor = vector.getAccessor();
                VariableLengthVectorTest.setSafeIndexStrings("", 0, size, mutator);
                VariableLengthVectorTest.setSafeIndexStrings("first cut ", size, fluffSize, mutator);
                VariableLengthVectorTest.setSafeIndexStrings("redone cut ", size, fluffSize, mutator);
                mutator.setValueCount(fluffSize);
                Assert.assertEquals((long)fluffSize, (long)accessor.getValueCount());
                VariableLengthVectorTest.checkIndexStrings("", 0, size, accessor);
                VariableLengthVectorTest.checkIndexStrings("redone cut ", size, fluffSize, accessor);
            }
            finally {
                vector.clear();
            }
        }
    }

    public static void setSafeIndexStrings(String prefix, int offset, int size, VarCharVector.Mutator mutator) {
        for (int index = offset; index < size; ++index) {
            String indexString = prefix + "String num " + index;
            mutator.setSafe(index, indexString.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void checkIndexStrings(String prefix, int offset, int size, VarCharVector.Accessor accessor) {
        for (int index = offset; index < size; ++index) {
            String indexString = prefix + "String num " + index;
            Assert.assertArrayEquals((byte[])indexString.getBytes(StandardCharsets.UTF_8), (byte[])accessor.get(index));
        }
    }
}

