/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.complex.EmptyValuePopulator;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.apache.drill.exec.vector.complex.impl.NullableVarCharWriterImpl;
import org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.IntWriter;
import org.apache.drill.test.BaseTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class VectorTest
extends BaseTest {
    private static RootAllocator allocator;

    @BeforeClass
    public static void setup() {
        allocator = new RootAllocator(10000000L);
    }

    @AfterClass
    public static void tearDown() {
        allocator.close();
    }

    @Test
    public void testVarChar() {
        MaterializedField field = MaterializedField.create((String)"stringCol", (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        try (VarCharVector v = new VarCharVector(field, (BufferAllocator)allocator);){
            v.allocateNew(1000, 128);
            VarCharVector.Accessor va = v.getAccessor();
            UInt4Vector ov = v.getOffsetVector();
            UInt4Vector.Accessor ova = ov.getAccessor();
            Assert.assertEquals((long)1024L, (long)v.getBuffer().capacity());
            Assert.assertEquals((long)1024L, (long)ov.getBuffer().capacity());
            v.getBuffer().setZero(0, 1024);
            ov.getBuffer().setZero(0, 1024);
            v.getMutator().setValueCount(0);
            Assert.assertEquals((long)0L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.getValueCount());
            v.getMutator().fillEmpties(-1, 0);
            Assert.assertEquals((long)0L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.getValueCount());
            v.getMutator().setSafe(0, "foo".getBytes(StandardCharsets.UTF_8));
            v.getMutator().setValueCount(1);
            Assert.assertEquals((long)1L, (long)va.getValueCount());
            Assert.assertEquals((long)2L, (long)ova.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.get(0));
            Assert.assertEquals((long)3L, (long)ova.get(1));
            v.getMutator().fillEmpties(0, 2);
            Assert.assertEquals((long)0L, (long)ova.get(0));
            Assert.assertEquals((long)3L, (long)ova.get(1));
            Assert.assertEquals((long)3L, (long)ova.get(2));
            Assert.assertEquals((long)0L, (long)ova.get(3));
            v.getMutator().setSafe(2, "mumble".getBytes(StandardCharsets.UTF_8));
            v.getMutator().setValueCount(2);
            Assert.assertEquals((long)2L, (long)va.getValueCount());
            Assert.assertEquals((long)3L, (long)ova.getValueCount());
            Assert.assertEquals((long)3L, (long)ova.get(1));
            Assert.assertEquals((long)3L, (long)ova.get(2));
            Assert.assertEquals((long)9L, (long)ova.get(3));
        }
    }

    @Test
    public void testNullableVarChar() {
        MaterializedField field = MaterializedField.create((String)"stringCol", (TypeProtos.MajorType)Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        try (NullableVarCharVector v = new NullableVarCharVector(field, (BufferAllocator)allocator);){
            int targetDataLength = 1000;
            int targetValueCount = 128;
            v.allocateNew(targetDataLength, targetValueCount);
            NullableVarCharVector.Accessor va = v.getAccessor();
            NullableVarCharVector.Mutator vm = v.getMutator();
            VarCharVector dv = v.getValuesVector();
            VarCharVector.Accessor da = dv.getAccessor();
            UInt4Vector ov = dv.getOffsetVector();
            UInt4Vector.Accessor ova = ov.getAccessor();
            UInt1Vector bv = v.getBitsVector();
            int actualDataLength = 1024;
            int targetOffsetCount = 2 * targetValueCount;
            Assert.assertEquals((long)actualDataLength, (long)dv.getBuffer().capacity());
            Assert.assertEquals((long)(targetOffsetCount * 4), (long)ov.getBuffer().capacity());
            Assert.assertEquals((long)targetValueCount, (long)bv.getBuffer().capacity());
            v.getBuffer().setZero(0, 1024);
            ov.getBuffer().setZero(0, 1024);
            Assert.assertEquals((long)0L, (long)va.getValueCount());
            Assert.assertEquals((long)-1L, (long)vm.getLastSet());
            Assert.assertEquals((long)0L, (long)bv.getAccessor().getValueCount());
            Assert.assertEquals((long)0L, (long)da.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.get(0));
            Assert.assertEquals((long)0L, (long)ova.get(1));
            v.getMutator().setValueCount(0);
            Assert.assertEquals((long)-1L, (long)vm.getLastSet());
            Assert.assertEquals((long)0L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)bv.getAccessor().getValueCount());
            Assert.assertEquals((long)0L, (long)da.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.get(0));
            Assert.assertEquals((long)0L, (long)ova.get(1));
            v.getMutator().fillEmpties(0);
            Assert.assertEquals((long)0L, (long)vm.getLastSet());
            Assert.assertEquals((long)0L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.get(0));
            Assert.assertEquals((long)0L, (long)ova.get(1));
            byte[] bytes = "foo".getBytes(StandardCharsets.UTF_8);
            vm.setSafe(0, bytes, 0, bytes.length);
            Assert.assertEquals((long)0L, (long)vm.getLastSet());
            vm.setValueCount(1);
            Assert.assertEquals((long)0L, (long)vm.getLastSet());
            Assert.assertEquals((long)1L, (long)va.getValueCount());
            Assert.assertEquals((long)2L, (long)ova.getValueCount());
            Assert.assertEquals((long)0L, (long)ova.get(0));
            Assert.assertEquals((long)bytes.length, (long)ova.get(1));
            v.getMutator().fillEmpties(2);
            Assert.assertEquals((long)2L, (long)vm.getLastSet());
            Assert.assertEquals((long)0L, (long)ova.get(0));
            Assert.assertEquals((long)3L, (long)ova.get(1));
            Assert.assertEquals((long)3L, (long)ova.get(2));
            Assert.assertEquals((long)0L, (long)ova.get(3));
            v.getMutator().fillEmpties(2);
            Assert.assertEquals((long)2L, (long)v.getMutator().getLastSet());
            Assert.assertEquals((long)0L, (long)ova.get(0));
            Assert.assertEquals((long)3L, (long)ova.get(1));
            Assert.assertEquals((long)3L, (long)ova.get(2));
            Assert.assertEquals((long)0L, (long)ova.get(3));
            byte[] second = "mumble".getBytes(StandardCharsets.UTF_8);
            vm.setSafe(2, second, 0, second.length);
            Assert.assertEquals((long)2L, (long)v.getMutator().getLastSet());
            vm.setValueCount(3);
            Assert.assertEquals((long)2L, (long)v.getMutator().getLastSet());
            Assert.assertEquals((long)3L, (long)va.getValueCount());
            Assert.assertEquals((long)4L, (long)ova.getValueCount());
            Assert.assertEquals((long)3L, (long)ova.get(1));
            Assert.assertEquals((long)3L, (long)ova.get(2));
            Assert.assertEquals((long)9L, (long)ova.get(3));
            v.getMutator().setValueCount(5);
            Assert.assertEquals((long)4L, (long)v.getMutator().getLastSet());
            Assert.assertEquals((long)5L, (long)va.getValueCount());
            Assert.assertEquals((long)6L, (long)ova.getValueCount());
            Assert.assertEquals((long)9L, (long)ova.get(3));
            Assert.assertEquals((long)9L, (long)ova.get(4));
            Assert.assertEquals((long)9L, (long)ova.get(5));
            v.getMutator().setValueCount(targetOffsetCount);
            Assert.assertEquals((long)(targetOffsetCount - 1), (long)v.getMutator().getLastSet());
            Assert.assertEquals((long)targetOffsetCount, (long)va.getValueCount());
            Assert.assertEquals((long)(targetOffsetCount + 1), (long)ova.getValueCount());
            Assert.assertEquals((long)9L, (long)ova.get(targetOffsetCount - 1));
            Assert.assertEquals((long)9L, (long)ova.get(targetOffsetCount));
            Assert.assertEquals((long)0L, (long)ova.get(targetOffsetCount + 1));
        }
    }

    @Test
    public void testNullableVarCharWriter() throws Exception {
        MaterializedField field = MaterializedField.create((String)"stringCol", (TypeProtos.MajorType)Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        try (NullableVarCharVector v = new NullableVarCharVector(field, (BufferAllocator)allocator);
             DrillBuf buf = allocator.buffer(100);){
            v.allocateNew(1000, 128);
            NullableVarCharWriterImpl w = new NullableVarCharWriterImpl(v, null);
            w.setPosition(0);
            buf.setBytes(0, "foo".getBytes(StandardCharsets.UTF_8));
            w.writeVarChar(0, 3, buf);
            w.setPosition(2);
            buf.setBytes(0, "mumble".getBytes(StandardCharsets.UTF_8));
            w.writeVarChar(0, 6, buf);
            VarCharVector dv = v.getValuesVector();
            UInt4Vector ov = dv.getOffsetVector();
            UInt4Vector.Accessor ova = ov.getAccessor();
            v.getMutator().setValueCount(2);
            Assert.assertEquals((long)2L, (long)v.getAccessor().getValueCount());
            Assert.assertEquals((long)3L, (long)ova.getValueCount());
            Assert.assertEquals((long)3L, (long)ova.get(1));
            Assert.assertEquals((long)3L, (long)ova.get(2));
            Assert.assertEquals((long)9L, (long)ova.get(3));
        }
    }

    @Test
    public void testEmptyValuePopulator() throws Exception {
        MaterializedField field = MaterializedField.create((String)"offsets", (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.UINT4));
        try (UInt4Vector v = new UInt4Vector(field, (BufferAllocator)allocator);){
            EmptyValuePopulator pop = new EmptyValuePopulator(v);
            UInt4Vector.Accessor va = v.getAccessor();
            UInt4Vector.Mutator vm = v.getMutator();
            v.allocateNew(128);
            vm.setValueCount(0);
            Assert.assertEquals((long)0L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)va.get(0));
            pop.populate(0);
            Assert.assertEquals((long)1L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)va.get(0));
            pop.populate(1);
            vm.setValueCount(1);
            Assert.assertEquals((long)1L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)va.get(0));
            Assert.assertEquals((long)0L, (long)va.get(1));
            vm.set(1, 2);
            vm.set(2, 5);
            vm.set(3, 0);
            vm.setValueCount(3);
            Assert.assertEquals((long)3L, (long)va.getValueCount());
            Assert.assertEquals((long)5L, (long)va.get(2));
            Assert.assertEquals((long)0L, (long)va.get(3));
            pop.populate(2);
            Assert.assertEquals((long)3L, (long)va.getValueCount());
            Assert.assertEquals((long)5L, (long)va.get(2));
            Assert.assertEquals((long)0L, (long)va.get(3));
            pop.populate(5);
            Assert.assertEquals((long)6L, (long)va.getValueCount());
            Assert.assertEquals((long)5L, (long)va.get(2));
            Assert.assertEquals((long)5L, (long)va.get(3));
            Assert.assertEquals((long)5L, (long)va.get(4));
            Assert.assertEquals((long)5L, (long)va.get(5));
            Assert.assertEquals((long)0L, (long)va.get(6));
        }
    }

    @Test
    public void testRepeatedMapCount() throws Exception {
        try (RepeatedMapVector v = this.buildRepeatedMap();){
            IntVector iv = this.getInner(v);
            RepeatedMapVector.Accessor va = v.getAccessor();
            RepeatedMapVector.Mutator vm = v.getMutator();
            IntVector.Accessor ia = iv.getAccessor();
            IntVector.Mutator im = iv.getMutator();
            UInt4Vector ov = v.getOffsetVector();
            UInt4Vector.Accessor oa = ov.getAccessor();
            UInt4Vector.Mutator om = ov.getMutator();
            ov.getBuffer().setZero(0, 24);
            Assert.assertEquals((long)0L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)ia.getValueCount());
            Assert.assertEquals((long)0L, (long)oa.getValueCount());
            Assert.assertEquals((long)0L, (long)oa.get(0));
            vm.setValueCount(0);
            Assert.assertEquals((long)0L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)ia.getValueCount());
            Assert.assertEquals((long)0L, (long)oa.getValueCount());
            Assert.assertEquals((long)0L, (long)oa.get(0));
            vm.setValueCount(1);
            Assert.assertEquals((long)1L, (long)va.getValueCount());
            Assert.assertEquals((long)0L, (long)ia.getValueCount());
            Assert.assertEquals((long)2L, (long)oa.getValueCount());
            Assert.assertEquals((long)0L, (long)oa.get(0));
            Assert.assertEquals((long)0L, (long)oa.get(1));
            im.set(0, 10);
            im.set(1, 20);
            im.setValueCount(2);
            om.set(2, 2);
            om.setValueCount(3);
            vm.setValueCount(2);
            Assert.assertEquals((long)2L, (long)va.getValueCount());
            Assert.assertEquals((long)2L, (long)ia.getValueCount());
            Assert.assertEquals((long)3L, (long)oa.getValueCount());
            Assert.assertEquals((long)0L, (long)oa.get(0));
            Assert.assertEquals((long)0L, (long)oa.get(1));
            Assert.assertEquals((long)2L, (long)oa.get(2));
            Assert.assertEquals((long)0L, (long)oa.get(3));
            vm.setValueCount(4);
            Assert.assertEquals((long)4L, (long)va.getValueCount());
            Assert.assertEquals((long)2L, (long)ia.getValueCount());
            Assert.assertEquals((long)5L, (long)oa.getValueCount());
            Assert.assertEquals((long)0L, (long)oa.get(0));
            Assert.assertEquals((long)0L, (long)oa.get(1));
            Assert.assertEquals((long)2L, (long)oa.get(2));
            Assert.assertEquals((long)2L, (long)oa.get(3));
            Assert.assertEquals((long)2L, (long)oa.get(4));
            Assert.assertEquals((long)0L, (long)oa.get(5));
        }
    }

    @Test
    public void testRepeatedCopySafe() throws Exception {
        try (RepeatedMapVector v = this.buildRepeatedMap();
             RepeatedMapVector f = this.buildFromMap();){
            RepeatedMapVector.Mutator vm = v.getMutator();
            UInt4Vector ov = v.getOffsetVector();
            UInt4Vector.Accessor oa = ov.getAccessor();
            UInt4Vector.Mutator om = ov.getMutator();
            TransferPair tp = f.makeTransferPair((ValueVector)v);
            tp.copyValueSafe(0, 0);
            Assert.assertEquals((long)0L, (long)oa.get(0));
            Assert.assertEquals((long)2L, (long)oa.get(1));
            tp.copyValueSafe(1, 1);
            Assert.assertEquals((long)0L, (long)oa.get(0));
            Assert.assertEquals((long)2L, (long)oa.get(1));
            Assert.assertEquals((long)5L, (long)oa.get(2));
            tp.copyValueSafe(2, 2);
            Assert.assertEquals((long)2L, (long)oa.get(1));
            Assert.assertEquals((long)5L, (long)oa.get(2));
            Assert.assertEquals((long)5L, (long)oa.get(3));
            vm.setValueCount(3);
            this.validateFrom(v);
        }
    }

    @Test
    public void testRepeatedMapWriter() throws Exception {
        MaterializedField field = MaterializedField.create((String)"repeated_map", (TypeProtos.MajorType)Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.MAP));
        try (RepeatedMapVector v = new RepeatedMapVector(field, (BufferAllocator)allocator, null);){
            SpecialMapVector mapVector = new SpecialMapVector(v);
            SingleMapWriter mapRoot = new SingleMapWriter((MapVector)mapVector, null, false);
            BaseWriter.ListWriter lw = mapRoot.list("repeated_map");
            BaseWriter.MapWriter mw = lw.map();
            lw.setPosition(0);
            lw.startList();
            mw.start();
            IntWriter iw = mw.integer("inner");
            iw.writeInt(10);
            mw.end();
            mw.start();
            iw.writeInt(20);
            mw.end();
            lw.endList();
            lw.setPosition(1);
            lw.startList();
            mw.start();
            iw.writeInt(30);
            mw.end();
            mw.start();
            iw.writeInt(40);
            mw.end();
            mw.start();
            iw.writeInt(50);
            mw.end();
            lw.endList();
            lw.setPosition(2);
            lw.startList();
            lw.endList();
            v.getMutator().setValueCount(3);
            Assert.assertEquals((long)3L, (long)v.getAccessor().getValueCount());
            UInt4Vector.Accessor oa = v.getOffsetVector().getAccessor();
            Assert.assertEquals((long)4L, (long)oa.getValueCount());
            Assert.assertEquals((long)0L, (long)oa.get(0));
            Assert.assertEquals((long)2L, (long)oa.get(1));
            Assert.assertEquals((long)5L, (long)oa.get(2));
            Assert.assertEquals((long)5L, (long)oa.get(3));
            Assert.assertEquals((long)0L, (long)oa.get(4));
            NullableIntVector inner = (NullableIntVector)v.addOrGet("inner", Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INT), NullableIntVector.class);
            UInt1Vector.Accessor ba = inner.getBitsVector().getAccessor();
            Assert.assertEquals((long)1L, (long)ba.get(0));
            Assert.assertEquals((long)1L, (long)ba.get(1));
            Assert.assertEquals((long)1L, (long)ba.get(2));
            Assert.assertEquals((long)1L, (long)ba.get(3));
            Assert.assertEquals((long)1L, (long)ba.get(4));
            Assert.assertEquals((long)0L, (long)ba.get(5));
            NullableIntVector.Accessor ia = inner.getAccessor();
            Assert.assertEquals((long)10L, (long)ia.get(0));
            Assert.assertEquals((long)20L, (long)ia.get(1));
            Assert.assertEquals((long)30L, (long)ia.get(2));
            Assert.assertEquals((long)40L, (long)ia.get(3));
            Assert.assertEquals((long)50L, (long)ia.get(4));
        }
    }

    private RepeatedMapVector buildRepeatedMap() {
        MaterializedField field = MaterializedField.create((String)"repeated_map", (TypeProtos.MajorType)Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.MAP));
        RepeatedMapVector v = new RepeatedMapVector(field, (BufferAllocator)allocator, null);
        this.getInner(v);
        v.allocateNew(5, 10);
        return v;
    }

    private IntVector getInner(RepeatedMapVector v) {
        return (IntVector)v.addOrGet("inner", Types.required((TypeProtos.MinorType)TypeProtos.MinorType.INT), IntVector.class);
    }

    private RepeatedMapVector buildFromMap() {
        RepeatedMapVector v = this.buildRepeatedMap();
        IntVector iv = this.getInner(v);
        IntVector.Mutator im = iv.getMutator();
        UInt4Vector ov = v.getOffsetVector();
        UInt4Vector.Mutator om = ov.getMutator();
        om.set(0, 0);
        im.set(0, 10);
        im.set(1, 20);
        om.set(1, 2);
        im.set(2, 30);
        im.set(3, 40);
        im.set(4, 50);
        om.set(2, 5);
        om.set(3, 5);
        om.setValueCount(4);
        v.getMutator().setValueCount(3);
        this.validateFrom(v);
        return v;
    }

    private void validateFrom(RepeatedMapVector v) {
        UInt4Vector.Accessor oa = v.getOffsetVector().getAccessor();
        Assert.assertEquals((long)3L, (long)v.getAccessor().getValueCount());
        Assert.assertEquals((long)4L, (long)oa.getValueCount());
        Assert.assertEquals((long)0L, (long)oa.get(0));
        Assert.assertEquals((long)2L, (long)oa.get(1));
        Assert.assertEquals((long)5L, (long)oa.get(2));
        Assert.assertEquals((long)5L, (long)oa.get(3));
        IntVector.Accessor ia = this.getInner(v).getAccessor();
        Assert.assertEquals((long)10L, (long)ia.get(0));
        Assert.assertEquals((long)20L, (long)ia.get(1));
        Assert.assertEquals((long)30L, (long)ia.get(2));
        Assert.assertEquals((long)40L, (long)ia.get(3));
        Assert.assertEquals((long)50L, (long)ia.get(4));
    }

    private class SpecialMapVector
    extends MapVector {
        private final RepeatedMapVector v;

        public SpecialMapVector(RepeatedMapVector v) {
            super("", null, null);
            this.v = v;
        }

        public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
            assert (clazz == RepeatedMapVector.class);
            return (T)this.v;
        }
    }
}

