/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import java.util.HashMap;
import org.apache.drill.categories.RowSetTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.AbstractPropertied;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.Propertied;
import org.apache.drill.exec.record.metadata.PropertyAccessor;
import org.apache.drill.test.BaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTest.class})
public class TestMetadataProperties
extends BaseTest {
    @Test
    public void testBasics() {
        AbstractPropertied props = new AbstractPropertied();
        Assert.assertFalse((boolean)props.hasProperties());
        AbstractPropertied second = new AbstractPropertied(props);
        Assert.assertFalse((boolean)second.hasProperties());
        Assert.assertNull((Object)props.property("foo"));
        Assert.assertFalse((boolean)props.hasProperties());
        props.setProperty("foo", null);
        Assert.assertNull((Object)props.property("foo"));
        Assert.assertFalse((boolean)props.hasProperties());
        Assert.assertNotNull((Object)props.properties());
        Assert.assertTrue((boolean)props.properties().isEmpty());
        Assert.assertFalse((boolean)props.hasProperties());
        props.setProperty("foo", "bar");
        Assert.assertEquals((Object)"bar", (Object)props.property("foo"));
        Assert.assertTrue((boolean)props.hasProperties());
        Assert.assertEquals((Object)"bar", props.properties().get("foo"));
        props.setProperty("foo", null);
        Assert.assertNull((Object)props.property("foo"));
        Assert.assertFalse((boolean)props.hasProperties());
        props.setProperty("foo", "bar");
        props.setProperty("fred", "wilma");
        HashMap<String, String> other = new HashMap<String, String>();
        other.put("fred", "pebbles");
        other.put("barney", "bambam");
        props.setProperties(other);
        Assert.assertTrue((boolean)props.hasProperties());
        Assert.assertEquals((long)3L, (long)props.properties().size());
        Assert.assertEquals((Object)"bar", (Object)props.property("foo"));
        Assert.assertEquals((Object)"pebbles", (Object)props.property("fred"));
        Assert.assertEquals((Object)"bambam", (Object)props.property("barney"));
        second = new AbstractPropertied(props);
        Assert.assertTrue((boolean)second.hasProperties());
        Assert.assertEquals((long)3L, (long)second.properties().size());
    }

    @Test
    public void testAccessor() {
        AbstractPropertied props = new AbstractPropertied();
        Assert.assertEquals((Object)"bar", (Object)PropertyAccessor.getString((Propertied)props, (String)"foo", (String)"bar"));
        Assert.assertEquals((long)10L, (long)PropertyAccessor.getInt((Propertied)props, (String)"foo", (int)10));
        Assert.assertEquals((Object)true, (Object)PropertyAccessor.getBoolean((Propertied)props, (String)"foo", (boolean)true));
        Assert.assertNull((Object)props.property("foo"));
        Assert.assertEquals((long)0L, (long)PropertyAccessor.getInt((Propertied)props, (String)"foo"));
        Assert.assertEquals((Object)false, (Object)PropertyAccessor.getBoolean((Propertied)props, (String)"foo"));
        props.setProperty("str", "value");
        Assert.assertEquals((Object)"value", (Object)props.property("str"));
        PropertyAccessor.set((Propertied)props, (String)"int", (int)20);
        Assert.assertEquals((Object)"20", (Object)props.property("int"));
        Assert.assertEquals((long)20L, (long)PropertyAccessor.getInt((Propertied)props, (String)"int"));
        PropertyAccessor.set((Propertied)props, (String)"bool", (boolean)true);
        Assert.assertEquals((Object)"true", (Object)props.property("bool"));
        Assert.assertEquals((Object)true, (Object)PropertyAccessor.getBoolean((Propertied)props, (String)"bool"));
    }

    @Test
    public void testWidth() {
        PrimitiveColumnMetadata col;
        PrimitiveColumnMetadata props = col = new PrimitiveColumnMetadata("c", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL);
        Assert.assertFalse((boolean)props.hasProperties());
        Assert.assertEquals((long)50L, (long)col.expectedWidth());
        col.setExpectedWidth(20);
        Assert.assertTrue((boolean)props.hasProperties());
        Assert.assertEquals((long)20L, (long)col.expectedWidth());
        Assert.assertEquals((Object)"20", (Object)col.property("drill.width"));
        col.setProperty("drill.width", null);
        Assert.assertFalse((boolean)props.hasProperties());
        Assert.assertEquals((long)50L, (long)col.expectedWidth());
    }

    @Test
    public void testFormat() {
        PrimitiveColumnMetadata col;
        PrimitiveColumnMetadata props = col = new PrimitiveColumnMetadata("c", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL);
        Assert.assertNull((Object)col.format());
        col.setFormat("###");
        Assert.assertEquals((Object)"###", (Object)col.format());
        Assert.assertTrue((boolean)props.hasProperties());
        Assert.assertEquals((Object)"###", (Object)col.property("drill.format"));
        col.setFormat(null);
        Assert.assertFalse((boolean)props.hasProperties());
        Assert.assertNull((Object)col.format());
    }

    @Test
    public void testDefault() {
        PrimitiveColumnMetadata col;
        PrimitiveColumnMetadata props = col = new PrimitiveColumnMetadata("c", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL);
        Assert.assertNull((Object)col.defaultValue());
        col.setDefaultValue("empty");
        Assert.assertEquals((Object)"empty", (Object)col.defaultValue());
        Assert.assertTrue((boolean)props.hasProperties());
        Assert.assertEquals((Object)"empty", (Object)col.property("drill.default"));
        col.setDefaultValue(null);
        Assert.assertFalse((boolean)props.hasProperties());
        Assert.assertNull((Object)col.defaultValue());
    }

    @Test
    public void testStringEncode() {
        PrimitiveColumnMetadata col = new PrimitiveColumnMetadata("c", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL);
        String encoded = col.valueToString((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)encoded);
        col.setDefaultValue(encoded);
        Assert.assertEquals((Object)"foo", (Object)col.decodeDefaultValue());
    }

    @Test
    public void testIntEncode() {
        PrimitiveColumnMetadata col = new PrimitiveColumnMetadata("c", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL);
        String encoded = col.valueToString((Object)20);
        Assert.assertEquals((Object)"20", (Object)encoded);
        Assert.assertEquals((Object)20, (Object)col.valueFromString(encoded));
        col.setDefaultValue(encoded);
        Assert.assertEquals((Object)20, (Object)col.decodeDefaultValue());
    }
}

