/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.MaterializedField;
import org.junit.Assert;
import org.junit.Test;

public class TestMaterializedField {
    @Test
    public void testHashCodeContact() {
        MaterializedField childField = MaterializedField.create((String)new String("child"), (TypeProtos.MajorType)Types.OPTIONAL_BIT);
        MaterializedField field = MaterializedField.create((String)new String("field"), (TypeProtos.MajorType)Types.OPTIONAL_INT);
        MaterializedField equalField = MaterializedField.create((String)new String("field"), (TypeProtos.MajorType)Types.OPTIONAL_INT);
        field.addChild(childField);
        equalField.addChild(childField);
        Assert.assertEquals((long)field.hashCode(), (long)equalField.hashCode());
        equalField = MaterializedField.create((String)new String("FIELD"), (TypeProtos.MajorType)Types.OPTIONAL_INT);
        equalField.addChild(childField);
        Assert.assertEquals((long)field.hashCode(), (long)equalField.hashCode());
        MaterializedField differentField = MaterializedField.create((String)new String("other"), (TypeProtos.MajorType)Types.OPTIONAL_BIT);
        differentField.addChild(childField);
        Assert.assertNotEquals((long)field.hashCode(), (long)differentField.hashCode());
        field = MaterializedField.create(null, (TypeProtos.MajorType)Types.OPTIONAL_INT);
        field.hashCode();
    }

    @Test
    public void testEqualsContract() {
        MaterializedField childField = MaterializedField.create((String)new String("child"), (TypeProtos.MajorType)Types.OPTIONAL_BIT);
        MaterializedField field = MaterializedField.create((String)new String("field"), (TypeProtos.MajorType)Types.OPTIONAL_INT);
        MaterializedField equalField = MaterializedField.create((String)new String("field"), (TypeProtos.MajorType)Types.OPTIONAL_INT);
        field.addChild(childField);
        equalField.addChild(childField);
        Assert.assertEquals((Object)field, (Object)field);
        Assert.assertEquals((Object)field, (Object)equalField);
        Assert.assertEquals((Object)equalField, (Object)field);
        Assert.assertNotEquals((Object)field, null);
        MaterializedField differentField = MaterializedField.create((String)new String("field"), (TypeProtos.MajorType)Types.OPTIONAL_BIT);
        differentField.addChild(childField);
        Assert.assertNotEquals((Object)field, (Object)differentField);
        differentField = MaterializedField.create((String)new String("other"), (TypeProtos.MajorType)Types.OPTIONAL_INT);
        differentField.addChild(childField);
        Assert.assertNotEquals((Object)field, (Object)differentField);
        equalField.addChild(MaterializedField.create((String)"field", (TypeProtos.MajorType)Types.OPTIONAL_BIT));
        Assert.assertEquals((Object)field, (Object)equalField);
        equalField = MaterializedField.create((String)"FIELD", (TypeProtos.MajorType)Types.OPTIONAL_INT);
        equalField.addChild(childField);
        Assert.assertEquals((Object)field, (Object)equalField);
    }
}

