/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.common.base.Stopwatch;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.rpc.NamedThreadFactory;
import org.apache.drill.exec.util.SystemPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportCheck {
    static final Logger logger = LoggerFactory.getLogger(TransportCheck.class);
    private static final String USE_LINUX_EPOLL = "drill.exec.enable-epoll";
    public static final boolean SUPPORTS_EPOLL;

    public static Class<? extends ServerSocketChannel> getServerSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends SocketChannel> getClientSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static EventLoopGroup createEventLoopGroup(int nThreads, String prefix) {
        if (SUPPORTS_EPOLL) {
            return new EpollEventLoopGroup(nThreads, (ThreadFactory)new NamedThreadFactory(prefix));
        }
        return new NioEventLoopGroup(nThreads, (ThreadFactory)new NamedThreadFactory(prefix));
    }

    public static void shutDownEventLoopGroup(EventLoopGroup eventLoopGroup, String groupName, Logger logger) {
        try {
            Stopwatch watch = Stopwatch.createStarted();
            eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).get();
            long elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            if (elapsed > 500L) {
                logger.info("Closed " + groupName + " in " + elapsed + " ms.");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Failure while shutting down {}.", (Object)groupName, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private TransportCheck() {
    }

    static {
        String name = SystemPropertyUtil.get((String)"os.name").toLowerCase(Locale.US).trim();
        SUPPORTS_EPOLL = name.startsWith("linux") && SystemPropertyUtil.getBoolean((String)USE_LINUX_EPOLL, (boolean)false);
    }
}

