/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import com.google.common.base.Stopwatch;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.calcite.avatica.AvaticaSite;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.util.Cursor;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillResultSet;
import org.apache.drill.jdbc.ExecutionCanceledSqlException;
import org.apache.drill.jdbc.SqlTimeoutException;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillResultSetImpl
extends AvaticaResultSet
implements DrillResultSet {
    private static final Logger logger = LoggerFactory.getLogger(DrillResultSetImpl.class);
    private final DrillConnectionImpl connection;
    private volatile boolean hasPendingCancellationNotification = false;
    private Stopwatch elapsedTimer;
    private long queryTimeoutInMilliseconds;

    DrillResultSetImpl(AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
        this.connection = (DrillConnectionImpl)statement.getConnection();
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            if (this.cursor instanceof DrillCursor && this.hasPendingCancellationNotification) {
                this.hasPendingCancellationNotification = false;
                throw new ExecutionCanceledSqlException("SQL statement execution canceled; ResultSet now closed.");
            }
            throw new AlreadyClosedSqlException("ResultSet is already closed.");
        }
        if (this.elapsedTimer != null && this.elapsedTimer.elapsed(TimeUnit.MILLISECONDS) > this.queryTimeoutInMilliseconds) {
            throw new SqlTimeoutException(TimeUnit.MILLISECONDS.toSeconds(this.queryTimeoutInMilliseconds));
        }
    }

    protected void cancel() {
        if (this.cursor instanceof DrillCursor) {
            this.hasPendingCancellationNotification = true;
            ((DrillCursor)this.cursor).cancel();
        } else {
            super.cancel();
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.cursor != null) {
            return super.next();
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkOpen();
        try {
            return super.getCursorName();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Cursor.Accessor accessor;
        this.checkOpen();
        try {
            accessor = (Cursor.Accessor)this.accessorList.get(columnIndex - 1);
        }
        catch (RuntimeException e) {
            throw new SQLException(e);
        }
        ColumnMetaData metaData = (ColumnMetaData)this.columnMetaDataList.get(columnIndex - 1);
        int typeId = metaData.type.id != 6 ? metaData.type.id : 7;
        return typeId != 0 ? AvaticaSite.get((Cursor.Accessor)accessor, (int)typeId, (Calendar)this.localCalendar) : null;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkOpen();
        try {
            return super.isLast();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkOpen();
        try {
            super.beforeFirst();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkOpen();
        try {
            super.afterLast();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkOpen();
        try {
            return super.first();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean last() throws SQLException {
        this.checkOpen();
        try {
            return super.last();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkOpen();
        try {
            return super.absolute(row);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkOpen();
        try {
            return super.relative(rows);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkOpen();
        try {
            return super.previous();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkOpen();
        try {
            super.updateNull(columnIndex);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBoolean(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkOpen();
        try {
            super.updateByte(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkOpen();
        try {
            super.updateShort(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkOpen();
        try {
            super.updateInt(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkOpen();
        try {
            super.updateLong(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkOpen();
        try {
            super.updateFloat(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkOpen();
        try {
            super.updateDouble(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBigDecimal(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkOpen();
        try {
            super.updateString(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBytes(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkOpen();
        try {
            super.updateDate(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkOpen();
        try {
            super.updateTime(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkOpen();
        try {
            super.updateTimestamp(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            super.updateAsciiStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            super.updateBinaryStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkOpen();
        try {
            super.updateCharacterStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.checkOpen();
        try {
            super.updateObject(columnIndex, x, scaleOrLength);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkOpen();
        try {
            super.updateObject(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkOpen();
        super.updateObject(columnIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkOpen();
        super.updateObject(columnLabel, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.checkOpen();
        super.updateObject(columnIndex, x, targetSqlType);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        this.checkOpen();
        super.updateObject(columnLabel, x, targetSqlType);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.checkOpen();
        try {
            super.updateNull(columnLabel);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBoolean(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.checkOpen();
        try {
            super.updateByte(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.checkOpen();
        try {
            super.updateShort(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.checkOpen();
        try {
            super.updateInt(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.checkOpen();
        try {
            super.updateLong(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.checkOpen();
        try {
            super.updateFloat(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.checkOpen();
        try {
            super.updateDouble(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBigDecimal(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.checkOpen();
        try {
            super.updateString(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBytes(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.checkOpen();
        try {
            super.updateDate(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.checkOpen();
        try {
            super.updateTime(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.checkOpen();
        try {
            super.updateTimestamp(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            super.updateAsciiStream(columnLabel, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            super.updateBinaryStream(columnLabel, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.checkOpen();
        try {
            super.updateCharacterStream(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.checkOpen();
        try {
            super.updateObject(columnLabel, x, scaleOrLength);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.checkOpen();
        try {
            super.updateObject(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkOpen();
        try {
            super.insertRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkOpen();
        try {
            super.updateRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkOpen();
        try {
            super.deleteRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkOpen();
        try {
            super.refreshRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkOpen();
        try {
            super.cancelRowUpdates();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkOpen();
        try {
            super.moveToInsertRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkOpen();
        try {
            super.moveToCurrentRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkOpen();
        try {
            super.updateRef(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.checkOpen();
        try {
            super.updateRef(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBlob(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBlob(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkOpen();
        try {
            super.updateClob(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.checkOpen();
        try {
            super.updateClob(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkOpen();
        try {
            super.updateArray(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.checkOpen();
        try {
            super.updateArray(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.checkOpen();
        try {
            return super.getRowId(columnIndex);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        this.checkOpen();
        try {
            return super.getRowId(columnLabel);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.checkOpen();
        try {
            super.updateRowId(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.checkOpen();
        try {
            super.updateRowId(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.checkOpen();
        try {
            super.updateNString(columnIndex, nString);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.checkOpen();
        try {
            super.updateNString(columnLabel, nString);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.checkOpen();
        try {
            super.updateNClob(columnIndex, nClob);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.checkOpen();
        try {
            super.updateNClob(columnLabel, nClob);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.checkOpen();
        try {
            super.updateSQLXML(columnIndex, xmlObject);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.checkOpen();
        try {
            super.updateSQLXML(columnLabel, xmlObject);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateNCharacterStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateAsciiStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateBinaryStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateCharacterStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateAsciiStream(columnLabel, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateBinaryStream(columnLabel, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateCharacterStream(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateBlob(columnIndex, inputStream, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateBlob(columnLabel, inputStream, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateClob(columnIndex, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateClob(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateNClob(columnIndex, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            super.updateNClob(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkOpen();
        try {
            super.updateNCharacterStream(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            super.updateNCharacterStream(columnLabel, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.checkOpen();
        try {
            super.updateAsciiStream(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBinaryStream(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkOpen();
        try {
            super.updateCharacterStream(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.checkOpen();
        try {
            super.updateAsciiStream(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.checkOpen();
        try {
            super.updateBinaryStream(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            super.updateCharacterStream(columnLabel, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            super.updateBlob(columnIndex, inputStream);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            super.updateBlob(columnLabel, inputStream);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            super.updateClob(columnIndex, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            super.updateClob(columnLabel, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            super.updateNClob(columnIndex, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            super.updateNClob(columnLabel, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public String getQueryId() throws SQLException {
        this.checkOpen();
        if (this.cursor instanceof DrillCursor) {
            return ((DrillCursor)this.cursor).getQueryId();
        }
        return null;
    }

    protected DrillResultSetImpl execute() throws SQLException {
        this.connection.getDriver().handler.onStatementExecute(this.statement, null);
        if (this.signature.cursorFactory != null) {
            super.execute();
        } else {
            DrillCursor drillCursor = new DrillCursor(this.connection, this.statement, this.signature);
            this.elapsedTimer = drillCursor.getElapsedTimer();
            this.queryTimeoutInMilliseconds = drillCursor.getTimeoutInMilliseconds();
            super.execute2((Cursor)drillCursor, this.signature.columns);
            drillCursor.loadInitialSchema();
        }
        return this;
    }
}

