/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import com.google.common.base.Function;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.test.JdbcTestQueryBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={JdbcTest.class})
public class TestJdbcQuery
extends JdbcTestQueryBase {
    private static final Logger logger = LoggerFactory.getLogger(TestJdbcQuery.class);

    @BeforeClass
    public static void setupFiles() {
        dirTestWatcher.copyFileToRoot(Paths.get("sample-data", new String[0]));
    }

    @Test
    public void testFix3635() throws Exception {
        String tableName = "dfs.tmp.`testDDLs3635`";
        try (Connection conn = TestJdbcQuery.connect();){
            Statement s = conn.createStatement();
            s.executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM cp.`employee.json`", "dfs.tmp.`testDDLs3635`"));
        }
        TestJdbcQuery.testQuery(String.format("SELECT * FROM %s LIMIT 1", "dfs.tmp.`testDDLs3635`"));
    }

    @Test
    @Ignore
    public void testJsonQuery() throws Exception {
        TestJdbcQuery.testQuery("select * from cp.`employee.json`");
    }

    @Test
    public void testCast() throws Exception {
        TestJdbcQuery.testQuery("select R_REGIONKEY, cast(R_NAME as varchar(15)) as region, cast(R_COMMENT as varchar(255)) as comment from dfs.`sample-data/region.parquet`");
    }

    @Test
    @Ignore
    public void testWorkspace() throws Exception {
        TestJdbcQuery.testQuery("select * from dfs.root.`sample-data/region.parquet`");
    }

    @Test
    @Ignore
    public void testWildcard() throws Exception {
        TestJdbcQuery.testQuery("select * from dfs.`sample-data/region.parquet`");
    }

    @Test
    public void testCharLiteral() throws Exception {
        TestJdbcQuery.testQuery("select 'test literal' from INFORMATION_SCHEMA.`TABLES` LIMIT 1");
    }

    @Test
    public void testVarCharLiteral() throws Exception {
        TestJdbcQuery.testQuery("select cast('test literal' as VARCHAR) from INFORMATION_SCHEMA.`TABLES` LIMIT 1");
    }

    @Test
    @Ignore
    public void testLogicalExplain() throws Exception {
        TestJdbcQuery.testQuery("EXPLAIN PLAN WITHOUT IMPLEMENTATION FOR select * from dfs.`sample-data/region.parquet`");
    }

    @Test
    @Ignore
    public void testPhysicalExplain() throws Exception {
        TestJdbcQuery.testQuery("EXPLAIN PLAN FOR select * from dfs.`sample-data/region.parquet`");
    }

    @Test
    @Ignore
    public void checkUnknownColumn() throws Exception {
        TestJdbcQuery.testQuery("SELECT unknownColumn FROM dfs.`sample-data/region.parquet`");
    }

    @Test
    public void testLikeNotLike() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT TABLE_NAME, COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME NOT LIKE 'C%' AND COLUMN_NAME LIKE 'TABLE_%E'").returns("TABLE_NAME=PARTITIONS; COLUMN_NAME=TABLE_NAME\nTABLE_NAME=TABLES; COLUMN_NAME=TABLE_NAME\nTABLE_NAME=TABLES; COLUMN_NAME=TABLE_TYPE\nTABLE_NAME=TABLES; COLUMN_NAME=TABLE_SOURCE\nTABLE_NAME=VIEWS; COLUMN_NAME=TABLE_NAME\n");
    }

    @Test
    public void testSimilarNotSimilar() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_NAME SIMILAR TO '%(H|I)E%' AND TABLE_NAME NOT SIMILAR TO 'C%' ORDER BY TABLE_NAME").returns("TABLE_NAME=SCHEMATA\nTABLE_NAME=VIEWS\n");
    }

    @Test
    public void testIntegerLiteral() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("select substring('asd' from 1 for 2) from INFORMATION_SCHEMA.`TABLES` limit 1").returns("EXPR$0=as\n");
    }

    @Test
    public void testNullOpForNullableType() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT * FROM cp.`test_null_op.json` WHERE intType IS NULL AND varCharType IS NOT NULL").returns("intType=null; varCharType=val2");
    }

    @Test
    public void testNullOpForNonNullableType() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT * FROM cp.`test_null_op.json` WHERE (intType IS NULL) IS NULL AND (varCharType IS NOT NULL) IS NOT NULL").returns("");
    }

    @Test
    public void testTrueOpForNullableType() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT data FROM cp.`test_true_false_op.json` WHERE booleanType IS TRUE").returns("data=set to true");
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT data FROM cp.`test_true_false_op.json` WHERE booleanType IS FALSE").returns("data=set to false");
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT data FROM cp.`test_true_false_op.json` WHERE booleanType IS NOT TRUE").returns("data=set to false\ndata=not set");
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT data FROM cp.`test_true_false_op.json` WHERE booleanType IS NOT FALSE").returns("data=set to true\ndata=not set");
    }

    @Test
    public void testTrueOpForNonNullableType() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT data FROM cp.`test_true_false_op.json` WHERE (booleanType IS TRUE) IS TRUE").returns("data=set to true");
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT data FROM cp.`test_true_false_op.json` WHERE (booleanType IS FALSE) IS FALSE").returns("data=set to true\ndata=not set");
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT data FROM cp.`test_true_false_op.json` WHERE (booleanType IS NOT TRUE) IS NOT TRUE").returns("data=set to true");
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT data FROM cp.`test_true_false_op.json` WHERE (booleanType IS NOT FALSE) IS NOT FALSE").returns("data=set to true\ndata=not set");
    }

    @Test
    public void testDateTimeAccessors() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().withConnection(new Function<Connection, Void>(){

            public Void apply(Connection connection) {
                try {
                    Statement statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery("select date '2008-2-23', time '12:23:34', timestamp '2008-2-23 12:23:34.456', interval '1' year, interval '2' day, date_add(date '2008-2-23', interval '1 10:20:30' day to second), date_add(date '2010-2-23', 1) from cp.`employee.json` limit 1");
                    resultSet.next();
                    Date date = resultSet.getDate(1);
                    Time time = resultSet.getTime(2);
                    Timestamp ts = resultSet.getTimestamp(3);
                    String intervalYear = resultSet.getString(4);
                    String intervalDay = resultSet.getString(5);
                    Timestamp ts1 = resultSet.getTimestamp(6);
                    Date date1 = resultSet.getDate(7);
                    Timestamp result = Timestamp.valueOf("2008-2-24 10:20:30");
                    Date result1 = Date.valueOf("2010-2-24");
                    Assert.assertEquals((Object)ts1, (Object)result);
                    Assert.assertEquals((Object)date1, (Object)result1);
                    statement.close();
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testVerifyMetadata() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().withConnection(new Function<Connection, Void>(){

            public Void apply(Connection connection) {
                try {
                    Statement statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery("select timestamp '2008-2-23 12:23:23', date '2001-01-01' from cp.`employee.json` limit 1");
                    Assert.assertEquals((long)93L, (long)resultSet.getMetaData().getColumnType(1));
                    Assert.assertEquals((long)91L, (long)resultSet.getMetaData().getColumnType(2));
                    logger.debug(JdbcTestBase.toString(resultSet));
                    resultSet.close();
                    statement.close();
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testCaseWithNoElse() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT employee_id, CASE WHEN employee_id < 100 THEN first_name END from cp.`employee.json` WHERE employee_id = 99 OR employee_id = 100").returns("employee_id=99; EXPR$1=Elizabeth\nemployee_id=100; EXPR$1=null\n");
    }

    @Test
    public void testCaseWithElse() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT employee_id, CASE WHEN employee_id < 100 THEN first_name ELSE 'Test' END from cp.`employee.json` WHERE employee_id = 99 OR employee_id = 100").returns("employee_id=99; EXPR$1=Elizabeth\nemployee_id=100; EXPR$1=Test");
    }

    @Test
    public void testCaseWith2ThensAndNoElse() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT employee_id, CASE WHEN employee_id < 100 THEN first_name WHEN employee_id = 100 THEN last_name END from cp.`employee.json` WHERE employee_id = 99 OR employee_id = 100 OR employee_id = 101").returns("employee_id=99; EXPR$1=Elizabeth\nemployee_id=100; EXPR$1=Hunt\nemployee_id=101; EXPR$1=null");
    }

    @Test
    public void testCaseWith2ThensAndElse() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT employee_id, CASE WHEN employee_id < 100 THEN first_name WHEN employee_id = 100 THEN last_name ELSE 'Test' END from cp.`employee.json` WHERE employee_id = 99 OR employee_id = 100 OR employee_id = 101").returns("employee_id=99; EXPR$1=Elizabeth\nemployee_id=100; EXPR$1=Hunt\nemployee_id=101; EXPR$1=Test\n");
    }

    @Test
    public void testAggWithDrillFunc() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT extract(year from max(to_timestamp(hire_date, 'yyyy-MM-dd HH:mm:SS.SSS' ))) as MAX_YEAR from cp.`employee.json` ").returns("MAX_YEAR=1998\n");
    }

    @Test
    public void testLeftRightReplace() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT `left`('abcdef', 2) as LEFT_STR, `right`('abcdef', 2) as RIGHT_STR, `replace`('abcdef', 'ab', 'zz') as REPLACE_STR from cp.`employee.json` limit 1").returns("LEFT_STR=ab; RIGHT_STR=ef; REPLACE_STR=zzcdef\n");
    }

    @Test
    public void testLengthUTF8VarCharInput() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("select length('Sheri', 'UTF8') as L_UTF8 from cp.`employee.json` where employee_id = 1").returns("L_UTF8=5\n");
    }

    @Test
    public void testTimeIntervalAddOverflow() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("select extract(hour from (interval '10 20' day to hour + time '10:00:00')) as TIME_INT_ADD from cp.`employee.json` where employee_id = 1").returns("TIME_INT_ADD=6\n");
    }

    @Test
    public void testOldDateTimeJulianCalendar() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("select cast(to_timestamp('1581-12-01 23:32:01', 'yyyy-MM-dd HH:mm:ss') as date) as `DATE`, to_timestamp('1581-12-01 23:32:01', 'yyyy-MM-dd HH:mm:ss') as `TIMESTAMP`, cast(to_timestamp('1581-12-01 23:32:01', 'yyyy-MM-dd HH:mm:ss') as time) as `TIME` from (VALUES(1))").returns("DATE=1581-12-01; TIMESTAMP=1581-12-01 23:32:01.0; TIME=23:32:01");
    }

    @Test
    public void testOldDateTimeLocalMeanTime() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("select cast(to_timestamp('1883-11-16 01:32:01', 'yyyy-MM-dd HH:mm:ss') as date) as `DATE`, to_timestamp('1883-11-16 01:32:01', 'yyyy-MM-dd HH:mm:ss') as `TIMESTAMP`, cast(to_timestamp('1883-11-16 01:32:01', 'yyyy-MM-dd HH:mm:ss') as time) as `TIME` from (VALUES(1))").returns("DATE=1883-11-16; TIMESTAMP=1883-11-16 01:32:01.0; TIME=01:32:01");
    }

    @Test
    public void testConvertFromInEmptyInputSql() throws Exception {
        TestJdbcQuery.withNoDefaultSchema().sql("SELECT CONVERT_FROM(columns[1], 'JSON') as col1 from cp.`empty.csv`").returns("");
    }

    @Test
    public void testResultSetIsNotReturnedSet() throws Exception {
        try (Connection conn = TestJdbcQuery.connect();
             Statement s = conn.createStatement();){
            s.execute(String.format("SET `%s` = false", "exec.query.return_result_set_for_ddl"));
            s.execute(String.format("SET `%s` = 'json'", "store.format"));
            Assert.assertNull((String)"No result", (Object)s.getResultSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResultSetIsNotReturnedCTAS() throws Exception {
        String tableName = "dfs.tmp.`ctas`";
        try (Connection conn = TestJdbcQuery.connect();
             Statement s = conn.createStatement();){
            s.execute(String.format("SET `%s` = false", "exec.query.return_result_set_for_ddl"));
            s.execute(String.format("CREATE TABLE %s AS SELECT * FROM cp.`employee.json`", tableName));
            Assert.assertNull((String)"No result", (Object)s.getResultSet());
        }
        catch (Throwable throwable) {
            TestJdbcQuery.execute("DROP TABLE IF EXISTS %s", tableName);
            throw throwable;
        }
        TestJdbcQuery.execute("DROP TABLE IF EXISTS %s", tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResultSetIsNotReturnedCreateView() throws Exception {
        String viewName = "dfs.tmp.`cv`";
        try (Connection conn = TestJdbcQuery.connect();
             Statement s = conn.createStatement();){
            s.execute(String.format("SET `%s` = false", "exec.query.return_result_set_for_ddl"));
            s.execute(String.format("CREATE VIEW %s AS SELECT * FROM cp.`employee.json`", viewName));
            Assert.assertNull((String)"No result", (Object)s.getResultSet());
        }
        catch (Throwable throwable) {
            TestJdbcQuery.execute("DROP VIEW IF EXISTS %s", viewName);
            throw throwable;
        }
        TestJdbcQuery.execute("DROP VIEW IF EXISTS %s", viewName);
    }

    @Test
    public void testResultSetIsNotReturnedDropTable() throws Exception {
        String tableName = "dfs.tmp.`dt`";
        try (Connection conn = TestJdbcQuery.connect();
             Statement s = conn.createStatement();){
            s.execute(String.format("SET `%s` = false", "exec.query.return_result_set_for_ddl"));
            s.execute(String.format("CREATE TABLE %s AS SELECT * FROM cp.`employee.json`", tableName));
            s.execute(String.format("DROP TABLE %s", tableName));
            Assert.assertNull((String)"No result", (Object)s.getResultSet());
        }
    }

    @Test
    public void testResultSetIsNotReturnedDropView() throws Exception {
        String viewName = "dfs.tmp.`dv`";
        try (Connection conn = TestJdbcQuery.connect();
             Statement stmt = conn.createStatement();){
            stmt.execute(String.format("SET `%s` = false", "exec.query.return_result_set_for_ddl"));
            stmt.execute(String.format("CREATE VIEW %s AS SELECT * FROM cp.`employee.json`", viewName));
            stmt.execute(String.format("DROP VIEW %s", viewName));
            Assert.assertNull((String)"No result", (Object)stmt.getResultSet());
        }
    }

    @Test
    public void testResultSetIsNotReturnedUse() throws Exception {
        try (Connection conn = TestJdbcQuery.connect();
             Statement s = conn.createStatement();){
            s.execute(String.format("SET `%s` = false", "exec.query.return_result_set_for_ddl"));
            s.execute("USE dfs.tmp");
            Assert.assertNull((String)"No result", (Object)s.getResultSet());
        }
    }

    @Test
    public void testResultSetIsNotReturnedRefreshMetadata() throws Exception {
        String tableName = "dfs.tmp.`rm`";
        try (Connection conn = TestJdbcQuery.connect();
             Statement s = conn.createStatement();){
            s.execute(String.format("SET `%s` = false", "exec.query.return_result_set_for_ddl"));
            s.execute(String.format("CREATE TABLE %s AS SELECT * FROM cp.`employee.json`", tableName));
            s.execute(String.format("REFRESH TABLE METADATA %s", tableName));
            Assert.assertNull((String)"No result", (Object)s.getResultSet());
        }
    }

    private static void execute(String sql, Object ... params) throws Exception {
        try (Connection conn = TestJdbcQuery.connect();
             Statement s = conn.createStatement();){
            s.execute(String.format(sql, params));
        }
    }
}

