/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.drill.jdbc.CachingConnectionFactory;
import org.apache.drill.jdbc.ConnectionFactory;
import org.apache.drill.jdbc.ConnectionInfo;
import org.apache.drill.jdbc.NonClosableConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiConnectionCachingFactory
implements CachingConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(MultiConnectionCachingFactory.class);
    private final ConnectionFactory delegate;
    private final Map<ConnectionInfo, Connection> cache = Maps.newHashMap();

    public MultiConnectionCachingFactory(ConnectionFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Connection getConnection(ConnectionInfo info) throws SQLException {
        Connection conn = this.cache.get(info);
        if (conn == null) {
            conn = this.delegate.getConnection(info);
            this.cache.put(info, conn);
        }
        return new NonClosableConnection(conn);
    }

    @Override
    public void closeConnections() throws SQLException {
        for (Connection conn : this.cache.values()) {
            conn.close();
        }
    }
}

