/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.ExpectedException;

@Category(value={SlowTest.class, JdbcTest.class})
public class ConnectionInfoTest
extends JdbcTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @After
    public void tearDown() {
        ConnectionInfoTest.reset();
    }

    @Test
    public void testQuotingIdentifiersProperty() throws Exception {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local;quoting_identifiers='\"'");
        DatabaseMetaData dbmd = connection.getMetaData();
        MatcherAssert.assertThat((Object)dbmd.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)Quoting.DOUBLE_QUOTE.string));
        ConnectionInfoTest.reset();
        connection = ConnectionInfoTest.connect("jdbc:drill:zk=local;quoting_identifiers=[");
        dbmd = connection.getMetaData();
        MatcherAssert.assertThat((Object)dbmd.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)Quoting.BRACKET.string));
    }

    @Test
    public void testIncorrectCharacterForQuotingIdentifiers() throws Exception {
        this.thrown.expect(SQLException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"Option planner.parser.quoting_identifiers must be one of: [`, \", []"));
        ConnectionInfoTest.connect("jdbc:drill:zk=local;quoting_identifiers=&");
    }

    @Test
    public void testIncorrectValueForSystemOption() throws Exception {
        this.thrown.expect(SQLException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"VALIDATION ERROR: '1' is not a valid value for option 'planner.enable_nljoin_for_scalar_only' of type BOOLEAN"));
        ConnectionInfoTest.connect("jdbc:drill:zk=local;planner.enable_nljoin_for_scalar_only=1");
    }

    @Test
    public void testSessionPropertySet() throws SQLException {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local;planner.enable_nljoin_for_scalar_only=false");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sys.options where name = 'planner.enable_nljoin_for_scalar_only' and optionScope = 'SESSION' and val = 'false'");
        int resultSize = 0;
        while (resultSet.next()) {
            ++resultSize;
        }
        Assert.assertEquals((String)"planner.enable_nljoin_for_scalar_only should been set to 'false' at SESSION level ", (long)1L, (long)resultSize);
    }

    @Test
    public void testDontFailOnUnknownProperty() {
        Assertions.assertDoesNotThrow(() -> ConnectionInfoTest.connect("jdbc:drill:zk=local;ababagalamaga=true"));
    }

    @Test
    public void testOverrideDeprecatedServerPropertyIfSystemPresent() throws SQLException {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local;quoting_identifiers=[;planner.parser.quoting_identifiers='\"';");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sys.options where name = 'planner.parser.quoting_identifiers' and optionScope = 'SESSION' and val = '\"'");
        int resultSize = 0;
        while (resultSet.next()) {
            ++resultSize;
        }
        Assert.assertEquals((String)"planner.enable_nljoin_for_scalar_only should been set to '\"' at SESSION level ", (long)1L, (long)resultSize);
    }

    @Test
    public void testSetSchemaUsingConnectionMethod() throws Exception {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local");
        Assert.assertNull((Object)connection.getSchema());
        connection.setSchema("dfs.tmp");
        Assert.assertEquals((Object)"dfs.tmp", (Object)connection.getSchema());
    }

    @Test
    public void testIncorrectlySetSchema() throws Exception {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local");
        this.thrown.expect(SQLException.class);
        this.thrown.expectMessage("Error when setting schema");
        connection.setSchema("ABC");
    }

    @Test
    public void testSchemaInConnectionString() throws Exception {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local;schema=sys");
        Assert.assertEquals((Object)"sys", (Object)connection.getSchema());
    }
}

