/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.jdbc.InvalidCursorStateSqlException;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SlowTest.class, JdbcTest.class})
public class DrillResultSetTest
extends JdbcTestBase {
    private static final String STATUS_SERVER_PROPERTY_NAME = "drill.exec.http.enabled";
    private static final String origStatusServerPropValue = System.getProperty("drill.exec.http.enabled", "true");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void setUpClass() {
        System.setProperty(STATUS_SERVER_PROPERTY_NAME, "false");
    }

    @AfterClass
    public static void tearDownClass() {
        System.setProperty(STATUS_SERVER_PROPERTY_NAME, origStatusServerPropValue);
    }

    @Test
    public void test_next_blocksFurtherAccessAfterEnd() throws SQLException {
        Connection connection = DrillResultSetTest.connect();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 1 AS x \nFROM cp.`donuts.json` \nLIMIT 2");
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        this.thrown.expect(InvalidCursorStateSqlException.class);
        this.thrown.expectMessage(StringContains.containsString((String)"Result set cursor is already positioned past all rows."));
        resultSet.getInt(1);
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void test_next_blocksFurtherAccessWhenNoRows() throws Exception {
        Connection connection = DrillResultSetTest.connect();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 'Hi' AS x \nFROM cp.`donuts.json` \nWHERE false");
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        this.thrown.expect(InvalidCursorStateSqlException.class);
        this.thrown.expectMessage(StringContains.containsString((String)"Result set cursor is already positioned past all rows."));
        resultSet.getString(1);
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void test_getRow_isOneBased() throws Exception {
        Connection connection = DrillResultSetTest.connect();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("VALUES (1), (2)");
        MatcherAssert.assertThat((String)"getRow() before first next()", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)0));
        resultSet.next();
        MatcherAssert.assertThat((String)"getRow() at first row", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)1));
        resultSet.next();
        MatcherAssert.assertThat((String)"getRow() at second row", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)2));
        resultSet.next();
        MatcherAssert.assertThat((String)"getRow() after last row", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)0));
        resultSet.next();
        MatcherAssert.assertThat((String)"getRow() after last row", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testGetObjectNull() throws SQLException {
        Connection connection = DrillResultSetTest.connect();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select coalesce(a1, b1) from cp.`testGetObjectNull.parquet` limit 1");
        resultSet.next();
        Assert.assertNull((Object)resultSet.getObject(1));
    }
}

