/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.util.Map;
import java.util.Properties;
import org.apache.drill.shaded.guava.com.google.common.base.Objects;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

public class ConnectionInfo {
    private final String url;
    private final Map<Object, Object> params;

    public ConnectionInfo(String url, Properties params) {
        this(url, (ImmutableMap<Object, Object>)ImmutableMap.copyOf((Map)params));
    }

    public ConnectionInfo(String url, ImmutableMap<Object, Object> params) {
        this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"URL cannot be null");
        this.params = params;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<Object, Object> getParameters() {
        return this.params;
    }

    public Properties getParamsAsProperties() {
        Properties props = new Properties();
        for (Object key : this.params.keySet()) {
            props.put(key, this.params.get(key));
        }
        return props;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.url, this.params});
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionInfo) {
            ConnectionInfo info = (ConnectionInfo)ConnectionInfo.class.cast(obj);
            return Objects.equal((Object)this.url, (Object)info.getUrl()) && Objects.equal(this.params, info.getParameters());
        }
        return false;
    }
}

