/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.drill.StringChanger;
import org.slf4j.MDC;

public class MaskingPatternLayout
extends PatternLayout {
    private StringChanger stringChanger;

    public void setRulesConfig(String configFilePath) {
        if (configFilePath == null) {
            return;
        }
        this.stringChanger = new StringChanger(configFilePath);
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        String formattedString = super.doLayout(event);
        return this.maskMessage(formattedString);
    }

    private String maskMessage(String message) {
        String userName = MDC.get("drill.userName");
        return this.stringChanger != null ? this.stringChanger.changeString(message, userName) : message;
    }
}

