/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.cli;

import java.util.List;
import oadd.org.apache.commons.cli.CommandLine;
import oadd.org.apache.commons.cli.DefaultParser;
import oadd.org.apache.commons.cli.Options;
import oadd.org.apache.commons.cli.ParseException;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.ZKUtil;
import oadd.org.apache.zookeeper.cli.AclParser;
import oadd.org.apache.zookeeper.cli.CliCommand;
import oadd.org.apache.zookeeper.cli.CliException;
import oadd.org.apache.zookeeper.cli.CliParseException;
import oadd.org.apache.zookeeper.cli.CliWrapperException;
import oadd.org.apache.zookeeper.cli.MalformedPathException;
import oadd.org.apache.zookeeper.cli.StatPrinter;
import oadd.org.apache.zookeeper.data.ACL;
import oadd.org.apache.zookeeper.data.Stat;

public class SetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetAclCommand() {
        super("setAcl", "[-s] [-v version] [-R] path acl");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        String aclStr = this.args[2];
        List<ACL> acl = AclParser.parse(aclStr);
        int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            if (this.cl.hasOption("R")) {
                ZKUtil.visitSubTreeDFS(this.zk, path, false, (rc, p, ctx, name) -> {
                    try {
                        this.zk.setACL(p, acl, version);
                    }
                    catch (InterruptedException | KeeperException e) {
                        this.out.print(e.getMessage());
                    }
                });
            } else {
                Stat stat = this.zk.setACL(path, acl, version);
                if (this.cl.hasOption("s")) {
                    new StatPrinter(this.out).print(stat);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("v", true, "version");
        options.addOption("R", false, "recursive");
    }
}

