/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.Arrays;
import java.util.Set;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import oadd.org.apache.drill.exec.expr.holders.UInt2Holder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.UInt2Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableUInt2ReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class NullableUInt2Vector
extends BaseDataValueVector
implements FixedWidthVector,
NullableVector {
    private static final int DEFINED_VALUES_ARRAY_LEN = 1024;
    private static final byte[] DEFINED_VALUES_ARRAY = new byte[1024];
    private final FieldReader reader = new NullableUInt2ReaderImpl(this);
    private final UInt1Vector bits = new UInt1Vector(bitsField, this.allocator);
    private final UInt2Vector values = new UInt2Vector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableUInt2Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    @Override
    public int getAllocatedSize() {
        return this.bits.getAllocatedSize() + this.values.getAllocatedSize();
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public UInt2Vector getValuesVector() {
        return this.values;
    }

    @Override
    public UInt1Vector getBitsVector() {
        return this.bits;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
                return false;
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.bits.collectLedgers(ledgers);
        this.values.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.bits.getPayloadByteCount(valueCount) + this.values.getPayloadByteCount(valueCount);
    }

    @Override
    public int getValueWidth() {
        return this.bits.getValueWidth() + 2;
    }

    @Override
    public void allocateNew(int valueCount) {
        try {
            this.values.allocateNew(valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public void zeroVector() {
        this.bits.zeroVector();
        this.values.zeroVector();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableUInt2Vector)to);
    }

    public void transferTo(NullableUInt2Vector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableUInt2Vector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public UInt2Vector convertToRequiredVector() {
        UInt2Vector v = new UInt2Vector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public int getBitsValueCapacity() {
        return this.bits.getValueCapacity();
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableUInt2Vector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, UInt2Vector from) {
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableUInt2Vector from) {
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        if (from instanceof UInt2Vector) {
            this.bits.getMutator().setSafe(toIndex, 1);
            this.values.copyFromSafe(fromIndex, toIndex, (UInt2Vector)from);
            return;
        }
        NullableUInt2Vector fromVector = (NullableUInt2Vector)from;
        this.bits.copyFromSafe(fromIndex, toIndex, fromVector.bits);
        this.values.copyFromSafe(fromIndex, toIndex, fromVector.values);
    }

    @Override
    public void exchange(ValueVector other) {
        NullableUInt2Vector target = (NullableUInt2Vector)other;
        this.bits.exchange(target.bits);
        this.values.exchange(target.values);
        this.mutator.exchange(other.getMutator());
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        this.exchange(nullableVector);
        this.clear();
    }

    static {
        Arrays.fill(DEFINED_VALUES_ARRAY, (byte)1);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter,
    NullableVector.Mutator {
        private Mutator() {
        }

        public UInt2Vector getVectorWithValues() {
            return NullableUInt2Vector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableUInt2Vector.this.bits.getMutator().set(index, 1);
        }

        @Override
        public void setIndexDefined(int index, int numValues) {
            int batchSz;
            for (int remaining = numValues; remaining > 0; remaining -= batchSz) {
                batchSz = Math.min(remaining, 1024);
                NullableUInt2Vector.this.bits.getMutator().set(index + (numValues - remaining), DEFINED_VALUES_ARRAY, 0, batchSz);
            }
        }

        public void set(int index, int value) {
            UInt2Vector.Mutator valuesMutator = NullableUInt2Vector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableUInt2Vector.this.bits.getMutator();
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
        }

        public void setNull(int index) {
            NullableUInt2Vector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, UInt2Holder holder) {
            NullableUInt2Vector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableUInt2Holder holder) {
            NullableUInt2Vector.this.values.getMutator().set(index, holder);
        }

        public void set(int index, NullableUInt2Holder holder) {
            UInt2Vector.Mutator valuesMutator = NullableUInt2Vector.this.values.getMutator();
            NullableUInt2Vector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
        }

        public void set(int index, UInt2Holder holder) {
            UInt2Vector.Mutator valuesMutator = NullableUInt2Vector.this.values.getMutator();
            NullableUInt2Vector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableUInt2Vector.this.getValueCapacity();
        }

        public void set(int index, int isSet, char valueField) {
            UInt2Vector.Mutator valuesMutator = NullableUInt2Vector.this.values.getMutator();
            NullableUInt2Vector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, valueField);
        }

        public void setSafe(int index, int isSet, char valueField) {
            NullableUInt2Vector.this.bits.getMutator().setSafe(index, isSet);
            NullableUInt2Vector.this.values.getMutator().setSafe(index, valueField);
        }

        public void setSafe(int index, NullableUInt2Holder value) {
            NullableUInt2Vector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableUInt2Vector.this.values.getMutator().setSafe(index, value);
        }

        public void setSafe(int index, UInt2Holder value) {
            NullableUInt2Vector.this.bits.getMutator().setSafe(index, 1);
            NullableUInt2Vector.this.values.getMutator().setSafe(index, value);
        }

        public void setSafe(int index, char value) {
            NullableUInt2Vector.this.bits.getMutator().setSafe(index, 1);
            NullableUInt2Vector.this.values.getMutator().setSafe(index, value);
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableUInt2Vector.this.values.getMutator().setValueCount(valueCount);
            NullableUInt2Vector.this.bits.getMutator().setValueCount(valueCount);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableUInt2Vector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableUInt2Vector.this.values.getMutator().generateTestData(valueCount);
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
        }

        @Override
        public void setSetCount(int n) {
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
        }

        public void fromNotNullable(UInt2Vector srce) {
            NullableUInt2Vector.this.clear();
            int valueCount = srce.getAccessor().getValueCount();
            BaseValueVector.fillBitsVector(NullableUInt2Vector.this.getBitsVector(), valueCount);
            NullableUInt2Vector.this.getValuesVector().exchange(srce);
            this.setValueCount(valueCount);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final UInt1Vector.Accessor bAccessor;
        final UInt2Vector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableUInt2Vector.this.bits.getAccessor();
            this.vAccessor = NullableUInt2Vector.this.values.getAccessor();
        }

        public char get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableUInt2Holder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public Character getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableUInt2Vector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        private final NullableUInt2Vector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableUInt2Vector(field, allocator);
        }

        public TransferImpl(NullableUInt2Vector to) {
            this.to = to;
        }

        @Override
        public NullableUInt2Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableUInt2Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableUInt2Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableUInt2Vector.this);
        }
    }
}

