/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.HyperVectorWrapper;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.SchemaBuilder;
import oadd.org.apache.drill.exec.record.SimpleVectorWrapper;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorAccessibleUtilities;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;
import oadd.org.apache.drill.exec.record.selection.SelectionVector4;
import oadd.org.apache.drill.exec.vector.AllocationHelper;
import oadd.org.apache.drill.exec.vector.SchemaChangeCallBack;
import oadd.org.apache.drill.exec.vector.ValueVector;

public class VectorContainer
implements VectorAccessible {
    private final BufferAllocator allocator;
    protected final List<VectorWrapper<?>> wrappers = Lists.newArrayList();
    private BatchSchema schema;
    private int recordCount;
    private boolean initialized;
    private boolean schemaChanged = true;

    public VectorContainer() {
        this.allocator = null;
    }

    public VectorContainer(OperatorContext oContext) {
        this(oContext.getAllocator());
    }

    public VectorContainer(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public VectorContainer(BufferAllocator allocator, BatchSchema schema) {
        this.allocator = allocator;
        for (MaterializedField field : schema) {
            this.addOrGet(field, null);
        }
        this.schema = schema;
        this.schemaChanged = false;
    }

    public String toString() {
        return super.toString() + "[recordCount = " + this.recordCount + ", schemaChanged = " + this.schemaChanged + ", schema = " + this.schema + ", wrappers = " + this.wrappers + ", ...]";
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public boolean isSchemaChanged() {
        return this.schemaChanged;
    }

    public void schemaChanged() {
        this.schemaChanged = true;
    }

    public void addHyperList(List<ValueVector> vectors) {
        this.addHyperList(vectors, true);
    }

    public void addHyperList(List<ValueVector> vectors, boolean releasable) {
        this.schema = null;
        ValueVector[] vv = new ValueVector[vectors.size()];
        for (int i = 0; i < vv.length; ++i) {
            vv[i] = vectors.get(i);
        }
        this.add(vv, releasable);
    }

    public void transferIn(VectorContainer containerIn) {
        this.rawTransferIn(containerIn);
        this.setRecordCount(containerIn.getRecordCount());
    }

    @VisibleForTesting
    public void rawTransferIn(VectorContainer containerIn) {
        Preconditions.checkArgument(this.wrappers.size() == containerIn.wrappers.size());
        for (int i = 0; i < this.wrappers.size(); ++i) {
            containerIn.wrappers.get(i).transfer(this.wrappers.get(i));
        }
    }

    public void transferOut(VectorContainer containerOut) {
        Preconditions.checkArgument(this.wrappers.size() == containerOut.wrappers.size());
        for (int i = 0; i < this.wrappers.size(); ++i) {
            this.wrappers.get(i).transfer(containerOut.wrappers.get(i));
        }
    }

    public <T extends ValueVector> T addOrGet(MaterializedField field) {
        return this.addOrGet(field, null);
    }

    public <T extends ValueVector> T addOrGet(MaterializedField field, SchemaChangeCallBack callBack) {
        Object vector;
        TypedFieldId id = this.getValueVectorId(SchemaPath.getSimplePath(field.getName()));
        if (id != null) {
            vector = this.getValueAccessorById(id.getFieldIds()).getValueVector();
            if (id.getFieldIds().length == 1 && !vector.getField().isEquivalent(field)) {
                ValueVector newVector = TypeHelper.getNewVector(field, this.getAllocator(), callBack);
                this.replace((ValueVector)vector, newVector);
                return (T)newVector;
            }
        } else {
            vector = TypeHelper.getNewVector(field, this.getAllocator(), callBack);
            this.add((ValueVector)vector);
        }
        return (T)vector;
    }

    public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
        MaterializedField field = MaterializedField.create(name, type);
        return this.addOrGet(field);
    }

    public static VectorContainer getTransferClone(VectorAccessible incoming, OperatorContext oContext) {
        VectorContainer vc = new VectorContainer(oContext);
        for (VectorWrapper w : incoming) {
            vc.cloneAndTransfer(w);
        }
        return vc;
    }

    public static VectorContainer getTransferClone(VectorAccessible incoming, BufferAllocator allocator) {
        VectorContainer vc = new VectorContainer(allocator);
        for (VectorWrapper w : incoming) {
            vc.cloneAndTransfer(w);
        }
        return vc;
    }

    public static VectorContainer getTransferClone(VectorAccessible incoming, VectorWrapper<?>[] ignoreWrappers, OperatorContext oContext) {
        Iterable<VectorWrapper<Object>> wrappers = incoming;
        if (ignoreWrappers != null) {
            ArrayList<VectorWrapper<?>> ignored = Lists.newArrayList(ignoreWrappers);
            LinkedHashSet resultant = Sets.newLinkedHashSet(incoming);
            resultant.removeAll(ignored);
            wrappers = resultant;
        }
        VectorContainer vc = new VectorContainer(oContext);
        for (VectorWrapper w : wrappers) {
            vc.cloneAndTransfer(w);
        }
        return vc;
    }

    private void cloneAndTransfer(VectorWrapper<?> wrapper) {
        this.wrappers.add(wrapper.cloneAndTransfer(this.getAllocator()));
    }

    public void addCollection(Iterable<ValueVector> vectors) {
        this.schema = null;
        for (ValueVector vv : vectors) {
            this.wrappers.add(SimpleVectorWrapper.create(vv));
        }
    }

    public int appendRow(VectorContainer srcContainer, int srcIndex) {
        for (int vectorIndex = 0; vectorIndex < this.wrappers.size(); ++vectorIndex) {
            Object destVector = this.wrappers.get(vectorIndex).getValueVector();
            Object srcVector = srcContainer.wrappers.get(vectorIndex).getValueVector();
            destVector.copyEntry(this.recordCount, (ValueVector)srcVector, srcIndex);
        }
        return this.incRecordCount();
    }

    public TypedFieldId add(ValueVector vv) {
        this.schemaChanged();
        this.schema = null;
        int i = this.wrappers.size();
        this.wrappers.add(SimpleVectorWrapper.create(vv));
        return new TypedFieldId.Builder().finalType(vv.getField().getType()).addId(i).build();
    }

    public ValueVector getLast() {
        int sz = this.wrappers.size();
        if (sz == 0) {
            return null;
        }
        return this.wrappers.get(sz - 1).getValueVector();
    }

    public void add(ValueVector[] hyperVector) {
        this.add(hyperVector, true);
    }

    public void add(ValueVector[] hyperVector, boolean releasable) {
        assert (hyperVector.length != 0);
        this.schemaChanged();
        this.schema = null;
        Class<?> clazz = hyperVector[0].getClass();
        ValueVector[] c = (ValueVector[])Array.newInstance(clazz, hyperVector.length);
        System.arraycopy(hyperVector, 0, c, 0, hyperVector.length);
        this.wrappers.add(HyperVectorWrapper.create((MaterializedField)hyperVector[0].getField(), (ValueVector[])c, (boolean)releasable));
    }

    public void remove(ValueVector v) {
        this.schema = null;
        this.schemaChanged();
        Iterator<VectorWrapper<?>> iter = this.wrappers.iterator();
        while (iter.hasNext()) {
            VectorWrapper<?> w = iter.next();
            if (w.isHyper() || v != w.getValueVector()) continue;
            w.clear();
            iter.remove();
            return;
        }
        throw new IllegalStateException("You attempted to remove a vector that didn't exist.");
    }

    private void replace(ValueVector old, ValueVector newVector) {
        this.schema = null;
        this.schemaChanged();
        int i = 0;
        for (VectorWrapper<?> w : this.wrappers) {
            if (!w.isHyper() && old == w.getValueVector()) {
                w.clear();
                this.wrappers.set(i, new SimpleVectorWrapper<ValueVector>(newVector));
                return;
            }
            ++i;
        }
        throw new IllegalStateException("You attempted to remove a vector that didn't exist.");
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        for (int i = 0; i < this.wrappers.size(); ++i) {
            VectorWrapper<?> va = this.wrappers.get(i);
            TypedFieldId id = va.getFieldIdIfMatches(i, path);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public VectorWrapper<?> getValueVector(int index) {
        return this.wrappers.get(index);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... fieldIds) {
        Preconditions.checkArgument(fieldIds.length >= 1);
        VectorWrapper<?> va = this.wrappers.get(fieldIds[0]);
        if (va == null) {
            return null;
        }
        if (fieldIds.length == 1 && clazz != null && !clazz.isAssignableFrom(va.getVectorClass())) {
            throw new IllegalStateException(String.format("Failure while reading vector.  Expected vector class of %s but was holding vector class %s, field= %s ", clazz.getCanonicalName(), va.getVectorClass().getCanonicalName(), va.getField()));
        }
        return va.getChildWrapper(fieldIds);
    }

    private VectorWrapper<?> getValueAccessorById(int ... fieldIds) {
        Preconditions.checkArgument(fieldIds.length >= 1);
        VectorWrapper<?> va = this.wrappers.get(fieldIds[0]);
        if (va == null) {
            return null;
        }
        return va.getChildWrapper(fieldIds);
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    @Override
    public BatchSchema getSchema() {
        Preconditions.checkNotNull(this.schema, "Schema is currently null.  You must call buildSchema(SelectionVectorMode) before this container can return a schema.");
        return this.schema;
    }

    public void buildSchema(BatchSchema.SelectionVectorMode mode) {
        SchemaBuilder bldr = BatchSchema.newBuilder().setSelectionVectorMode(mode);
        for (VectorWrapper<?> v : this.wrappers) {
            bldr.addField(v.getField());
        }
        this.schema = bldr.build();
        this.schemaChanged = false;
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.wrappers.iterator();
    }

    public void clear() {
        this.zeroVectors();
        this.removeAll();
    }

    public void removeAll() {
        this.wrappers.clear();
        this.schema = null;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
        this.initialized = true;
    }

    public int incRecordCount() {
        this.initialized = true;
        return ++this.recordCount;
    }

    @Override
    public int getRecordCount() {
        Preconditions.checkState(this.hasRecordCount(), "Record count not set for this vector container");
        return this.recordCount;
    }

    public boolean hasRecordCount() {
        return this.initialized;
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    public void zeroVectors() {
        VectorAccessibleUtilities.clear(this);
    }

    public int getNumberOfColumns() {
        return this.wrappers.size();
    }

    public void allocate(int recordCount) {
        for (VectorWrapper<?> w : this.wrappers) {
            Object v = w.getValueVector();
            v.setInitialCapacity(recordCount);
            v.allocateNew();
        }
    }

    public void allocateNew() {
        for (VectorWrapper<?> w : this.wrappers) {
            w.getValueVector().allocateNew();
        }
    }

    public boolean allocateNewSafe() {
        for (VectorWrapper<?> w : this.wrappers) {
            if (w.getValueVector().allocateNewSafe()) continue;
            return false;
        }
        return true;
    }

    public void setValueCount(int valueCount) {
        VectorAccessibleUtilities.setValueCount(this, valueCount);
        this.setRecordCount(valueCount);
    }

    public VectorContainer merge(VectorContainer otherContainer) {
        if (this.recordCount != otherContainer.recordCount) {
            throw new IllegalArgumentException();
        }
        VectorContainer merged = new VectorContainer(this.allocator);
        merged.schema = this.schema.merge(otherContainer.schema);
        merged.recordCount = this.recordCount;
        merged.wrappers.addAll(this.wrappers);
        merged.wrappers.addAll(otherContainer.wrappers);
        merged.schemaChanged = false;
        merged.initialized = true;
        return merged;
    }

    public void exchange(VectorContainer other) {
        assert (this.schema.isEquivalent(other.schema));
        assert (this.wrappers.size() == other.wrappers.size());
        assert (this.allocator != null && this.allocator == other.allocator);
        for (int i = 0; i < this.wrappers.size(); ++i) {
            this.wrappers.get(i).getValueVector().exchange((ValueVector)other.wrappers.get(i).getValueVector());
        }
        int temp = this.recordCount;
        this.recordCount = other.recordCount;
        other.recordCount = temp;
        boolean temp2 = this.schemaChanged;
        this.schemaChanged = other.schemaChanged;
        other.schemaChanged = temp2;
    }

    public String prettyPrintRecord(int index) {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        sb.append("[");
        for (VectorWrapper<?> vectorWrapper : this.wrappers) {
            sb.append(separator);
            separator = ", ";
            String columnName = vectorWrapper.getField().getName();
            Object value = vectorWrapper.getValueVector().getAccessor().getObject(index);
            sb.append("\"").append(columnName).append("\" = ").append(value);
        }
        sb.append("]");
        return sb.toString();
    }

    public void setEmpty() {
        this.zeroVectors();
        this.allocateNew();
        this.setValueCount(0);
    }

    public void copySchemaFrom(VectorAccessible other) {
        for (VectorWrapper wrapper : other) {
            this.addOrGet(wrapper.getField());
        }
    }

    public void buildFrom(BatchSchema sourceSchema) {
        for (MaterializedField field : sourceSchema) {
            this.add(TypeHelper.getNewVector(field, this.allocator));
        }
    }

    public void allocatePrecomputedChildCount(int valueCount, int bytesPerValue, int childValCount) {
        for (VectorWrapper<?> w : this.wrappers) {
            AllocationHelper.allocatePrecomputedChildCount(w.getValueVector(), valueCount, bytesPerValue, childValCount);
        }
        this.setEmpty();
    }
}

