/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.dotdrill;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.exec.dotdrill.DotDrillFile;
import oadd.org.apache.drill.exec.dotdrill.DotDrillType;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DotDrillUtil {
    static final Logger logger = LoggerFactory.getLogger(DotDrillUtil.class);

    private static List<DotDrillFile> getDrillFiles(DrillFileSystem fs, List<FileStatus> statuses, DotDrillType ... types) {
        if (statuses == null) {
            return Collections.emptyList();
        }
        ArrayList<DotDrillFile> files = Lists.newArrayList();
        for (FileStatus s2 : statuses) {
            DotDrillFile f = DotDrillFile.create(fs, s2);
            if (f == null) continue;
            if (types.length == 0) {
                files.add(f);
                continue;
            }
            for (DotDrillType t : types) {
                if (t != f.getType()) continue;
                files.add(f);
            }
        }
        return files;
    }

    public static List<DotDrillFile> getDotDrills(DrillFileSystem fs, Path root, DotDrillType ... types) throws IOException {
        return DotDrillUtil.getDrillFiles(fs, DotDrillUtil.getDrillFileStatus(fs, root, "*.drill", new DotDrillType[0]), types);
    }

    public static List<DotDrillFile> getDotDrills(DrillFileSystem fs, Path root, String name, DotDrillType ... types) throws IOException {
        return DotDrillUtil.getDrillFiles(fs, DotDrillUtil.getDrillFileStatus(fs, root, name, types), types);
    }

    private static List<FileStatus> getDrillFileStatus(DrillFileSystem fs, Path root, String name, DotDrillType ... types) throws IOException {
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        if (name.endsWith(".drill")) {
            FileStatus[] status = fs.globStatus(new Path(root, name));
            if (status != null) {
                statuses.addAll(Arrays.asList(status));
            }
        } else {
            GlobPattern pathGlob;
            if (types.length == 0) {
                types = DotDrillType.values();
            }
            if ((pathGlob = new GlobPattern(new Path(root, name).toString())).hasWildcard()) {
                String patternAppliedName = name + DotDrillType.getDrillFileGlobPattern(types);
                FileStatus[] status = fs.globStatus(new Path(root, patternAppliedName));
                if (status != null) {
                    statuses.addAll(Arrays.asList(status));
                }
            } else {
                for (DotDrillType dotType : types) {
                    try {
                        FileStatus[] status = fs.listStatus(new Path(root, name + dotType.getEnding()));
                        statuses.addAll(Arrays.asList(status));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return statuses;
    }
}

