/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oadd.com.google.common.collect.ImmutableMap;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.AnyValueExpression;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.types.TypeProtos;

public class FunctionCallFactory {
    private static final Map<String, String> OP_TO_FUNC_NAME = ImmutableMap.builder().put("+", "add").put("-", "subtract").put("/", "divide").put("*", "multiply").put("%", "modulo").put("^", "xor").put("||", "concatOperator").put("or", "booleanOr").put("and", "booleanAnd").put(">", "greater_than").put("<", "less_than").put("==", "equal").put("=", "equal").put("!=", "not_equal").put("<>", "not_equal").put(">=", "greater_than_or_equal_to").put("<=", "less_than_or_equal_to").put("is null", "isnull").put("is not null", "isnotnull").put("is true", "istrue").put("is not true", "isnottrue").put("is false", "isfalse").put("is not false", "isnotfalse").put("similar to", "similar_to").put("!", "not").put("u-", "negative").build();

    public static String convertToDrillFunctionName(String op) {
        return OP_TO_FUNC_NAME.getOrDefault(op, op);
    }

    public static boolean isBooleanOperator(String funcName) {
        String drillFuncName = FunctionCallFactory.convertToDrillFunctionName(funcName);
        return drillFuncName.equals("booleanAnd") || drillFuncName.equals("booleanOr");
    }

    public static LogicalExpression createCast(TypeProtos.MajorType type, ExpressionPosition ep, LogicalExpression expr) {
        return new CastExpression(expr, type, ep);
    }

    public static LogicalExpression createConvert(String function, String conversionType, LogicalExpression expr, ExpressionPosition ep) {
        return new ConvertExpression(function, conversionType, expr, ep);
    }

    public static LogicalExpression createAnyValue(ExpressionPosition ep, LogicalExpression expr) {
        return new AnyValueExpression(expr, ep);
    }

    public static LogicalExpression createAnyValue(String functionName, List<LogicalExpression> args) {
        return FunctionCallFactory.createExpression(functionName, args);
    }

    public static LogicalExpression createExpression(String functionName, List<LogicalExpression> args) {
        return FunctionCallFactory.createExpression(functionName, ExpressionPosition.UNKNOWN, args);
    }

    public static LogicalExpression createExpression(String functionName, ExpressionPosition ep, List<LogicalExpression> args) {
        String name = FunctionCallFactory.convertToDrillFunctionName(functionName);
        if (FunctionCallFactory.isBooleanOperator(name)) {
            return new BooleanOperator(name, args, ep);
        }
        return new FunctionCall(name, args, ep);
    }

    public static LogicalExpression createExpression(String functionName, ExpressionPosition ep, LogicalExpression ... e) {
        return FunctionCallFactory.createExpression(functionName, ep, Lists.newArrayList(e));
    }

    public static LogicalExpression createBooleanOperator(String functionName, List<LogicalExpression> args) {
        return FunctionCallFactory.createBooleanOperator(functionName, ExpressionPosition.UNKNOWN, args);
    }

    public static LogicalExpression createBooleanOperator(String functionName, ExpressionPosition ep, List<LogicalExpression> args) {
        return new BooleanOperator(FunctionCallFactory.convertToDrillFunctionName(functionName), args, ep);
    }

    public static LogicalExpression createByOp(List<LogicalExpression> args, ExpressionPosition ep, List<String> opTypes) {
        if (args.size() == 1) {
            return args.get(0);
        }
        if (args.size() - 1 != opTypes.size()) {
            throw new DrillRuntimeException("Must receive one more expression then the provided number of operators.");
        }
        LogicalExpression first = args.get(0);
        for (int i = 0; i < opTypes.size(); ++i) {
            ArrayList<LogicalExpression> l2 = new ArrayList<LogicalExpression>();
            l2.add(first);
            l2.add(args.get(i + 1));
            first = FunctionCallFactory.createExpression(opTypes.get(i), ep, l2);
        }
        return first;
    }
}

