/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import oadd.com.fasterxml.jackson.core.JsonGenerationException;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonLocation;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.core.TreeNode;
import oadd.com.fasterxml.jackson.core.type.TypeReference;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.com.fasterxml.jackson.databind.node.TreeTraversingParser;
import oadd.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.config.LogicalPlanPersistence;
import oadd.org.apache.drill.common.exceptions.LogicalPlanParsingException;
import oadd.org.apache.drill.common.util.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=Se.class)
@JsonDeserialize(using=De.class)
public class JSONOptions {
    private static final Logger logger = LoggerFactory.getLogger(JSONOptions.class);
    private static final ObjectMapper DEFAULT_MAPPER = JacksonUtils.createObjectMapper();
    private JsonNode root;
    private JsonLocation location;
    private Object opaque;

    public JSONOptions(Object opaque) {
        this.opaque = opaque;
    }

    public JSONOptions(JsonNode n, JsonLocation location) {
        this.root = n;
        this.location = location;
    }

    public <T> T getWith(ObjectMapper mapper, Class<T> c) {
        try {
            if (this.opaque != null) {
                String cName;
                String opaqueName;
                Class<?> opaqueClass = this.opaque.getClass();
                if (opaqueClass.equals(c)) {
                    return (T)this.opaque;
                }
                if (c.isEnum() && (opaqueName = opaqueClass.getName().replaceAll("\\$\\d+$", "")).equals(cName = c.getName())) {
                    return (T)this.opaque;
                }
                throw new IllegalArgumentException(String.format("Attempted to retrieve a option with type of %s.  However, the JSON options carried an opaque value of type %s.", c.getName(), opaqueClass.getName()));
            }
            return mapper.treeToValue((TreeNode)this.root, c);
        }
        catch (JsonProcessingException e) {
            throw new LogicalPlanParsingException(String.format("Failure while trying to convert late bound json options to type of %s. Reference was originally located at line %d, column %d.", c.getCanonicalName(), this.location.getLineNr(), this.location.getColumnNr()), e);
        }
    }

    public <T> T getListWith(LogicalPlanPersistence config, TypeReference<T> t) throws IOException {
        return this.getListWith(config.getMapper(), t);
    }

    public JsonNode asNode() {
        Preconditions.checkArgument(this.root != null, "Attempted to grab JSONOptions as JsonNode when no root node was stored.  You can only convert non-opaque JSONOptions values to JsonNodes.");
        return this.root;
    }

    public JsonParser asParser() {
        Preconditions.checkArgument(this.root != null, "Attempted to grab JSONOptions as Parser when no root node was stored.  You can only convert non-opaque JSONOptions values to parsers.");
        return new TreeTraversingParser(this.root);
    }

    public <T> T getListWith(ObjectMapper mapper, TypeReference<T> t) throws IOException {
        if (this.opaque != null) {
            Type c = t.getType();
            if (c instanceof ParameterizedType) {
                c = ((ParameterizedType)c).getRawType();
            }
            if (c.equals(this.opaque.getClass())) {
                return (T)this.opaque;
            }
            throw new IOException(String.format("Attempted to retrieve a list with type of %s.  However, the JSON options carried an opaque value of type %s.", t.getType(), this.opaque.getClass().getName()));
        }
        if (this.root == null) {
            return null;
        }
        return mapper.treeAsTokens(this.root).readValueAs(t);
    }

    public <T> T getListWith(TypeReference<T> t) throws IOException {
        return this.getListWith(DEFAULT_MAPPER, t);
    }

    public JsonNode path(String name) {
        return this.root.path(name);
    }

    public JsonNode getRoot() {
        return this.root;
    }

    public static class Se
    extends StdSerializer<JSONOptions> {
        public Se() {
            super(JSONOptions.class);
        }

        @Override
        public void serialize(JSONOptions value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (value.opaque != null) {
                jgen.writeObject(value.opaque);
            } else {
                jgen.writeTree(value.root);
            }
        }
    }

    public static class De
    extends StdDeserializer<JSONOptions> {
        public De() {
            super(JSONOptions.class);
            logger.debug("Creating Deserializer.");
        }

        @Override
        public JSONOptions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonLocation l = jp.getTokenLocation();
            Object n = jp.readValueAsTree();
            if (n instanceof JsonNode) {
                return new JSONOptions((JsonNode)n, l);
            }
            throw new IllegalArgumentException(String.format("Received something other than a JsonNode %s", n));
        }
    }
}

