/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;

public class PerMessageDeflateExtension
extends CompressExtension {
    private static final Logger LOG = Log.getLogger(PerMessageDeflateExtension.class);
    private ExtensionConfig configRequested;
    private ExtensionConfig configNegotiated;
    private boolean incomingContextTakeover = true;
    private boolean outgoingContextTakeover = true;
    private boolean incomingCompressed;

    @Override
    public String getName() {
        return "permessage-deflate";
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (frame.getType().isData()) {
            this.incomingCompressed = frame.isRsv1();
        }
        if (OpCode.isControlFrame(frame.getOpCode()) || !this.incomingCompressed) {
            this.nextIncomingFrame(frame);
            return;
        }
        if (frame.getOpCode() == 0 && frame.isRsv1()) {
            throw new ProtocolException("Invalid RSV1 set on permessage-deflate CONTINUATION frame");
        }
        try (ByteAccumulator accumulator = this.newByteAccumulator();){
            ByteBuffer payload = frame.getPayload();
            this.decompress(accumulator, payload);
            if (frame.isFin()) {
                this.decompress(accumulator, TAIL_BYTES_BUF.slice());
            }
            this.forwardIncoming(frame, accumulator);
        }
        catch (DataFormatException e) {
            throw new BadPayloadException(e);
        }
        if (frame.isFin()) {
            this.incomingCompressed = false;
        }
    }

    @Override
    protected void nextIncomingFrame(Frame frame) {
        if (frame.isFin() && !this.incomingContextTakeover) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Incoming Context Reset", new Object[0]);
            }
            this.decompressCount.set(0);
            this.getInflater().reset();
        }
        super.nextIncomingFrame(frame);
    }

    @Override
    protected void nextOutgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame.isFin() && !this.outgoingContextTakeover) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Outgoing Context Reset", new Object[0]);
            }
            this.getDeflater().reset();
        }
        super.nextOutgoingFrame(frame, callback, batchMode);
    }

    @Override
    int getRsvUseMode() {
        return 1;
    }

    @Override
    int getTailDropMode() {
        return 2;
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        this.configRequested = new ExtensionConfig(config);
        this.configNegotiated = new ExtensionConfig(config.getName());
        block19: for (String key : config.getParameterKeys()) {
            switch (key = key.trim()) {
                case "client_max_window_bits": 
                case "server_max_window_bits": {
                    continue block19;
                }
                case "client_no_context_takeover": {
                    this.configNegotiated.setParameter("client_no_context_takeover");
                    switch (this.getPolicy().getBehavior()) {
                        case CLIENT: {
                            this.incomingContextTakeover = false;
                            break;
                        }
                        case SERVER: {
                            this.outgoingContextTakeover = false;
                        }
                    }
                    continue block19;
                }
                case "server_no_context_takeover": {
                    this.configNegotiated.setParameter("server_no_context_takeover");
                    switch (this.getPolicy().getBehavior()) {
                        case CLIENT: {
                            this.outgoingContextTakeover = false;
                            break;
                        }
                        case SERVER: {
                            this.incomingContextTakeover = false;
                        }
                    }
                    continue block19;
                }
            }
            throw new IllegalArgumentException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("config: outgoingContextTakeover={}, incomingContextTakeover={} : {}", new Object[]{this.outgoingContextTakeover, this.incomingContextTakeover, this});
        }
        super.setConfig(this.configNegotiated);
    }

    @Override
    public String toString() {
        return String.format("%s[requested=\"%s\", negotiated=\"%s\"]", this.getClass().getSimpleName(), this.configRequested.getParameterizedName(), this.configNegotiated.getParameterizedName());
    }
}

