/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce.srp;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.BigIntegers;

class SRP6Util {
    private static final byte[] colon = new byte[]{58};
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);

    SRP6Util() {
    }

    public static BigInteger calculateK(TlsHash digest, BigInteger N2, BigInteger g2) {
        return SRP6Util.hashPaddedPair(digest, N2, N2, g2);
    }

    public static BigInteger calculateU(TlsHash digest, BigInteger N2, BigInteger A2, BigInteger B) {
        return SRP6Util.hashPaddedPair(digest, N2, A2, B);
    }

    public static BigInteger calculateX(TlsHash digest, BigInteger N2, byte[] salt, byte[] identity, byte[] password) {
        digest.update(identity, 0, identity.length);
        digest.update(colon, 0, 1);
        digest.update(password, 0, password.length);
        byte[] output = digest.calculateHash();
        digest.update(salt, 0, salt.length);
        digest.update(output, 0, output.length);
        return new BigInteger(1, digest.calculateHash());
    }

    public static BigInteger generatePrivateValue(BigInteger N2, BigInteger g2, SecureRandom random) {
        int minBits = Math.min(256, N2.bitLength() / 2);
        BigInteger min2 = ONE.shiftLeft(minBits - 1);
        BigInteger max = N2.subtract(ONE);
        return BigIntegers.createRandomInRange(min2, max, random);
    }

    public static BigInteger validatePublicValue(BigInteger N2, BigInteger val) throws IllegalArgumentException {
        if ((val = val.mod(N2)).equals(ZERO)) {
            throw new IllegalArgumentException("Invalid public value: 0");
        }
        return val;
    }

    public static BigInteger calculateM1(TlsHash digest, BigInteger N2, BigInteger A2, BigInteger B, BigInteger S) {
        BigInteger M1 = SRP6Util.hashPaddedTriplet(digest, N2, A2, B, S);
        return M1;
    }

    public static BigInteger calculateM2(TlsHash digest, BigInteger N2, BigInteger A2, BigInteger M1, BigInteger S) {
        BigInteger M2 = SRP6Util.hashPaddedTriplet(digest, N2, A2, M1, S);
        return M2;
    }

    public static BigInteger calculateKey(TlsHash digest, BigInteger N2, BigInteger S) {
        int padLength = (N2.bitLength() + 7) / 8;
        byte[] _S = SRP6Util.getPadded(S, padLength);
        digest.update(_S, 0, _S.length);
        return new BigInteger(1, digest.calculateHash());
    }

    private static BigInteger hashPaddedTriplet(TlsHash digest, BigInteger N2, BigInteger n1, BigInteger n2, BigInteger n3) {
        int padLength = (N2.bitLength() + 7) / 8;
        byte[] n1_bytes = SRP6Util.getPadded(n1, padLength);
        byte[] n2_bytes = SRP6Util.getPadded(n2, padLength);
        byte[] n3_bytes = SRP6Util.getPadded(n3, padLength);
        digest.update(n1_bytes, 0, n1_bytes.length);
        digest.update(n2_bytes, 0, n2_bytes.length);
        digest.update(n3_bytes, 0, n3_bytes.length);
        return new BigInteger(1, digest.calculateHash());
    }

    private static BigInteger hashPaddedPair(TlsHash digest, BigInteger N2, BigInteger n1, BigInteger n2) {
        int padLength = (N2.bitLength() + 7) / 8;
        byte[] n1_bytes = SRP6Util.getPadded(n1, padLength);
        byte[] n2_bytes = SRP6Util.getPadded(n2, padLength);
        digest.update(n1_bytes, 0, n1_bytes.length);
        digest.update(n2_bytes, 0, n2_bytes.length);
        return new BigInteger(1, digest.calculateHash());
    }

    private static byte[] getPadded(BigInteger n, int length) {
        byte[] bs = BigIntegers.asUnsignedByteArray(n);
        if (bs.length < length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bs, 0, tmp, length - bs.length, bs.length);
            bs = tmp;
        }
        return bs;
    }
}

