/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.tls.TlsProtocol;

class TlsInputStream
extends InputStream {
    private final TlsProtocol handler;

    TlsInputStream(TlsProtocol handler) {
        this.handler = handler;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int ret = this.read(buf, 0, 1);
        return ret <= 0 ? -1 : buf[0] & 0xFF;
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        return this.handler.readApplicationData(buf, offset, len);
    }

    public int available() throws IOException {
        return this.handler.applicationDataAvailable();
    }

    public void close() throws IOException {
        this.handler.close();
    }
}

