/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;

public abstract class AbstractTlsKeyExchange
implements TlsKeyExchange {
    protected int keyExchange;
    protected TlsContext context;

    protected AbstractTlsKeyExchange(int keyExchange) {
        this.keyExchange = keyExchange;
    }

    public void init(TlsContext context) {
        this.context = context;
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public boolean requiresServerKeyExchange() {
        return false;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(80);
        }
        return null;
    }

    public void skipServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    public short[] getClientCertificateTypes() {
        return null;
    }

    public void skipClientCredentials() throws IOException {
    }

    public void processClientCertificate(Certificate clientCertificate) throws IOException {
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public boolean requiresCertificateVerify() {
        return true;
    }
}

