/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SSLSessionUtil;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

abstract class ProvSSLSessionBase
extends BCExtendedSSLSession {
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected ProvSSLSessionContext sslSessionContext;
    protected final boolean isFips;
    protected final JcaTlsCrypto crypto;
    protected final String peerHost;
    protected final int peerPort;
    protected final long creationTime;
    protected final SSLSession exportSSLSession;
    protected long lastAccessedTime;

    ProvSSLSessionBase(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort) {
        this.sslSessionContext = sslSessionContext;
        this.isFips = null == sslSessionContext ? false : sslSessionContext.getSSLContext().isFips();
        this.crypto = null == sslSessionContext ? null : sslSessionContext.getCrypto();
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.creationTime = System.currentTimeMillis();
        this.exportSSLSession = SSLSessionUtil.exportSSLSession(this);
        this.lastAccessedTime = this.creationTime;
    }

    protected abstract int getCipherSuiteTLS();

    protected abstract byte[] getIDArray();

    protected abstract JsseSecurityParameters getJsseSecurityParameters();

    protected abstract JsseSessionParameters getJsseSessionParameters();

    protected abstract Certificate getLocalCertificateTLS();

    protected abstract Certificate getPeerCertificateTLS();

    protected abstract ProtocolVersion getProtocolTLS();

    SSLSession getExportSSLSession() {
        return this.exportSSLSession;
    }

    synchronized void accessedAt(long accessTime) {
        this.lastAccessedTime = Math.max(this.lastAccessedTime, accessTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProvSSLSessionBase)) {
            return false;
        }
        ProvSSLSessionBase other = (ProvSSLSessionBase)obj;
        return Arrays.areEqual(this.getIDArray(), other.getIDArray());
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public String getCipherSuite() {
        return ProvSSLContextSpi.getCipherSuiteName(this.getCipherSuiteTLS());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        byte[] id = this.getIDArray();
        return TlsUtils.isNullOrEmpty(id) ? TlsUtils.EMPTY_BYTES : (byte[])id.clone();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public java.security.cert.Certificate[] getLocalCertificates() {
        java.security.cert.Certificate[] chain;
        if (null != this.crypto && null != (chain = JsseUtils.getX509CertificateChain(this.crypto, this.getLocalCertificateTLS())) && chain.length > 0) {
            return chain;
        }
        return null;
    }

    public Principal getLocalPrincipal() {
        if (null != this.crypto) {
            return JsseUtils.getSubject(this.crypto, this.getLocalCertificateTLS());
        }
        return null;
    }

    public int getPacketBufferSize() {
        ProtocolVersion protocolVersion = this.getProtocolTLS();
        if (null == protocolVersion || !TlsUtils.isTLSv12(protocolVersion)) {
            return 18443;
        }
        if (TlsUtils.isTLSv13(protocolVersion)) {
            return 16911;
        }
        return 17413;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        java.security.cert.X509Certificate[] peerCertificates = (java.security.cert.X509Certificate[])this.getPeerCertificates();
        X509Certificate[] chain = new X509Certificate[peerCertificates.length];
        try {
            for (int i = 0; i < peerCertificates.length; ++i) {
                chain[i] = this.isFips ? new X509CertificateWrapper(peerCertificates[i]) : X509Certificate.getInstance(peerCertificates[i].getEncoded());
            }
        }
        catch (Exception e) {
            throw new SSLPeerUnverifiedException(e.getMessage());
        }
        return chain;
    }

    public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        java.security.cert.Certificate[] chain;
        if (null != this.crypto && null != (chain = JsseUtils.getX509CertificateChain(this.crypto, this.getPeerCertificateTLS())) && chain.length > 0) {
            return chain;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal principal;
        if (null != this.crypto && null != (principal = JsseUtils.getSubject(this.crypto, this.getPeerCertificateTLS()))) {
            return principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getProtocol() {
        return ProvSSLContextSpi.getProtocolVersionName(this.getProtocolTLS());
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.sslSessionContext;
    }

    public Object getValue(String name) {
        return this.valueMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.getIDArray());
    }

    public synchronized void invalidate() {
        if (null != this.sslSessionContext) {
            this.sslSessionContext.removeSession(this.getIDArray());
            this.sslSessionContext = null;
        }
    }

    public synchronized boolean isValid() {
        if (null == this.sslSessionContext) {
            return false;
        }
        return !TlsUtils.isNullOrEmpty(this.getIDArray());
    }

    public void putValue(String name, Object value) {
        this.notifyUnbound(name, this.valueMap.put(name, value));
        this.notifyBound(name, value);
    }

    public void removeValue(String name) {
        this.notifyUnbound(name, this.valueMap.remove(name));
    }

    public String toString() {
        return "Session(" + this.getCreationTime() + "|" + this.getCipherSuite() + ")";
    }

    protected void notifyBound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    protected void notifyUnbound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    private static class X509CertificateWrapper
    extends X509Certificate {
        private final java.security.cert.X509Certificate c;

        private X509CertificateWrapper(java.security.cert.X509Certificate c) {
            this.c = c;
        }

        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            try {
                this.c.checkValidity();
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
        }

        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            try {
                this.c.checkValidity(date);
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
        }

        public int getVersion() {
            return this.c.getVersion() - 1;
        }

        public BigInteger getSerialNumber() {
            return this.c.getSerialNumber();
        }

        public Principal getIssuerDN() {
            return this.c.getIssuerX500Principal();
        }

        public Principal getSubjectDN() {
            return this.c.getSubjectX500Principal();
        }

        public Date getNotBefore() {
            return this.c.getNotBefore();
        }

        public Date getNotAfter() {
            return this.c.getNotAfter();
        }

        public String getSigAlgName() {
            return this.c.getSigAlgName();
        }

        public String getSigAlgOID() {
            return this.c.getSigAlgOID();
        }

        public byte[] getSigAlgParams() {
            return this.c.getSigAlgParams();
        }

        public byte[] getEncoded() throws CertificateEncodingException {
            try {
                return this.c.getEncoded();
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
        }

        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            try {
                this.c.verify(key);
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
            catch (CertificateParsingException e) {
                throw new javax.security.cert.CertificateParsingException(e.getMessage());
            }
            catch (java.security.cert.CertificateException e) {
                throw new CertificateException(e.getMessage());
            }
        }

        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            try {
                this.c.verify(key, sigProvider);
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
            catch (CertificateParsingException e) {
                throw new javax.security.cert.CertificateParsingException(e.getMessage());
            }
            catch (java.security.cert.CertificateException e) {
                throw new CertificateException(e.getMessage());
            }
        }

        public String toString() {
            return this.c.toString();
        }

        public PublicKey getPublicKey() {
            return this.c.getPublicKey();
        }
    }
}

