/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.Arrays;

public final class AsymmetricEdDSAPrivateKey
extends AsymmetricEdDSAKey
implements Destroyable,
AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] keyData;
    private boolean hasPublicKey;
    private byte[] publicData;
    private ASN1Set attributes;
    private int hashCode;

    public AsymmetricEdDSAPrivateKey(Algorithm algorithm, byte[] byArray, byte[] byArray2) {
        super(algorithm);
        this.keyData = Arrays.clone(byArray);
        this.hashCode = this.calculateHashCode();
        this.attributes = null;
        if (byArray2 == null) {
            this.hasPublicKey = false;
            this.publicData = EdEC.computePublicData(algorithm, byArray);
        } else {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(byArray2);
        }
    }

    public AsymmetricEdDSAPrivateKey(byte[] byArray) throws IOException {
        this(PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricEdDSAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(EdECObjectIdentifiers.id_Ed448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519);
        ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
        this.keyData = Arrays.clone(ASN1OctetString.getInstance(aSN1Encodable).getOctets());
        if (privateKeyInfo.hasPublicKey()) {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(privateKeyInfo.getPublicKeyData().getOctets());
        }
        if (EdECObjectIdentifiers.id_Ed448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? this.keyData.length != 57 : this.keyData.length != 32) {
            throw new IllegalArgumentException("raw key data incorrect size");
        }
        this.attributes = privateKeyInfo.getAttributes();
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getSecret() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return Arrays.clone(this.keyData);
    }

    public byte[] getPublicData() {
        KeyUtils.checkDestroyed(this);
        return Arrays.clone(this.publicData);
    }

    public byte[] getEncoded() {
        byte[] byArray;
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        byte[] byArray2 = byArray = this.hasPublicKey ? this.publicData : null;
        if (this.getAlgorithm().equals(EdEC.Algorithm.Ed448)) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448), new DEROctetString(this.keyData), this.attributes, byArray);
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), new DEROctetString(this.keyData), this.attributes, byArray);
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.keyData);
            if (this.publicData != null) {
                Arrays.clear(this.publicData);
            }
            this.publicData = null;
            this.hasPublicKey = false;
            this.attributes = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricEdDSAPrivateKey)) {
            return false;
        }
        AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey = (AsymmetricEdDSAPrivateKey)object;
        if (this.isDestroyed() || asymmetricEdDSAPrivateKey.isDestroyed()) {
            return false;
        }
        if (!Arrays.areEqual(this.keyData, asymmetricEdDSAPrivateKey.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(asymmetricEdDSAPrivateKey.getAlgorithm());
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.getAlgorithm().hashCode();
        n = 31 * n + Arrays.hashCode(this.keyData);
        return n;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

