/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.vector.accessor.InvalidAccessException;
import oadd.org.apache.drill.exec.vector.accessor.SqlAccessor;
import org.apache.drill.jdbc.SQLConversionOverflowException;

class TypeConvertingSqlAccessor
implements SqlAccessor {
    private final SqlAccessor innerAccessor;

    public TypeConvertingSqlAccessor(SqlAccessor innerAccessor) {
        this.innerAccessor = innerAccessor;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.innerAccessor.getType();
    }

    @Override
    public Class<?> getObjectClass() {
        return this.innerAccessor.getObjectClass();
    }

    @Override
    public boolean isNull(int rowOffset) {
        return this.innerAccessor.isNull(rowOffset);
    }

    private static SQLConversionOverflowException newOverflowException(String methodLabel, String valueTypeLabel, Object value) {
        return new SQLConversionOverflowException(methodLabel + " can't return " + valueTypeLabel + " value " + value + " (too large) ");
    }

    private static byte getByteValueOrThrow(long value, String typeLabel) throws SQLConversionOverflowException {
        if (-128L <= value && value <= 127L) {
            return (byte)value;
        }
        throw TypeConvertingSqlAccessor.newOverflowException("getByte(...)", typeLabel, value);
    }

    private static byte getByteValueOrThrow(double value, String typeLabel) throws SQLConversionOverflowException {
        if (-128.0 <= value && value <= 127.0) {
            return (byte)value;
        }
        throw TypeConvertingSqlAccessor.newOverflowException("getByte(...)", typeLabel, value);
    }

    @Override
    public byte getByte(int rowOffset) throws InvalidAccessException {
        byte result;
        switch (this.getType().getMinorType()) {
            case TINYINT: {
                result = this.innerAccessor.getByte(rowOffset);
                break;
            }
            case SMALLINT: {
                result = TypeConvertingSqlAccessor.getByteValueOrThrow(this.innerAccessor.getShort(rowOffset), "Java short / SQL SMALLINT");
                break;
            }
            case INT: {
                result = TypeConvertingSqlAccessor.getByteValueOrThrow(this.innerAccessor.getInt(rowOffset), "Java int / SQL INTEGER");
                break;
            }
            case BIGINT: {
                result = TypeConvertingSqlAccessor.getByteValueOrThrow(this.innerAccessor.getLong(rowOffset), "Java long / SQL BIGINT");
                break;
            }
            case FLOAT4: {
                result = TypeConvertingSqlAccessor.getByteValueOrThrow(this.innerAccessor.getFloat(rowOffset), "Java float / SQL REAL/FLOAT");
                break;
            }
            case FLOAT8: {
                result = TypeConvertingSqlAccessor.getByteValueOrThrow(this.innerAccessor.getDouble(rowOffset), "Java double / SQL DOUBLE PRECISION");
                break;
            }
            case VARDECIMAL: {
                result = TypeConvertingSqlAccessor.getByteValueOrThrow(this.innerAccessor.getBigDecimal(rowOffset).byteValue(), "Java BigDecimal / SQL DECIMAL PRECISION");
                break;
            }
            default: {
                result = this.innerAccessor.getByte(rowOffset);
            }
        }
        return result;
    }

    private static short getShortValueOrThrow(long value, String typeLabel) throws SQLConversionOverflowException {
        if (-32768L <= value && value <= 32767L) {
            return (short)value;
        }
        throw TypeConvertingSqlAccessor.newOverflowException("getShort(...)", typeLabel, value);
    }

    private static short getShortValueOrThrow(double value, String typeLabel) throws SQLConversionOverflowException {
        if (-32768.0 <= value && value <= 32767.0) {
            return (short)value;
        }
        throw TypeConvertingSqlAccessor.newOverflowException("getShort(...)", typeLabel, value);
    }

    @Override
    public short getShort(int rowOffset) throws InvalidAccessException {
        short result;
        switch (this.getType().getMinorType()) {
            case SMALLINT: {
                result = this.innerAccessor.getShort(rowOffset);
                break;
            }
            case TINYINT: {
                result = this.innerAccessor.getByte(rowOffset);
                break;
            }
            case INT: {
                result = TypeConvertingSqlAccessor.getShortValueOrThrow(this.innerAccessor.getInt(rowOffset), "Java int / SQL INTEGER");
                break;
            }
            case BIGINT: {
                result = TypeConvertingSqlAccessor.getShortValueOrThrow(this.innerAccessor.getLong(rowOffset), "Java long / SQL BIGINT");
                break;
            }
            case FLOAT4: {
                result = TypeConvertingSqlAccessor.getShortValueOrThrow(this.innerAccessor.getFloat(rowOffset), "Java float / SQL REAL/FLOAT");
                break;
            }
            case FLOAT8: {
                result = TypeConvertingSqlAccessor.getShortValueOrThrow(this.innerAccessor.getDouble(rowOffset), "Java double / SQL DOUBLE PRECISION");
                break;
            }
            case VARDECIMAL: {
                result = TypeConvertingSqlAccessor.getShortValueOrThrow(this.innerAccessor.getBigDecimal(rowOffset).shortValue(), "Java BigDecimal / SQL DECIMAL PRECISION");
                break;
            }
            default: {
                result = this.innerAccessor.getByte(rowOffset);
            }
        }
        return result;
    }

    private static int getIntValueOrThrow(long value, String typeLabel) throws SQLConversionOverflowException {
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw TypeConvertingSqlAccessor.newOverflowException("getInt(...)", typeLabel, value);
    }

    private static int getIntValueOrThrow(double value, String typeLabel) throws SQLConversionOverflowException {
        if (-2.147483648E9 <= value && value <= 2.147483647E9) {
            return (int)value;
        }
        throw TypeConvertingSqlAccessor.newOverflowException("getInt(...)", typeLabel, value);
    }

    @Override
    public int getInt(int rowOffset) throws InvalidAccessException {
        int result;
        switch (this.getType().getMinorType()) {
            case INT: {
                result = this.innerAccessor.getInt(rowOffset);
                break;
            }
            case TINYINT: {
                result = this.innerAccessor.getByte(rowOffset);
                break;
            }
            case SMALLINT: {
                result = this.innerAccessor.getShort(rowOffset);
                break;
            }
            case BIGINT: {
                result = TypeConvertingSqlAccessor.getIntValueOrThrow(this.innerAccessor.getLong(rowOffset), "Java long / SQL BIGINT");
                break;
            }
            case FLOAT4: {
                result = TypeConvertingSqlAccessor.getIntValueOrThrow(this.innerAccessor.getFloat(rowOffset), "Java float / SQL REAL/FLOAT");
                break;
            }
            case FLOAT8: {
                result = TypeConvertingSqlAccessor.getIntValueOrThrow(this.innerAccessor.getDouble(rowOffset), "Java double / SQL DOUBLE PRECISION");
                break;
            }
            case VARDECIMAL: {
                result = TypeConvertingSqlAccessor.getIntValueOrThrow(this.innerAccessor.getBigDecimal(rowOffset).intValue(), "Java BigDecimal / SQL DECIMAL PRECISION");
                break;
            }
            default: {
                result = this.innerAccessor.getInt(rowOffset);
            }
        }
        return result;
    }

    private static long getLongValueOrThrow(double value, String typeLabel) throws SQLConversionOverflowException {
        if (-9.223372036854776E18 <= value && value <= 9.223372036854776E18) {
            return (long)value;
        }
        throw TypeConvertingSqlAccessor.newOverflowException("getLong(...)", typeLabel, value);
    }

    @Override
    public long getLong(int rowOffset) throws InvalidAccessException {
        long result;
        switch (this.getType().getMinorType()) {
            case BIGINT: {
                result = this.innerAccessor.getLong(rowOffset);
                break;
            }
            case TINYINT: {
                result = this.innerAccessor.getByte(rowOffset);
                break;
            }
            case SMALLINT: {
                result = this.innerAccessor.getShort(rowOffset);
                break;
            }
            case INT: {
                result = this.innerAccessor.getInt(rowOffset);
                break;
            }
            case FLOAT4: {
                result = TypeConvertingSqlAccessor.getLongValueOrThrow(this.innerAccessor.getFloat(rowOffset), "Java float / SQL REAL/FLOAT");
                break;
            }
            case FLOAT8: {
                result = TypeConvertingSqlAccessor.getLongValueOrThrow(this.innerAccessor.getDouble(rowOffset), "Java double / SQL DOUBLE PRECISION");
                break;
            }
            case VARDECIMAL: {
                result = TypeConvertingSqlAccessor.getLongValueOrThrow(this.innerAccessor.getBigDecimal(rowOffset).longValue(), "Java BigDecimal / SQL DECIMAL PRECISION");
                break;
            }
            default: {
                result = this.innerAccessor.getLong(rowOffset);
            }
        }
        return result;
    }

    private static float getFloatValueOrThrow(double value, String typeLabel) throws SQLConversionOverflowException {
        if ((double)1.4E-45f <= value && value <= 3.4028234663852886E38) {
            return (float)value;
        }
        throw TypeConvertingSqlAccessor.newOverflowException("getFloat(...)", typeLabel, value);
    }

    @Override
    public float getFloat(int rowOffset) throws InvalidAccessException {
        float result;
        switch (this.getType().getMinorType()) {
            case FLOAT4: {
                result = this.innerAccessor.getFloat(rowOffset);
                break;
            }
            case INT: {
                result = this.innerAccessor.getInt(rowOffset);
                break;
            }
            case BIGINT: {
                result = this.innerAccessor.getLong(rowOffset);
                break;
            }
            case FLOAT8: {
                result = TypeConvertingSqlAccessor.getFloatValueOrThrow(this.innerAccessor.getDouble(rowOffset), "Java double / SQL DOUBLE PRECISION");
                break;
            }
            case VARDECIMAL: {
                result = TypeConvertingSqlAccessor.getFloatValueOrThrow(this.innerAccessor.getBigDecimal(rowOffset).floatValue(), "Java BigDecimal / SQL DECIMAL PRECISION");
                break;
            }
            default: {
                result = this.innerAccessor.getInt(rowOffset);
            }
        }
        return result;
    }

    @Override
    public double getDouble(int rowOffset) throws InvalidAccessException {
        double result;
        switch (this.getType().getMinorType()) {
            case FLOAT8: {
                result = this.innerAccessor.getDouble(rowOffset);
                break;
            }
            case INT: {
                result = this.innerAccessor.getInt(rowOffset);
                break;
            }
            case BIGINT: {
                result = this.innerAccessor.getLong(rowOffset);
                break;
            }
            case FLOAT4: {
                result = this.innerAccessor.getFloat(rowOffset);
                break;
            }
            case VARDECIMAL: {
                result = this.innerAccessor.getBigDecimal(rowOffset).doubleValue();
                break;
            }
            default: {
                result = this.innerAccessor.getLong(rowOffset);
            }
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(int rowOffset) throws InvalidAccessException {
        BigDecimal result;
        switch (this.getType().getMinorType()) {
            case VARDECIMAL: 
            case DECIMAL9: 
            case DECIMAL18: 
            case DECIMAL28SPARSE: 
            case DECIMAL38SPARSE: {
                result = this.innerAccessor.getBigDecimal(rowOffset);
                break;
            }
            case TINYINT: {
                result = new BigDecimal(this.innerAccessor.getByte(rowOffset));
                break;
            }
            case SMALLINT: {
                result = new BigDecimal(this.innerAccessor.getShort(rowOffset));
                break;
            }
            case INT: {
                result = new BigDecimal(this.innerAccessor.getInt(rowOffset));
                break;
            }
            case BIGINT: {
                result = new BigDecimal(this.innerAccessor.getLong(rowOffset));
                break;
            }
            case FLOAT4: {
                result = new BigDecimal(this.innerAccessor.getFloat(rowOffset));
                break;
            }
            case FLOAT8: {
                result = new BigDecimal(this.innerAccessor.getDouble(rowOffset));
                break;
            }
            default: {
                result = this.innerAccessor.getBigDecimal(rowOffset);
            }
        }
        return result;
    }

    @Override
    public boolean getBoolean(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getBoolean(rowOffset);
    }

    @Override
    public String getString(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getString(rowOffset);
    }

    @Override
    public byte[] getBytes(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getBytes(rowOffset);
    }

    @Override
    public Date getDate(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getDate(rowOffset);
    }

    @Override
    public Time getTime(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getTime(rowOffset);
    }

    @Override
    public Timestamp getTimestamp(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getTimestamp(rowOffset);
    }

    @Override
    public Object getObject(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getObject(rowOffset);
    }

    @Override
    public char getChar(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getChar(rowOffset);
    }

    @Override
    public InputStream getStream(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getStream(rowOffset);
    }

    @Override
    public Reader getReader(int rowOffset) throws InvalidAccessException {
        return this.innerAccessor.getReader(rowOffset);
    }
}

