/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oadd.com.google.common.collect.ImmutableList;
import oadd.org.apache.calcite.avatica.ColumnMetaData;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.jdbc.impl.BasicList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillColumnMetaDataList
extends BasicList<ColumnMetaData> {
    static final Logger logger = LoggerFactory.getLogger(DrillColumnMetaDataList.class);
    private List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public ColumnMetaData get(int index) {
        return this.columns.get(index);
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(String sqlTypeName) {
        int jdbcTypeId = Types.getJdbcTypeCode(sqlTypeName);
        return ColumnMetaData.scalar(jdbcTypeId, sqlTypeName, ColumnMetaData.Rep.BOOLEAN);
    }

    public void updateColumnMetaData(List<UserProtos.ResultColumnMetadata> metadata) {
        ArrayList<ColumnMetaData> newColumns = new ArrayList<ColumnMetaData>(metadata.size());
        int offset = 0;
        for (UserProtos.ResultColumnMetadata m4 : metadata) {
            ColumnMetaData.AvaticaType bundledSqlDataType = DrillColumnMetaDataList.getAvaticaType(m4.getDataType());
            newColumns.add(new ColumnMetaData(offset, m4.getAutoIncrement(), m4.getCaseSensitivity(), m4.getSearchability() != UserProtos.ColumnSearchability.NONE, m4.getIsCurrency(), m4.getIsNullable() ? 1 : 0, m4.getSigned(), m4.getDisplaySize(), m4.getLabel(), m4.getColumnName(), m4.getSchemaName(), m4.getPrecision(), m4.getScale(), m4.getTableName(), m4.getCatalogName(), bundledSqlDataType, m4.getUpdatability() == UserProtos.ColumnUpdatability.READ_ONLY, m4.getUpdatability() == UserProtos.ColumnUpdatability.WRITABLE, m4.getUpdatability() == UserProtos.ColumnUpdatability.WRITABLE, m4.getClassName()));
            ++offset;
        }
        this.columns = ImmutableList.copyOf(newColumns);
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(TypeProtos.MajorType rpcDateType) {
        String sqlTypeName = Types.getSqlTypeName(rpcDateType);
        int jdbcTypeId = Types.getJdbcTypeCode(sqlTypeName);
        return ColumnMetaData.scalar(jdbcTypeId, sqlTypeName, ColumnMetaData.Rep.BOOLEAN);
    }

    public void updateColumnMetaData(String catalogName, String schemaName, String tableName, BatchSchema schema, List<Class<?>> getObjectClasses) {
        ArrayList<ColumnMetaData> newColumns = new ArrayList<ColumnMetaData>(schema.getFieldCount());
        for (int colOffset = 0; colOffset < schema.getFieldCount(); ++colOffset) {
            int nullability;
            MaterializedField field = schema.getColumn(colOffset);
            Class<?> objectClass = getObjectClasses.get(colOffset);
            String columnName = field.getName();
            TypeProtos.MajorType rpcDataType = field.getType();
            ColumnMetaData.AvaticaType bundledSqlDataType = DrillColumnMetaDataList.getAvaticaType(rpcDataType);
            String columnClassName = objectClass.getName();
            switch (field.getDataMode()) {
                case OPTIONAL: {
                    nullability = 1;
                    break;
                }
                case REQUIRED: {
                    nullability = 0;
                    break;
                }
                case REPEATED: {
                    nullability = 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected new DataMode value '" + field.getDataMode().name() + "'"));
                }
            }
            boolean isSigned = Types.isJdbcSignedType(rpcDataType);
            int precision = Types.getPrecision(rpcDataType);
            int scale = Types.getScale(rpcDataType);
            int displaySize = Types.getJdbcDisplaySize(rpcDataType);
            ColumnMetaData col = new ColumnMetaData(colOffset, false, false, true, false, nullability, isSigned, displaySize, columnName, columnName, schemaName, precision, scale, tableName, catalogName, bundledSqlDataType, true, false, false, columnClassName);
            newColumns.add(col);
        }
        this.columns = newColumns;
    }

    @Override
    public boolean contains(Object o) {
        return this.columns.contains(o);
    }

    @Override
    public Iterator<ColumnMetaData> iterator() {
        return this.columns.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.columns.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.columns.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.columns.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.columns.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.columns.lastIndexOf(o);
    }

    @Override
    public ListIterator<ColumnMetaData> listIterator() {
        return this.columns.listIterator();
    }

    @Override
    public ListIterator<ColumnMetaData> listIterator(int index) {
        return this.columns.listIterator(index);
    }

    @Override
    public List<ColumnMetaData> subList(int fromIndex, int toIndex) {
        return this.columns.subList(fromIndex, toIndex);
    }
}

