/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.common;

import java.util.Objects;
import oadd.org.apache.zookeeper.common.BCFKSFileLoader;
import oadd.org.apache.zookeeper.common.FileKeyStoreLoader;
import oadd.org.apache.zookeeper.common.JKSFileLoader;
import oadd.org.apache.zookeeper.common.KeyStoreFileType;
import oadd.org.apache.zookeeper.common.PEMFileLoader;
import oadd.org.apache.zookeeper.common.PKCS12FileLoader;

public class FileKeyStoreLoaderBuilderProvider {
    static FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> getBuilderForKeyStoreFileType(KeyStoreFileType type) {
        switch (Objects.requireNonNull(type)) {
            case JKS: {
                return new JKSFileLoader.Builder();
            }
            case PEM: {
                return new PEMFileLoader.Builder();
            }
            case PKCS12: {
                return new PKCS12FileLoader.Builder();
            }
            case BCFKS: {
                return new BCFKSFileLoader.Builder();
            }
        }
        throw new AssertionError((Object)("Unexpected StoreFileType: " + type.name()));
    }
}

