/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oadd.org.apache.zookeeper.AsyncCallback;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.ZooKeeper;
import oadd.org.apache.zookeeper.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);

    public static void deleteRecursive(ZooKeeper zk, String pathRoot) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting " + tree);
        LOG.debug("Deleting " + tree.size() + " subnodes ");
        for (int i = tree.size() - 1; i >= 0; --i) {
            zk.delete(tree.get(i), -1);
        }
    }

    public static void deleteRecursive(ZooKeeper zk, String pathRoot, AsyncCallback.VoidCallback cb, Object ctx) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting " + tree);
        LOG.debug("Deleting " + tree.size() + " subnodes ");
        for (int i = tree.size() - 1; i >= 0; --i) {
            zk.delete(tree.get(i), -1, cb, ctx);
        }
    }

    public static List<String> listSubTreeBFS(ZooKeeper zk, String pathRoot) throws KeeperException, InterruptedException {
        String node;
        LinkedList<Object> queue = new LinkedList<Object>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(pathRoot);
        tree.add(pathRoot);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = zk.getChildren(node, false);
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    public static void visitSubTreeDFS(ZooKeeper zk, String path, boolean watch, AsyncCallback.StringCallback cb) throws KeeperException, InterruptedException {
        PathUtils.validatePath(path);
        zk.getData(path, watch, null);
        cb.processResult(KeeperException.Code.OK.intValue(), path, null, path);
        ZKUtil.visitSubTreeDFSHelper(zk, path, watch, cb);
    }

    private static void visitSubTreeDFSHelper(ZooKeeper zk, String path, boolean watch, AsyncCallback.StringCallback cb) throws KeeperException, InterruptedException {
        boolean isRoot = path.length() == 1;
        try {
            String childPath;
            List<String> children = zk.getChildren(path, watch, null);
            Collections.sort(children);
            for (String child : children) {
                childPath = (String)(isRoot ? path : path + "/") + child;
                cb.processResult(KeeperException.Code.OK.intValue(), childPath, null, child);
            }
            for (String child : children) {
                childPath = (String)(isRoot ? path : path + "/") + child;
                ZKUtil.visitSubTreeDFSHelper(zk, childPath, watch, cb);
            }
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
    }
}

