/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDecimal9Holder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedDecimal9WriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal9Writer;

public class RepeatedDecimal9HolderReaderImpl
extends AbstractFieldReader {
    private NullableDecimal9Holder holder = new NullableDecimal9Holder();
    private int index = -1;
    private RepeatedDecimal9Holder repeatedHolder;

    public RepeatedDecimal9HolderReaderImpl(RepeatedDecimal9Holder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return BasicTypeHelper.getType(this.holder);
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public BigDecimal readBigDecimal(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        BigDecimal value = this.readBigDecimal();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public BigDecimal readBigDecimal() {
        if (!this.isSet()) {
            return null;
        }
        BigInteger value = BigInteger.valueOf(this.holder.value);
        return new BigDecimal(value, this.holder.scale);
    }

    @Override
    public Object readObject() {
        ArrayList<BigDecimal> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        BigInteger value = BigInteger.valueOf(this.holder.value);
        return new BigDecimal(value, this.holder.scale);
    }

    @Override
    public void copyAsValue(Decimal9Writer writer) {
        RepeatedDecimal9WriterImpl impl = (RepeatedDecimal9WriterImpl)writer;
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedDecimal9WriterImpl impl = (RepeatedDecimal9WriterImpl)writer.list(name).decimal9();
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }
}

