/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableDateHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDateHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedDateWriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.DateWriter;

public class RepeatedDateHolderReaderImpl
extends AbstractFieldReader {
    private NullableDateHolder holder = new NullableDateHolder();
    private int index = -1;
    private RepeatedDateHolder repeatedHolder;

    public RepeatedDateHolderReaderImpl(RepeatedDateHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedDateHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public LocalDate readLocalDate(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        LocalDate value = this.readLocalDate();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public LocalDate readLocalDate() {
        if (!this.isSet()) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public Object readObject() {
        ArrayList<LocalDate> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public void copyAsValue(DateWriter writer) {
        RepeatedDateWriterImpl impl = (RepeatedDateWriterImpl)writer;
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedDateWriterImpl impl = (RepeatedDateWriterImpl)writer.list(name).date();
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }
}

