/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.exec.vector.UInt4Vector;

public class EmptyValuePopulator {
    private final UInt4Vector offsets;

    public EmptyValuePopulator(UInt4Vector offsets) {
        this.offsets = Preconditions.checkNotNull(offsets, "offsets cannot be null");
    }

    public void populate(int valueCount) {
        Preconditions.checkElementIndex(valueCount, Integer.MAX_VALUE);
        UInt4Vector.Accessor accessor = this.offsets.getAccessor();
        int currentCount = accessor.getValueCount();
        UInt4Vector.Mutator mutator = this.offsets.getMutator();
        if (currentCount == 0) {
            mutator.setSafe(0, 0);
            currentCount = 1;
        }
        int previousEnd = accessor.get(currentCount - 1);
        int offsetCount = valueCount + 1;
        for (int i = currentCount; i < offsetCount; ++i) {
            mutator.setSafe(i, previousEnd);
        }
        mutator.setValueCount(offsetCount);
    }
}

