/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import oadd.com.google.common.base.Charsets;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BigIntVector;
import oadd.org.apache.drill.exec.vector.DateUtilities;
import oadd.org.apache.drill.exec.vector.DateVector;
import oadd.org.apache.drill.exec.vector.Decimal18Vector;
import oadd.org.apache.drill.exec.vector.Decimal28SparseVector;
import oadd.org.apache.drill.exec.vector.Decimal38SparseVector;
import oadd.org.apache.drill.exec.vector.Decimal9Vector;
import oadd.org.apache.drill.exec.vector.Float4Vector;
import oadd.org.apache.drill.exec.vector.Float8Vector;
import oadd.org.apache.drill.exec.vector.IntVector;
import oadd.org.apache.drill.exec.vector.IntervalDayVector;
import oadd.org.apache.drill.exec.vector.IntervalVector;
import oadd.org.apache.drill.exec.vector.IntervalYearVector;
import oadd.org.apache.drill.exec.vector.SmallIntVector;
import oadd.org.apache.drill.exec.vector.TimeStampVector;
import oadd.org.apache.drill.exec.vector.TimeVector;
import oadd.org.apache.drill.exec.vector.TinyIntVector;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.UInt2Vector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.UInt8Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.Var16CharVector;
import oadd.org.apache.drill.exec.vector.VarBinaryVector;
import oadd.org.apache.drill.exec.vector.VarCharVector;
import oadd.org.apache.drill.exec.vector.VarDecimalVector;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.InvalidConversionError;
import oadd.org.apache.drill.exec.vector.accessor.ValueType;
import oadd.org.apache.drill.exec.vector.accessor.reader.BaseScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractFixedWidthWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseVarWidthWriter;
import oadd.org.joda.time.Period;

public class ColumnAccessors {
    public static final LocalDateTime LOCAL_EPOCH = LocalDateTime.of(1970, 1, 1, 0, 0, 0);

    public static class VarDecimalColumnWriter
    extends BaseVarWidthWriter {
        private final VarDecimalVector vector;
        private int precision;
        private int scale;

        public VarDecimalColumnWriter(ValueVector vector) {
            super(((VarDecimalVector)vector).getOffsetVector());
            TypeProtos.MajorType type = vector.getField().getType();
            this.precision = type.hasPrecision() ? type.getPrecision() : Types.maxPrecision(type.getMinorType());
            this.scale = type.hasScale() ? type.getScale() : 0;
            this.vector = (VarDecimalVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setBytes(byte[] value, int len) {
            int offset = this.prepareWrite(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.setNextOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void setInt(int value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setLong(long value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setDouble(double value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setFloat(float value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            try {
                BigDecimal rounded = value.setScale(this.scale, RoundingMode.HALF_UP);
                DecimalUtility.checkValueOverflow(rounded, this.precision, this.scale);
                byte[] barr = rounded.unscaledValue().toByteArray();
                this.setBytes(barr, barr.length);
            }
            catch (ArithmeticException e) {
                throw new InvalidConversionError("Decimal conversion failed for " + value, e);
            }
        }

        @Override
        public final void setValue(Object value) {
            throw new InvalidConversionError("Generic object not supported for type VarDecimal, setBytes(byte[], final int len)");
        }

        @Override
        public final void setDefaultValue(Object value) {
            BigDecimal rounded = ((BigDecimal)value).setScale(this.scale, RoundingMode.HALF_UP);
            DecimalUtility.checkValueOverflow(rounded, this.precision, this.scale);
            this.emptyValue = rounded.unscaledValue().toByteArray();
        }

        @Override
        public final void copy(ColumnReader from) {
            VarDecimalColumnReader source = (VarDecimalColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            long entry = source.getEntry();
            int sourceOffset = (int)(entry >> 32);
            int len = (int)(entry & 0xFFFFFFFFFFFFFFFFL);
            int destOffset = this.prepareWrite(len);
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, len);
            this.offsetsWriter.setNextOffset(destOffset + len);
            this.vectorIndex.nextElement();
        }
    }

    public static class VarDecimalColumnReader
    extends BaseScalarReader.BaseVarWidthReader {
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public byte[] getBytes() {
            DrillBuf buf = this.bufferAccessor.buffer();
            long entry = this.offsetsReader.getEntry();
            return buf.unsafeGetMemory((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        public BigDecimal getDecimal() {
            byte[] bytes = this.getBytes();
            BigInteger unscaledValue = bytes.length == 0 ? BigInteger.ZERO : new BigInteger(bytes);
            return new BigDecimal(unscaledValue, this.type.getScale());
        }
    }

    public static class Var16CharColumnWriter
    extends BaseVarWidthWriter {
        private final Var16CharVector vector;

        public Var16CharColumnWriter(ValueVector vector) {
            super(((Var16CharVector)vector).getOffsetVector());
            this.vector = (Var16CharVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public ValueType valueType() {
            return ValueType.STRING;
        }

        @Override
        public final void setBytes(byte[] value, int len) {
            int offset = this.prepareWrite(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.setNextOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void appendBytes(byte[] value, int len) {
            this.vectorIndex.prevElement();
            int offset = this.prepareAppend(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.reviseOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void setString(String value) {
            byte[] bytes = value.getBytes(Charsets.UTF_16);
            this.setBytes(bytes, bytes.length);
        }

        @Override
        public final void setValue(Object value) {
            throw new InvalidConversionError("Generic object not supported for type Var16Char, setBytes(byte[], final int len)");
        }

        @Override
        public final void setDefaultValue(Object value) {
            this.emptyValue = ((String)value).getBytes(Charsets.UTF_16);
        }

        @Override
        public final void copy(ColumnReader from) {
            Var16CharColumnReader source = (Var16CharColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            long entry = source.getEntry();
            int sourceOffset = (int)(entry >> 32);
            int len = (int)(entry & 0xFFFFFFFFFFFFFFFFL);
            int destOffset = this.prepareWrite(len);
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, len);
            this.offsetsWriter.setNextOffset(destOffset + len);
            this.vectorIndex.nextElement();
        }
    }

    public static class Var16CharColumnReader
    extends BaseScalarReader.BaseVarWidthReader {
        @Override
        public ValueType valueType() {
            return ValueType.STRING;
        }

        @Override
        public byte[] getBytes() {
            DrillBuf buf = this.bufferAccessor.buffer();
            long entry = this.offsetsReader.getEntry();
            return buf.unsafeGetMemory((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        public String getString() {
            return new String(this.getBytes(), Charsets.UTF_16);
        }
    }

    public static class VarCharColumnWriter
    extends BaseVarWidthWriter {
        private final VarCharVector vector;

        public VarCharColumnWriter(ValueVector vector) {
            super(((VarCharVector)vector).getOffsetVector());
            this.vector = (VarCharVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public ValueType valueType() {
            return ValueType.STRING;
        }

        @Override
        public final void setBytes(byte[] value, int len) {
            int offset = this.prepareWrite(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.setNextOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void appendBytes(byte[] value, int len) {
            this.vectorIndex.prevElement();
            int offset = this.prepareAppend(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.reviseOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void setString(String value) {
            byte[] bytes = value.getBytes(Charsets.UTF_8);
            this.setBytes(bytes, bytes.length);
        }

        @Override
        public final void setValue(Object value) {
            this.setString((String)value);
        }

        @Override
        public final void setDefaultValue(Object value) {
            this.emptyValue = ((String)value).getBytes(Charsets.UTF_8);
        }

        @Override
        public final void copy(ColumnReader from) {
            VarCharColumnReader source = (VarCharColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            long entry = source.getEntry();
            int sourceOffset = (int)(entry >> 32);
            int len = (int)(entry & 0xFFFFFFFFFFFFFFFFL);
            int destOffset = this.prepareWrite(len);
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, len);
            this.offsetsWriter.setNextOffset(destOffset + len);
            this.vectorIndex.nextElement();
        }
    }

    public static class VarCharColumnReader
    extends BaseScalarReader.BaseVarWidthReader {
        @Override
        public ValueType valueType() {
            return ValueType.STRING;
        }

        @Override
        public byte[] getBytes() {
            DrillBuf buf = this.bufferAccessor.buffer();
            long entry = this.offsetsReader.getEntry();
            return buf.unsafeGetMemory((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        public String getString() {
            return new String(this.getBytes(), Charsets.UTF_8);
        }
    }

    public static class VarBinaryColumnWriter
    extends BaseVarWidthWriter {
        private final VarBinaryVector vector;

        public VarBinaryColumnWriter(ValueVector vector) {
            super(((VarBinaryVector)vector).getOffsetVector());
            this.vector = (VarBinaryVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public ValueType valueType() {
            return ValueType.BYTES;
        }

        @Override
        public final void setBytes(byte[] value, int len) {
            int offset = this.prepareWrite(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.setNextOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void appendBytes(byte[] value, int len) {
            this.vectorIndex.prevElement();
            int offset = this.prepareAppend(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.reviseOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void setValue(Object value) {
            throw new InvalidConversionError("Generic object not supported for type VarBinary, setBytes(byte[], final int len)");
        }

        @Override
        public final void setDefaultValue(Object value) {
            this.emptyValue = (byte[])value;
        }

        @Override
        public final void copy(ColumnReader from) {
            VarBinaryColumnReader source = (VarBinaryColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            long entry = source.getEntry();
            int sourceOffset = (int)(entry >> 32);
            int len = (int)(entry & 0xFFFFFFFFFFFFFFFFL);
            int destOffset = this.prepareWrite(len);
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, len);
            this.offsetsWriter.setNextOffset(destOffset + len);
            this.vectorIndex.nextElement();
        }
    }

    public static class VarBinaryColumnReader
    extends BaseScalarReader.BaseVarWidthReader {
        @Override
        public ValueType valueType() {
            return ValueType.BYTES;
        }

        @Override
        public byte[] getBytes() {
            DrillBuf buf = this.bufferAccessor.buffer();
            long entry = this.offsetsReader.getEntry();
            return buf.unsafeGetMemory((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static class Decimal28SparseColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 20;
        private final Decimal28SparseVector vector;
        private TypeProtos.MajorType type;

        public Decimal28SparseColumnWriter(ValueVector vector) {
            this.type = vector.getField().getType();
            this.vector = (Decimal28SparseVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 20;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            int offset = this.prepareWrite() * 20;
            DecimalUtility.getSparseFromBigDecimal(value, this.drillBuf, offset, this.type.getScale(), 5);
            this.vectorIndex.nextElement();
        }

        public final void writeDecimal(DrillBuf buf, BigDecimal value) {
            boolean offset = false;
            DecimalUtility.getSparseFromBigDecimal(value, buf, 0, this.type.getScale(), 5);
            buf.writerIndex(20);
        }

        @Override
        public final void setInt(int value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setLong(long value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setDouble(double value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setFloat(float value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setDecimal((BigDecimal)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(20);){
                this.writeDecimal(buf, (BigDecimal)value);
                this.emptyValue = new byte[20];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            Decimal28SparseColumnReader source = (Decimal28SparseColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 20;
            int destOffset = this.prepareWrite() * 20;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 20);
            this.vectorIndex.nextElement();
        }
    }

    public static class Decimal28SparseColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 20;
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public int width() {
            return 20;
        }

        @Override
        public BigDecimal getDecimal() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DecimalUtility.getBigDecimalFromSparse(buf, readOffset * 20, 5, this.type.getScale());
        }
    }

    public static class Decimal38SparseColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 24;
        private final Decimal38SparseVector vector;
        private TypeProtos.MajorType type;

        public Decimal38SparseColumnWriter(ValueVector vector) {
            this.type = vector.getField().getType();
            this.vector = (Decimal38SparseVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 24;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            int offset = this.prepareWrite() * 24;
            DecimalUtility.getSparseFromBigDecimal(value, this.drillBuf, offset, this.type.getScale(), 6);
            this.vectorIndex.nextElement();
        }

        public final void writeDecimal(DrillBuf buf, BigDecimal value) {
            boolean offset = false;
            DecimalUtility.getSparseFromBigDecimal(value, buf, 0, this.type.getScale(), 6);
            buf.writerIndex(24);
        }

        @Override
        public final void setInt(int value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setLong(long value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setDouble(double value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setFloat(float value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setDecimal((BigDecimal)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(24);){
                this.writeDecimal(buf, (BigDecimal)value);
                this.emptyValue = new byte[24];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            Decimal38SparseColumnReader source = (Decimal38SparseColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 24;
            int destOffset = this.prepareWrite() * 24;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 24);
            this.vectorIndex.nextElement();
        }
    }

    public static class Decimal38SparseColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 24;
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public int width() {
            return 24;
        }

        @Override
        public BigDecimal getDecimal() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DecimalUtility.getBigDecimalFromSparse(buf, readOffset * 24, 6, this.type.getScale());
        }
    }

    public static class IntervalColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 16;
        private final IntervalVector vector;

        public IntervalColumnWriter(ValueVector vector) {
            this.vector = (IntervalVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 16;
        }

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public final void setPeriod(Period value) {
            int offset = this.prepareWrite() * 16;
            this.drillBuf.setInt(offset, DateUtilities.periodToMonths(value));
            this.drillBuf.setInt(offset + 4, value.getDays());
            this.drillBuf.setInt(offset + 8, DateUtilities.periodToMillis(value));
            this.vectorIndex.nextElement();
        }

        public final void writePeriod(DrillBuf buf, Period value) {
            boolean offset = false;
            buf.setInt(0, DateUtilities.periodToMonths(value));
            buf.setInt(4, value.getDays());
            buf.setInt(8, DateUtilities.periodToMillis(value));
            buf.writerIndex(16);
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setPeriod((Period)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(16);){
                this.writePeriod(buf, (Period)value);
                this.emptyValue = new byte[16];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            IntervalColumnReader source = (IntervalColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 16;
            int destOffset = this.prepareWrite() * 16;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 16);
            this.vectorIndex.nextElement();
        }
    }

    public static class IntervalColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 16;

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public int width() {
            return 16;
        }

        @Override
        public Period getPeriod() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            int offset = readOffset * 16;
            return DateUtilities.fromInterval(buf.getInt(offset), buf.getInt(offset + 4), buf.getInt(offset + 8));
        }
    }

    public static class IntervalDayColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 12;
        private final IntervalDayVector vector;

        public IntervalDayColumnWriter(ValueVector vector) {
            this.vector = (IntervalDayVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 12;
        }

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public final void setPeriod(Period value) {
            int offset = this.prepareWrite() * 12;
            this.drillBuf.setInt(offset, value.getDays());
            this.drillBuf.setInt(offset + 4, DateUtilities.periodToMillis(value));
            this.vectorIndex.nextElement();
        }

        public final void writePeriod(DrillBuf buf, Period value) {
            boolean offset = false;
            buf.setInt(0, value.getDays());
            buf.setInt(4, DateUtilities.periodToMillis(value));
            buf.writerIndex(12);
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setPeriod((Period)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(12);){
                this.writePeriod(buf, (Period)value);
                this.emptyValue = new byte[12];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            IntervalDayColumnReader source = (IntervalDayColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 12;
            int destOffset = this.prepareWrite() * 12;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 12);
            this.vectorIndex.nextElement();
        }
    }

    public static class IntervalDayColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 12;

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public int width() {
            return 12;
        }

        @Override
        public Period getPeriod() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            int offset = readOffset * 12;
            return DateUtilities.fromIntervalDay(buf.getInt(offset), buf.getInt(offset + 4));
        }
    }

    public static class Decimal18ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final Decimal18Vector vector;
        private TypeProtos.MajorType type;

        public Decimal18ColumnWriter(ValueVector vector) {
            this.type = vector.getField().getType();
            this.vector = (Decimal18Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            int offset = this.prepareWrite() * 8;
            this.drillBuf.setLong(offset, DecimalUtility.getDecimal18FromBigDecimal(value, this.type.getScale()));
            this.vectorIndex.nextElement();
        }

        public final void writeDecimal(DrillBuf buf, BigDecimal value) {
            boolean offset = false;
            buf.setLong(0, DecimalUtility.getDecimal18FromBigDecimal(value, this.type.getScale()));
            buf.writerIndex(8);
        }

        @Override
        public final void setInt(int value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setLong(long value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setDouble(double value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setFloat(float value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setDecimal((BigDecimal)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(8);){
                this.writeDecimal(buf, (BigDecimal)value);
                this.emptyValue = new byte[8];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            Decimal18ColumnReader source = (Decimal18ColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 8;
            int destOffset = this.prepareWrite() * 8;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 8);
            this.vectorIndex.nextElement();
        }
    }

    public static class Decimal18ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public BigDecimal getDecimal() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DecimalUtility.getBigDecimalFromPrimitiveTypes(buf.getLong(readOffset * 8), this.type.getScale());
        }
    }

    public static class TimeStampColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final TimeStampVector vector;

        public TimeStampColumnWriter(ValueVector vector) {
            this.vector = (TimeStampVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public ValueType extendedType() {
            return ValueType.TIMESTAMP;
        }

        @Override
        public final void setLong(long value) {
            int offset = this.prepareWrite() * 8;
            this.drillBuf.setLong(offset, value);
            this.vectorIndex.nextElement();
        }

        public final void writeLong(DrillBuf buf, long value) {
            boolean offset = false;
            buf.setLong(0, value);
            buf.writerIndex(8);
        }

        @Override
        public final void setTimestamp(Instant value) {
            this.setLong(DateUtilities.toDrillTimestamp(value));
        }

        @Override
        public final void setValue(Object value) {
            this.setTimestamp((Instant)value);
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(8);){
                this.writeLong(buf, DateUtilities.toDrillTimestamp((Instant)value));
                this.emptyValue = new byte[8];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            TimeStampColumnReader source = (TimeStampColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 8;
            int destOffset = this.prepareWrite() * 8;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 8);
            this.vectorIndex.nextElement();
        }
    }

    public static class TimeStampColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public ValueType extendedType() {
            return ValueType.TIMESTAMP;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getLong() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getLong(readOffset * 8);
        }

        @Override
        public final Instant getTimestamp() {
            return DateUtilities.fromDrillTimestamp(this.getLong());
        }
    }

    public static class DateColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final DateVector vector;

        public DateColumnWriter(ValueVector vector) {
            this.vector = (DateVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public ValueType extendedType() {
            return ValueType.DATE;
        }

        @Override
        public final void setLong(long value) {
            int offset = this.prepareWrite() * 8;
            this.drillBuf.setLong(offset, value);
            this.vectorIndex.nextElement();
        }

        public final void writeLong(DrillBuf buf, long value) {
            boolean offset = false;
            buf.setLong(0, value);
            buf.writerIndex(8);
        }

        @Override
        public final void setDate(LocalDate value) {
            this.setLong(DateUtilities.toDrillDate(value));
        }

        @Override
        public final void setValue(Object value) {
            this.setDate((LocalDate)value);
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(8);){
                this.writeLong(buf, DateUtilities.toDrillDate((LocalDate)value));
                this.emptyValue = new byte[8];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            DateColumnReader source = (DateColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 8;
            int destOffset = this.prepareWrite() * 8;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 8);
            this.vectorIndex.nextElement();
        }
    }

    public static class DateColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public ValueType extendedType() {
            return ValueType.DATE;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getLong() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getLong(readOffset * 8);
        }

        @Override
        public final LocalDate getDate() {
            return DateUtilities.fromDrillDate(this.getLong());
        }
    }

    public static class Float8ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final Float8Vector vector;

        public Float8ColumnWriter(ValueVector vector) {
            this.vector = (Float8Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DOUBLE;
        }

        @Override
        public final void setDouble(double value) {
            int offset = this.prepareWrite() * 8;
            this.drillBuf.setLong(offset, Double.doubleToRawLongBits(value));
            this.vectorIndex.nextElement();
        }

        public final void writeDouble(DrillBuf buf, double value) {
            boolean offset = false;
            buf.setLong(0, Double.doubleToRawLongBits(value));
            buf.writerIndex(8);
        }

        @Override
        public final void setInt(int value) {
            this.setDouble(value);
        }

        @Override
        public final void setLong(long value) {
            this.setDouble(value);
        }

        @Override
        public final void setFloat(float value) {
            this.setDouble(value);
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            this.setDouble(value.doubleValue());
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setDouble((Double)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(8);){
                this.writeDouble(buf, (Double)value);
                this.emptyValue = new byte[8];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            Float8ColumnReader source = (Float8ColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 8;
            int destOffset = this.prepareWrite() * 8;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 8);
            this.vectorIndex.nextElement();
        }
    }

    public static class Float8ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.DOUBLE;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public double getDouble() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return Double.longBitsToDouble(buf.getLong(readOffset * 8));
        }
    }

    public static class UInt8ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final UInt8Vector vector;

        public UInt8ColumnWriter(ValueVector vector) {
            this.vector = (UInt8Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public final void setLong(long value) {
            int offset = this.prepareWrite() * 8;
            this.drillBuf.setLong(offset, value);
            this.vectorIndex.nextElement();
        }

        public final void writeLong(DrillBuf buf, long value) {
            boolean offset = false;
            buf.setLong(0, value);
            buf.writerIndex(8);
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setLong((Long)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(8);){
                this.writeLong(buf, (Long)value);
                this.emptyValue = new byte[8];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            UInt8ColumnReader source = (UInt8ColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 8;
            int destOffset = this.prepareWrite() * 8;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 8);
            this.vectorIndex.nextElement();
        }
    }

    public static class UInt8ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getLong() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getLong(readOffset * 8);
        }
    }

    public static class BigIntColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final BigIntVector vector;

        public BigIntColumnWriter(ValueVector vector) {
            this.vector = (BigIntVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public final void setLong(long value) {
            int offset = this.prepareWrite() * 8;
            this.drillBuf.setLong(offset, value);
            this.vectorIndex.nextElement();
        }

        public final void writeLong(DrillBuf buf, long value) {
            boolean offset = false;
            buf.setLong(0, value);
            buf.writerIndex(8);
        }

        @Override
        public final void setInt(int value) {
            this.setLong(value);
        }

        @Override
        public final void setFloat(float value) {
            this.setLong(Math.round(value));
        }

        @Override
        public final void setDouble(double value) {
            this.setLong(Math.round(value));
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            try {
                this.setLong(value.longValueExact());
            }
            catch (ArithmeticException e) {
                throw InvalidConversionError.writeError(this.schema(), value, e);
            }
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setLong((Long)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(8);){
                this.writeLong(buf, (Long)value);
                this.emptyValue = new byte[8];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            BigIntColumnReader source = (BigIntColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 8;
            int destOffset = this.prepareWrite() * 8;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 8);
            this.vectorIndex.nextElement();
        }
    }

    public static class BigIntColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getLong() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getLong(readOffset * 8);
        }
    }

    public static class Decimal9ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final Decimal9Vector vector;
        private TypeProtos.MajorType type;

        public Decimal9ColumnWriter(ValueVector vector) {
            this.type = vector.getField().getType();
            this.vector = (Decimal9Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            int offset = this.prepareWrite() * 4;
            this.drillBuf.setInt(offset, DecimalUtility.getDecimal9FromBigDecimal(value, this.type.getScale()));
            this.vectorIndex.nextElement();
        }

        public final void writeDecimal(DrillBuf buf, BigDecimal value) {
            boolean offset = false;
            buf.setInt(0, DecimalUtility.getDecimal9FromBigDecimal(value, this.type.getScale()));
            buf.writerIndex(4);
        }

        @Override
        public final void setInt(int value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setLong(long value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setDouble(double value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setFloat(float value) {
            this.setDecimal(BigDecimal.valueOf(value));
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setDecimal((BigDecimal)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(4);){
                this.writeDecimal(buf, (BigDecimal)value);
                this.emptyValue = new byte[4];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            Decimal9ColumnReader source = (Decimal9ColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 4;
            int destOffset = this.prepareWrite() * 4;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 4);
            this.vectorIndex.nextElement();
        }
    }

    public static class Decimal9ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public BigDecimal getDecimal() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DecimalUtility.getBigDecimalFromPrimitiveTypes(buf.getInt(readOffset * 4), this.type.getScale());
        }
    }

    public static class IntervalYearColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final IntervalYearVector vector;

        public IntervalYearColumnWriter(ValueVector vector) {
            this.vector = (IntervalYearVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public final void setPeriod(Period value) {
            int offset = this.prepareWrite() * 4;
            this.drillBuf.setInt(offset, value.getYears() * 12 + value.getMonths());
            this.vectorIndex.nextElement();
        }

        public final void writePeriod(DrillBuf buf, Period value) {
            boolean offset = false;
            buf.setInt(0, value.getYears() * 12 + value.getMonths());
            buf.writerIndex(4);
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setPeriod((Period)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(4);){
                this.writePeriod(buf, (Period)value);
                this.emptyValue = new byte[4];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            IntervalYearColumnReader source = (IntervalYearColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 4;
            int destOffset = this.prepareWrite() * 4;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 4);
            this.vectorIndex.nextElement();
        }
    }

    public static class IntervalYearColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public Period getPeriod() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DateUtilities.fromIntervalYear(buf.getInt(readOffset * 4));
        }
    }

    public static class TimeColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final TimeVector vector;

        public TimeColumnWriter(ValueVector vector) {
            this.vector = (TimeVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public ValueType extendedType() {
            return ValueType.TIME;
        }

        @Override
        public final void setInt(int value) {
            int offset = this.prepareWrite() * 4;
            this.drillBuf.setInt(offset, value);
            this.vectorIndex.nextElement();
        }

        public final void writeInt(DrillBuf buf, int value) {
            boolean offset = false;
            buf.setInt(0, value);
            buf.writerIndex(4);
        }

        @Override
        public final void setTime(LocalTime value) {
            this.setInt(DateUtilities.toDrillTime(value));
        }

        @Override
        public final void setValue(Object value) {
            this.setTime((LocalTime)value);
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(4);){
                this.writeInt(buf, DateUtilities.toDrillTime((LocalTime)value));
                this.emptyValue = new byte[4];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            TimeColumnReader source = (TimeColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 4;
            int destOffset = this.prepareWrite() * 4;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 4);
            this.vectorIndex.nextElement();
        }
    }

    public static class TimeColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public ValueType extendedType() {
            return ValueType.TIME;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getInt(readOffset * 4);
        }

        @Override
        public final LocalTime getTime() {
            return DateUtilities.fromDrillTime(this.getInt());
        }
    }

    public static class Float4ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final Float4Vector vector;

        public Float4ColumnWriter(ValueVector vector) {
            this.vector = (Float4Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.FLOAT;
        }

        @Override
        public final void setFloat(float value) {
            int offset = this.prepareWrite() * 4;
            this.drillBuf.setInt(offset, Float.floatToRawIntBits(value));
            this.vectorIndex.nextElement();
        }

        public final void writeFloat(DrillBuf buf, float value) {
            boolean offset = false;
            buf.setInt(0, Float.floatToRawIntBits(value));
            buf.writerIndex(4);
        }

        @Override
        public final void setInt(int value) {
            this.setFloat(value);
        }

        @Override
        public final void setLong(long value) {
            this.setFloat(value);
        }

        @Override
        public final void setDouble(double value) {
            this.setFloat((float)value);
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            this.setFloat(value.floatValue());
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setFloat(((Float)value).floatValue());
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(4);){
                this.writeFloat(buf, ((Float)value).floatValue());
                this.emptyValue = new byte[4];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            Float4ColumnReader source = (Float4ColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 4;
            int destOffset = this.prepareWrite() * 4;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 4);
            this.vectorIndex.nextElement();
        }
    }

    public static class Float4ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.FLOAT;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public float getFloat() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return Float.intBitsToFloat(buf.getInt(readOffset * 4));
        }

        @Override
        public double getDouble() {
            return this.getFloat();
        }
    }

    public static class UInt4ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final UInt4Vector vector;

        public UInt4ColumnWriter(ValueVector vector) {
            this.vector = (UInt4Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int offset = this.prepareWrite() * 4;
            this.drillBuf.setInt(offset, value);
            this.vectorIndex.nextElement();
        }

        public final void writeInt(DrillBuf buf, int value) {
            boolean offset = false;
            buf.setInt(0, value);
            buf.writerIndex(4);
        }

        @Override
        public final void setValue(Object value) {
            if (value != null) {
                this.setInt((Integer)value);
            }
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(4);){
                this.writeInt(buf, (Integer)value);
                this.emptyValue = new byte[4];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            UInt4ColumnReader source = (UInt4ColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 4;
            int destOffset = this.prepareWrite() * 4;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 4);
            this.vectorIndex.nextElement();
        }
    }

    public static class UInt4ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getInt(readOffset * 4);
        }
    }

    public static class IntColumnWriter
    extends AbstractFixedWidthWriter.BaseIntWriter {
        private static final int VALUE_WIDTH = 4;
        private final IntVector vector;

        public IntColumnWriter(ValueVector vector) {
            this.vector = (IntVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int offset = this.prepareWrite() * 4;
            this.drillBuf.setInt(offset, value);
            this.vectorIndex.nextElement();
        }

        public final void writeInt(DrillBuf buf, int value) {
            boolean offset = false;
            buf.setInt(0, value);
            buf.writerIndex(4);
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(4);){
                this.writeInt(buf, (Integer)value);
                this.emptyValue = new byte[4];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            IntColumnReader source = (IntColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 4;
            int destOffset = this.prepareWrite() * 4;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 4);
            this.vectorIndex.nextElement();
        }
    }

    public static class IntColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getInt(readOffset * 4);
        }
    }

    public static class SmallIntColumnWriter
    extends AbstractFixedWidthWriter.BaseIntWriter {
        private static final int VALUE_WIDTH = 2;
        private final SmallIntVector vector;

        public SmallIntColumnWriter(ValueVector vector) {
            this.vector = (SmallIntVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int offset = this.prepareWrite() * 2;
            this.drillBuf.setShort(offset, (short)value);
            this.vectorIndex.nextElement();
        }

        public final void writeInt(DrillBuf buf, int value) {
            boolean offset = false;
            buf.setShort(0, (short)value);
            buf.writerIndex(2);
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(2);){
                this.writeInt(buf, (Integer)value);
                this.emptyValue = new byte[2];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            SmallIntColumnReader source = (SmallIntColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 2;
            int destOffset = this.prepareWrite() * 2;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 2);
            this.vectorIndex.nextElement();
        }
    }

    public static class SmallIntColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 2;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getShort(readOffset * 2);
        }
    }

    public static class UInt2ColumnWriter
    extends AbstractFixedWidthWriter.BaseIntWriter {
        private static final int VALUE_WIDTH = 2;
        private final UInt2Vector vector;

        public UInt2ColumnWriter(ValueVector vector) {
            this.vector = (UInt2Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int offset = this.prepareWrite() * 2;
            this.drillBuf.setShort(offset, (short)value);
            this.vectorIndex.nextElement();
        }

        public final void writeInt(DrillBuf buf, int value) {
            boolean offset = false;
            buf.setShort(0, (short)value);
            buf.writerIndex(2);
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(2);){
                this.writeInt(buf, (Integer)value);
                this.emptyValue = new byte[2];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            UInt2ColumnReader source = (UInt2ColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 2;
            int destOffset = this.prepareWrite() * 2;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 2);
            this.vectorIndex.nextElement();
        }
    }

    public static class UInt2ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 2;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getShort(readOffset * 2) & 0xFFFF;
        }
    }

    public static class UInt1ColumnWriter
    extends AbstractFixedWidthWriter.BaseIntWriter {
        private static final int VALUE_WIDTH = 1;
        private final UInt1Vector vector;

        public UInt1ColumnWriter(ValueVector vector) {
            this.vector = (UInt1Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int offset = this.prepareWrite() * 1;
            this.drillBuf.setByte(offset, (byte)value);
            this.vectorIndex.nextElement();
        }

        public final void writeInt(DrillBuf buf, int value) {
            boolean offset = false;
            buf.setByte(0, (byte)value);
            buf.writerIndex(1);
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(1);){
                this.writeInt(buf, (Integer)value);
                this.emptyValue = new byte[1];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            UInt1ColumnReader source = (UInt1ColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 1;
            int destOffset = this.prepareWrite() * 1;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 1);
            this.vectorIndex.nextElement();
        }
    }

    public static class UInt1ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 1;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getByte(readOffset * 1) & 0xFF;
        }
    }

    public static class TinyIntColumnWriter
    extends AbstractFixedWidthWriter.BaseIntWriter {
        private static final int VALUE_WIDTH = 1;
        private final TinyIntVector vector;

        public TinyIntColumnWriter(ValueVector vector) {
            this.vector = (TinyIntVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int offset = this.prepareWrite() * 1;
            this.drillBuf.setByte(offset, (byte)value);
            this.vectorIndex.nextElement();
        }

        public final void writeInt(DrillBuf buf, int value) {
            boolean offset = false;
            buf.setByte(0, (byte)value);
            buf.writerIndex(1);
        }

        @Override
        public final void setDefaultValue(Object value) {
            try (DrillBuf buf = this.vector.getAllocator().buffer(1);){
                this.writeInt(buf, (Integer)value);
                this.emptyValue = new byte[1];
                buf.getBytes(0, this.emptyValue);
            }
        }

        @Override
        public final void copy(ColumnReader from) {
            TinyIntColumnReader source = (TinyIntColumnReader)from;
            DrillBuf sourceBuf = source.buffer();
            int sourceOffset = source.offsetIndex() * 1;
            int destOffset = this.prepareWrite() * 1;
            this.drillBuf.setBytes(destOffset, sourceBuf, sourceOffset, 1);
            this.vectorIndex.nextElement();
        }
    }

    public static class TinyIntColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 1;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getByte(readOffset * 1);
        }
    }
}

