/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.IOException;
import java.util.List;
import oadd.com.google.common.base.Strings;
import oadd.org.apache.drill.exec.util.FileSystemUtil;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class DrillFileSystemUtil {
    public static final PathFilter DRILL_SYSTEM_FILTER = path -> !path.getName().startsWith("_") && !path.getName().startsWith(".");

    public static List<FileStatus> listDirectories(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        return FileSystemUtil.listDirectories(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }

    public static List<FileStatus> listDirectoriesSafe(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) {
        return FileSystemUtil.listDirectoriesSafe(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }

    public static List<FileStatus> listFiles(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        return FileSystemUtil.listFiles(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }

    public static List<FileStatus> listFilesSafe(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) {
        return FileSystemUtil.listFilesSafe(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }

    public static List<FileStatus> listAll(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        return FileSystemUtil.listAll(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }

    public static List<FileStatus> listAllSafe(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) {
        return FileSystemUtil.listAllSafe(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }

    public static Path createPathSafe(String path) {
        return Strings.isNullOrEmpty(path) ? new Path("/") : new Path(path);
    }
}

