/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.testing;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oadd.com.fasterxml.jackson.annotation.JsonSubTypes;
import oadd.com.fasterxml.jackson.annotation.JsonTypeInfo;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionMetaData;
import oadd.org.apache.drill.exec.server.options.OptionSet;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.TypeValidators;
import oadd.org.apache.drill.exec.testing.CountDownLatchInjection;
import oadd.org.apache.drill.exec.testing.CountDownLatchInjectionImpl;
import oadd.org.apache.drill.exec.testing.ExceptionInjection;
import oadd.org.apache.drill.exec.testing.ExecutionControlsInjector;
import oadd.org.apache.drill.exec.testing.Injection;
import oadd.org.apache.drill.exec.testing.InjectionSite;
import oadd.org.apache.drill.exec.testing.NoOpControlsInjector;
import oadd.org.apache.drill.exec.testing.PauseInjection;
import oadd.org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionControls {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionControls.class);
    public static final ObjectMapper controlsOptionMapper = new ObjectMapper();
    public static final String EMPTY_CONTROLS = "{\"injections\" : []}";
    @JsonDeserialize(keyUsing=InjectionSite.InjectionSiteKeyDeserializer.class)
    private final Map<InjectionSite, Injection> controls = new HashMap<InjectionSite, Injection>();
    private final CoordinationProtos.DrillbitEndpoint endpoint;

    public static void validateControlsString(String jsonString) throws IOException {
        controlsOptionMapper.readValue(jsonString, Controls.class);
    }

    @VisibleForTesting
    public ExecutionControls(OptionManager options) {
        this(options, null);
    }

    public ExecutionControls(OptionManager options, CoordinationProtos.DrillbitEndpoint endpoint) {
        Controls controls;
        this.endpoint = endpoint;
        if (!AssertionUtil.isAssertionsEnabled()) {
            return;
        }
        OptionValue optionValue = options.getOption("drill.exec.testing.controls");
        if (optionValue == null) {
            return;
        }
        String opString = optionValue.string_val;
        try {
            controls = controlsOptionMapper.readValue(opString, Controls.class);
        }
        catch (IOException e) {
            logger.warn("Could not parse injections. Injections must have been validated before this point.");
            throw new DrillRuntimeException("Could not parse injections.", e);
        }
        if (controls.injections == null) {
            return;
        }
        logger.debug("Adding control injections: \n{}", (Object)opString);
        for (Injection injection : controls.injections) {
            this.controls.put(new InjectionSite(injection.getSiteClass(), injection.getDesc()), injection);
        }
    }

    public ExceptionInjection lookupExceptionInjection(ExecutionControlsInjector injector, String desc) {
        Injection injection = this.lookupInjection(injector, desc);
        return injection != null ? (ExceptionInjection)injection : null;
    }

    public PauseInjection lookupPauseInjection(ExecutionControlsInjector injector, String desc) {
        Injection injection = this.lookupInjection(injector, desc);
        return injection != null ? (PauseInjection)injection : null;
    }

    public CountDownLatchInjection lookupCountDownLatchInjection(ExecutionControlsInjector injector, String desc) {
        Injection injection = this.lookupInjection(injector, desc);
        return injection != null ? (CountDownLatchInjection)((Object)injection) : NoOpControlsInjector.LATCH;
    }

    private Injection lookupInjection(ExecutionControlsInjector injector, String desc) {
        if (this.controls.isEmpty()) {
            return null;
        }
        InjectionSite site = new InjectionSite(injector.getSiteClass(), desc);
        Injection injection = this.controls.get(site);
        if (injection == null) {
            return null;
        }
        return injection.isValidForBit(this.endpoint) ? injection : null;
    }

    public void unpauseAll() {
        for (Injection injection : this.controls.values()) {
            if (!(injection instanceof PauseInjection)) continue;
            ((PauseInjection)injection).unpause();
        }
    }

    static {
        controlsOptionMapper.addMixInAnnotations(Injection.class, InjectionMixIn.class);
    }

    private static class Controls {
        public Collection<? extends Injection> injections;

        private Controls() {
        }
    }

    public static class ControlsOptionValidator
    extends TypeValidators.TypeValidator {
        private final int ttl;

        public ControlsOptionValidator(String name, int ttl, OptionValidator.OptionDescription description) {
            super(name, OptionValue.Kind.STRING, description);
            assert (ttl > 0);
            this.ttl = ttl;
        }

        @Override
        public int getTtl() {
            return this.ttl;
        }

        @Override
        public boolean isShortLived() {
            return true;
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            String jsonString = v.string_val;
            try {
                ExecutionControls.validateControlsString(jsonString);
            }
            catch (IOException e) {
                throw UserException.validationError().message(String.format("Invalid controls option string (%s) due to %s.", jsonString, e.getMessage()), new Object[0]).build(logger);
            }
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ExceptionInjection.class, name="exception"), @JsonSubTypes.Type(value=CountDownLatchInjectionImpl.class, name="latch"), @JsonSubTypes.Type(value=PauseInjection.class, name="pause")})
    public static abstract class InjectionMixIn {
    }
}

