/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr.config;

import java.util.List;
import java.util.Map;
import oadd.com.google.common.collect.Maps;
import oadd.com.typesafe.config.Config;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.resourcemgr.NodeResources;
import oadd.org.apache.drill.exec.resourcemgr.config.QueryQueueConfig;
import oadd.org.apache.drill.exec.resourcemgr.config.QueueAssignmentResult;
import oadd.org.apache.drill.exec.resourcemgr.config.RMCommonDefaults;
import oadd.org.apache.drill.exec.resourcemgr.config.ResourcePool;
import oadd.org.apache.drill.exec.resourcemgr.config.ResourcePoolImpl;
import oadd.org.apache.drill.exec.resourcemgr.config.ResourcePoolTree;
import oadd.org.apache.drill.exec.resourcemgr.config.exception.QueueSelectionException;
import oadd.org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.QueueSelectionPolicy;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.QueueSelectionPolicyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePoolTreeImpl
implements ResourcePoolTree {
    private static final Logger logger = LoggerFactory.getLogger(ResourcePoolTreeImpl.class);
    public static final String ROOT_POOL_QUEUE_SELECTION_POLICY_KEY = "queue_selection_policy";
    public static final String ROOT_POOL_CONFIG_KEY = "drill.exec.rm";
    private static final String ROOT_POOL_MEMORY_SHARE_KEY = "memory";
    private final ResourcePool rootPool;
    private final Config rmConfig;
    private final NodeResources totalNodeResources;
    private final double resourceShare;
    private final Map<String, QueryQueueConfig> leafQueues = Maps.newHashMap();
    private final QueueSelectionPolicy selectionPolicy;

    public ResourcePoolTreeImpl(Config rmConfig, long totalNodeMemory, int totalNodePhysicalCpu, int vFactor) throws RMConfigException {
        this(rmConfig, new NodeResources(totalNodeMemory, totalNodePhysicalCpu, vFactor));
    }

    private ResourcePoolTreeImpl(Config rmConfig, NodeResources totalNodeResources) throws RMConfigException {
        try {
            this.rmConfig = rmConfig;
            Config rootConfig = this.rmConfig.getConfig(ROOT_POOL_CONFIG_KEY);
            this.totalNodeResources = totalNodeResources;
            this.resourceShare = rootConfig.hasPath(ROOT_POOL_MEMORY_SHARE_KEY) ? rootConfig.getDouble(ROOT_POOL_MEMORY_SHARE_KEY) : 0.9;
            this.selectionPolicy = QueueSelectionPolicyFactory.createSelectionPolicy(rootConfig.hasPath(ROOT_POOL_QUEUE_SELECTION_POLICY_KEY) ? QueueSelectionPolicy.SelectionPolicy.valueOf(rootConfig.getString(ROOT_POOL_QUEUE_SELECTION_POLICY_KEY).trim().toUpperCase()) : RMCommonDefaults.ROOT_POOL_DEFAULT_QUEUE_SELECTION_POLICY);
            this.rootPool = new ResourcePoolImpl(rootConfig, this.resourceShare, 1.0, totalNodeResources, null, this.leafQueues);
            logger.debug("Dumping RM configuration {}", (Object)this.toString());
        }
        catch (RMConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RMConfigException(String.format("Failure while parsing root pool configuration. [Details: Config: %s]", rmConfig), ex);
        }
    }

    @Override
    public ResourcePool getRootPool() {
        return this.rootPool;
    }

    @Override
    public Map<String, QueryQueueConfig> getAllLeafQueues() {
        return this.leafQueues;
    }

    @Override
    public double getResourceShare() {
        return this.resourceShare;
    }

    @Override
    public QueueAssignmentResult selectAllQueues(QueryContext queryContext) {
        QueueAssignmentResult assignmentResult = new QueueAssignmentResult();
        this.rootPool.visitAndSelectPool(assignmentResult, queryContext);
        return assignmentResult;
    }

    @Override
    public QueryQueueConfig selectOneQueue(QueryContext queryContext, NodeResources queryMaxNodeResource) throws QueueSelectionException {
        QueueAssignmentResult assignmentResult = this.selectAllQueues(queryContext);
        List<ResourcePool> selectedPools = assignmentResult.getSelectedLeafPools();
        if (selectedPools.size() == 0) {
            throw new QueueSelectionException(String.format("No resource pools to choose from for the query: %s", queryContext.getQueryId()));
        }
        if (selectedPools.size() == 1) {
            return selectedPools.get(0).getQueryQueue();
        }
        return this.selectionPolicy.selectQueue(selectedPools, queryContext, queryMaxNodeResource).getQueryQueue();
    }

    @Override
    public QueueSelectionPolicy getSelectionPolicyInUse() {
        return this.selectionPolicy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ NodeResources: ").append(this.totalNodeResources.toString());
        sb.append(", ResourcePercent: ").append(this.resourceShare);
        sb.append(", SelectionPolicy: ").append((Object)this.selectionPolicy.getSelectionPolicy());
        sb.append(", RootPool: ").append(this.rootPool.toString());
        sb.append("}");
        return sb.toString();
    }
}

