/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oadd.com.google.common.base.Function;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.alias.AliasRegistryProvider;
import oadd.org.apache.drill.exec.compile.CodeCompiler;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.AccountingDataTunnel;
import oadd.org.apache.drill.exec.ops.AccountingUserConnection;
import oadd.org.apache.drill.exec.ops.BaseFragmentContext;
import oadd.org.apache.drill.exec.ops.BufferManager;
import oadd.org.apache.drill.exec.ops.BufferManagerImpl;
import oadd.org.apache.drill.exec.ops.Consumer;
import oadd.org.apache.drill.exec.ops.ContextInformation;
import oadd.org.apache.drill.exec.ops.DataTunnelStatusHandler;
import oadd.org.apache.drill.exec.ops.ExecutorFragmentContext;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.FragmentStats;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.ops.OperatorContextImpl;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.ops.SendingAccountor;
import oadd.org.apache.drill.exec.ops.StatusHandler;
import oadd.org.apache.drill.exec.ops.ViewExpansionContext;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import oadd.org.apache.drill.exec.planner.PhysicalPlanReader;
import oadd.org.apache.drill.exec.planner.physical.PlannerSettings;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.BitData;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.UserClientConnection;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.rpc.control.WorkEventBus;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.server.QueryProfileStoreContext;
import oadd.org.apache.drill.exec.server.options.FragmentOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.store.PartitionExplorer;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import oadd.org.apache.drill.exec.store.SchemaTreeProvider;
import oadd.org.apache.drill.exec.testing.ExecutionControls;
import oadd.org.apache.drill.exec.util.ImpersonationUtil;
import oadd.org.apache.drill.exec.work.batch.IncomingBuffers;
import oadd.org.apache.drill.exec.work.filter.RuntimeFilterWritable;
import org.apache.drill.metastore.MetastoreRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentContextImpl
extends BaseFragmentContext
implements ExecutorFragmentContext {
    private static final Logger logger = LoggerFactory.getLogger(FragmentContextImpl.class);
    private final Map<CoordinationProtos.DrillbitEndpoint, AccountingDataTunnel> tunnels = new HashMap<CoordinationProtos.DrillbitEndpoint, AccountingDataTunnel>();
    private final List<OperatorContextImpl> contexts = new LinkedList<OperatorContextImpl>();
    private final DrillbitContext context;
    private final UserClientConnection connection;
    private final QueryContext queryContext;
    private final SchemaTreeProvider schemaTreeProvider;
    private final FragmentStats stats;
    private final BufferAllocator allocator;
    private final BitControl.PlanFragment fragment;
    private final ContextInformation contextInformation;
    private IncomingBuffers buffers;
    private final OptionManager fragmentOptions;
    private final BufferManager bufferManager;
    private FragmentContext.ExecutorState executorState;
    private final ExecutionControls executionControls;
    private final boolean enableRuntimeFilter;
    private final boolean enableRFWaiting;
    private Lock lock4RF;
    private Condition condition4RF;
    private final SendingAccountor sendingAccountor = new SendingAccountor();
    private final Consumer<RpcException> exceptionConsumer = new Consumer<RpcException>(){

        @Override
        public void accept(RpcException e) {
            FragmentContextImpl.this.fail(e);
        }

        @Override
        public void interrupt(InterruptedException e) {
            if (FragmentContextImpl.this.executorState.shouldContinue()) {
                logger.error("Received an unexpected interrupt while waiting for the data send to complete.", e);
                FragmentContextImpl.this.fail(e);
            }
        }
    };
    private final RpcOutcomeListener<GeneralRPCProtos.Ack> statusHandler = new StatusHandler(this.exceptionConsumer, this.sendingAccountor);
    private final RpcOutcomeListener<BitData.AckWithCredit> dataTunnelStatusHandler = new DataTunnelStatusHandler(this.exceptionConsumer, this.sendingAccountor);
    private final AccountingUserConnection accountingUserConnection;
    private final Map<String, Map<TypeProtos.MinorType, ValueHolder>> constantValueHolderCache;
    private final Map<Long, RuntimeFilterWritable> rfIdentifier2RFW = new ConcurrentHashMap<Long, RuntimeFilterWritable>();
    private final Map<Long, Boolean> rfIdentifier2fetched = new ConcurrentHashMap<Long, Boolean>();

    public FragmentContextImpl(DrillbitContext dbContext, BitControl.PlanFragment fragment, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        this(dbContext, fragment, null, null, funcRegistry);
    }

    public FragmentContextImpl(DrillbitContext dbContext, BitControl.PlanFragment fragment, QueryContext queryContext, UserClientConnection connection, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        super(funcRegistry);
        OptionList list;
        this.context = dbContext;
        this.queryContext = queryContext;
        this.schemaTreeProvider = queryContext == null ? new SchemaTreeProvider(this.context) : null;
        this.connection = connection;
        this.accountingUserConnection = new AccountingUserConnection(connection, this.sendingAccountor, this.statusHandler);
        this.fragment = fragment;
        this.contextInformation = new ContextInformation(fragment.getCredentials(), fragment.getContext());
        logger.debug("Getting initial memory allocation of {}", (Object)fragment.getMemInitial());
        logger.debug("Fragment max allocation: {}", (Object)fragment.getMemMax());
        if (!fragment.hasOptionsJson() || fragment.getOptionsJson().isEmpty()) {
            list = new OptionList();
        } else {
            try {
                list = dbContext.getLpPersistence().getMapper().readValue(fragment.getOptionsJson(), OptionList.class);
            }
            catch (Exception e) {
                throw new ExecutionSetupException("Failure while reading plan options.", e);
            }
        }
        this.fragmentOptions = new FragmentOptionManager((OptionManager)this.context.getOptionManager(), list);
        this.executionControls = new ExecutionControls(this.fragmentOptions, dbContext.getEndpoint());
        try {
            this.allocator = this.context.getAllocator().newChildAllocator("frag:" + QueryIdHelper.getFragmentId(fragment.getHandle()), fragment.getMemInitial(), fragment.getMemMax());
            Preconditions.checkNotNull(this.allocator, "Unable to acuqire allocator");
        }
        catch (OutOfMemoryException e) {
            throw UserException.memoryError(e).addContext("Fragment", this.getHandle().getMajorFragmentId() + ":" + this.getHandle().getMinorFragmentId()).build(logger);
        }
        catch (Throwable e) {
            throw new ExecutionSetupException("Failure while getting memory allocator for fragment.", e);
        }
        this.stats = new FragmentStats(this.allocator, fragment.getAssignment());
        this.bufferManager = new BufferManagerImpl(this.allocator);
        this.constantValueHolderCache = new HashMap<String, Map<TypeProtos.MinorType, ValueHolder>>();
        this.enableRuntimeFilter = this.getOptions().getOption((String)"exec.hashjoin.enable.runtime_filter").bool_val;
        boolean bl = this.enableRFWaiting = this.getOptions().getOption((String)"exec.hashjoin.runtime_filter.waiting.enable").bool_val != false && this.enableRuntimeFilter;
        if (this.enableRFWaiting) {
            this.lock4RF = new ReentrantLock();
            this.condition4RF = this.lock4RF.newCondition();
        }
    }

    public FragmentContextImpl(DrillbitContext dbContext, BitControl.PlanFragment fragment, UserClientConnection connection, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        this(dbContext, fragment, null, connection, funcRegistry);
    }

    @Override
    public OptionManager getOptions() {
        return this.fragmentOptions;
    }

    @Override
    public PhysicalPlanReader getPlanReader() {
        return this.context.getPlanReader();
    }

    @Override
    public ClusterCoordinator getClusterCoordinator() {
        return this.context.getClusterCoordinator();
    }

    @Override
    public void setBuffers(IncomingBuffers buffers) {
        Preconditions.checkArgument(this.buffers == null, "Can only set buffers once.");
        this.buffers = buffers;
    }

    @Override
    public QueryProfileStoreContext getProfileStoreContext() {
        return this.context.getProfileStoreContext();
    }

    @Override
    public Set<Map.Entry<UserServer.BitToUserConnection, UserServer.BitToUserConnectionConfig>> getUserConnections() {
        return this.context.getUserConnections();
    }

    @Override
    public void setExecutorState(FragmentContext.ExecutorState executorState) {
        Preconditions.checkArgument(this.executorState == null, "ExecutorState can only be set once.");
        this.executorState = executorState;
    }

    public void fail(Throwable cause) {
        this.executorState.fail(cause);
    }

    @Override
    public SchemaPlus getFullRootSchema() {
        return this.queryContext != null ? this.getQueryContextRootSchema() : this.getFragmentContextRootSchema();
    }

    private SchemaPlus getQueryContextRootSchema() {
        boolean isImpersonationEnabled = this.isImpersonationEnabled();
        SchemaConfig schemaConfig = SchemaConfig.newBuilder((String)(isImpersonationEnabled ? this.queryContext.getQueryUserName() : ImpersonationUtil.getProcessUserName()), (SchemaConfig.SchemaConfigInfoProvider)this.queryContext).setIgnoreAuthErrors(isImpersonationEnabled).build();
        return this.queryContext.getRootSchema(schemaConfig);
    }

    private SchemaPlus getFragmentContextRootSchema() {
        boolean isImpersonationEnabled = this.isImpersonationEnabled();
        SchemaConfig schemaConfig = SchemaConfig.newBuilder((String)(isImpersonationEnabled ? this.contextInformation.getQueryUser() : ImpersonationUtil.getProcessUserName()), (SchemaConfig.SchemaConfigInfoProvider)new FragmentSchemaConfigInfoProvider(this.fragmentOptions, this.contextInformation.getQueryUser(), this.context)).setIgnoreAuthErrors(isImpersonationEnabled).build();
        return this.schemaTreeProvider.createRootSchema(schemaConfig);
    }

    @Override
    public FragmentStats getStats() {
        return this.stats;
    }

    @Override
    public Collection<CoordinationProtos.DrillbitEndpoint> getBits() {
        return this.context.getBits();
    }

    @Override
    public ContextInformation getContextInformation() {
        return this.contextInformation;
    }

    @Override
    public CoordinationProtos.DrillbitEndpoint getForemanEndpoint() {
        return this.fragment.getForeman();
    }

    @Override
    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.context.getEndpoint();
    }

    @Override
    public Controller getController() {
        return this.context.getController();
    }

    @Override
    public OperatorCreatorRegistry getOperatorCreatorRegistry() {
        return this.context.getOperatorCreatorRegistry();
    }

    @Override
    public ExecutorService getScanDecodeExecutor() {
        return this.context.getScanDecodeExecutor();
    }

    @Override
    public ExecutorService getScanExecutor() {
        return this.context.getScanExecutor();
    }

    @Override
    public ExecProtos.FragmentHandle getHandle() {
        return this.fragment.getHandle();
    }

    @Override
    public String getFragIdString() {
        ExecProtos.FragmentHandle handle = this.getHandle();
        return handle != null ? handle.getMajorFragmentId() + ":" + handle.getMinorFragmentId() : "0:0";
    }

    @Override
    public boolean isUserAuthenticationEnabled() {
        if (this.getConfig() == null) {
            return false;
        }
        return this.getConfig().getBoolean("drill.exec.security.user.auth.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRuntimeFilter(RuntimeFilterWritable runtimeFilter) {
        long rfIdentifier = runtimeFilter.getRuntimeFilterBDef().getRfIdentifier();
        this.rfIdentifier2fetched.put(rfIdentifier, false);
        this.rfIdentifier2RFW.put(rfIdentifier, runtimeFilter);
        if (this.enableRFWaiting) {
            this.lock4RF.lock();
            try {
                this.condition4RF.signal();
            }
            catch (Exception e) {
                logger.info("fail to signal the waiting thread.", e);
            }
            finally {
                this.lock4RF.unlock();
            }
        }
    }

    @Override
    public RuntimeFilterWritable getRuntimeFilter(long rfIdentifier) {
        RuntimeFilterWritable runtimeFilterWritable = this.rfIdentifier2RFW.get(rfIdentifier);
        if (runtimeFilterWritable != null) {
            this.rfIdentifier2fetched.put(rfIdentifier, true);
        }
        return runtimeFilterWritable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeFilterWritable getRuntimeFilter(long rfIdentifier, long maxWaitTime, TimeUnit timeUnit) {
        if (this.rfIdentifier2RFW.get(rfIdentifier) != null) {
            return this.getRuntimeFilter(rfIdentifier);
        }
        if (this.enableRFWaiting) {
            this.lock4RF.lock();
            try {
                if (this.rfIdentifier2RFW.get(rfIdentifier) == null) {
                    this.condition4RF.await(maxWaitTime, timeUnit);
                }
            }
            catch (InterruptedException e) {
                logger.info("Condition was interrupted", e);
            }
            finally {
                this.lock4RF.unlock();
            }
        }
        return this.getRuntimeFilter(rfIdentifier);
    }

    @Override
    @Deprecated
    public BufferAllocator getAllocator() {
        if (this.allocator == null) {
            logger.debug("Fragment: " + this.getFragIdString() + " Allocator is NULL");
        }
        return this.allocator;
    }

    @Override
    public BufferAllocator getRootAllocator() {
        return this.context.getAllocator();
    }

    @Override
    public BufferAllocator getNewChildAllocator(String operatorName, int operatorId, long initialReservation, long maximumReservation) throws OutOfMemoryException {
        return this.allocator.newChildAllocator("op:" + QueryIdHelper.getFragmentId(this.fragment.getHandle()) + ":" + operatorId + ":" + operatorName, initialReservation, maximumReservation);
    }

    public boolean isOverMemoryLimit() {
        return this.allocator.isOverLimit();
    }

    @Override
    public CodeCompiler getCompiler() {
        return this.context.getCompiler();
    }

    @Override
    public AccountingUserConnection getUserDataTunnel() {
        Preconditions.checkState(this.connection != null, "Only Root fragment can get UserDataTunnel");
        return this.accountingUserConnection;
    }

    @Override
    public AccountingDataTunnel getDataTunnel(CoordinationProtos.DrillbitEndpoint endpoint) {
        AccountingDataTunnel tunnel = this.tunnels.get(endpoint);
        if (tunnel == null) {
            tunnel = new AccountingDataTunnel(this.context.getDataConnectionsPool().getTunnel(endpoint), this.sendingAccountor, this.dataTunnelStatusHandler);
            this.tunnels.put(endpoint, tunnel);
        }
        return tunnel;
    }

    @Override
    public IncomingBuffers getBuffers() {
        return this.buffers;
    }

    @Override
    public OperatorContext newOperatorContext(PhysicalOperator popConfig, OperatorStats stats) throws OutOfMemoryException {
        OperatorContextImpl context = new OperatorContextImpl(popConfig, this, stats);
        this.contexts.add(context);
        return context;
    }

    @Override
    public OperatorContext newOperatorContext(PhysicalOperator popConfig) throws OutOfMemoryException {
        OperatorContextImpl context = new OperatorContextImpl(popConfig, this);
        this.contexts.add(context);
        return context;
    }

    @Override
    public DrillConfig getConfig() {
        return this.context.getConfig();
    }

    @Override
    public FragmentContext.ExecutorState getExecutorState() {
        return this.executorState;
    }

    @Override
    public ExecutionControls getExecutionControls() {
        return this.executionControls;
    }

    @Override
    public String getQueryUserName() {
        return this.fragment.getCredentials().getUserName();
    }

    @Override
    public UserBitShared.QueryId getQueryId() {
        return this.fragment.getHandle().getQueryId();
    }

    @Override
    public String getQueryIdString() {
        return QueryIdHelper.getQueryId(this.getQueryId());
    }

    @Override
    public boolean isImpersonationEnabled() {
        if (this.getConfig() == null) {
            return false;
        }
        return this.getConfig().getBoolean("drill.exec.impersonation.enabled");
    }

    @Override
    public void close() {
        this.waitForSendComplete();
        this.suppressingClose((AutoCloseable)this.buffers);
        this.closeNotConsumedRFWs();
        for (OperatorContextImpl opContext : this.contexts) {
            this.suppressingClose(opContext);
        }
        this.suppressingClose(this.bufferManager);
        this.suppressingClose(this.allocator);
        this.suppressingClose((AutoCloseable)this.schemaTreeProvider);
    }

    private void suppressingClose(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    @Override
    public PartitionExplorer getPartitionExplorer() {
        throw new UnsupportedOperationException(String.format("The partition explorer interface can only be used in functions that can be evaluated at planning time. Make sure that the %s configuration option is set to true.", PlannerSettings.CONSTANT_FOLDING.getOptionName()));
    }

    @Override
    public ValueHolder getConstantValueHolder(String value, TypeProtos.MinorType type, Function<DrillBuf, ValueHolder> holderInitializer) {
        Map<TypeProtos.MinorType, ValueHolder> holdersByType;
        ValueHolder valueHolder;
        if (!this.constantValueHolderCache.containsKey(value)) {
            this.constantValueHolderCache.put(value, new HashMap());
        }
        if ((valueHolder = (holdersByType = this.constantValueHolderCache.get(value)).get(type)) == null) {
            valueHolder = holderInitializer.apply(this.getManagedBuffer());
            holdersByType.put(type, valueHolder);
        }
        return valueHolder;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.context.getExecutor();
    }

    @Override
    public void waitForSendComplete() {
        this.sendingAccountor.waitForSendComplete();
    }

    @Override
    public WorkEventBus getWorkEventBus() {
        return this.context.getWorkBus();
    }

    public boolean isBuffersDone() {
        Preconditions.checkState(this.buffers != null, "Incoming Buffers is not set in this fragment context");
        return this.buffers.isDone();
    }

    @Override
    protected BufferManager getBufferManager() {
        return this.bufferManager;
    }

    private void closeNotConsumedRFWs() {
        for (RuntimeFilterWritable runtimeFilterWritable : this.rfIdentifier2RFW.values()) {
            long rfIdentifier = runtimeFilterWritable.getRuntimeFilterBDef().getRfIdentifier();
            boolean fetchedByOperator = this.rfIdentifier2fetched.get(rfIdentifier);
            if (fetchedByOperator) continue;
            runtimeFilterWritable.close();
        }
    }

    @Override
    public QueryContext.SqlStatementType getSQLStatementType() {
        Preconditions.checkNotNull(this.queryContext, "Statement type is only valid for root fragment. Calling from non-root fragment");
        return this.queryContext.getSQLStatementType();
    }

    @Override
    public MetastoreRegistry getMetastoreRegistry() {
        return this.context.getMetastoreRegistry();
    }

    @Override
    public AliasRegistryProvider getAliasRegistryProvider() {
        return this.context.getAliasRegistryProvider();
    }

    @Override
    public void requestMemory(RecordBatch requestor) {
    }

    private static class FragmentSchemaConfigInfoProvider
    implements SchemaConfig.SchemaConfigInfoProvider {
        private final OptionManager optionManager;
        private final String queryUser;
        private final SchemaTreeProvider schemaTreeProvider;
        private final ViewExpansionContext viewExpansionContext;

        private FragmentSchemaConfigInfoProvider(OptionManager optionManager, String queryUser, DrillbitContext context) {
            this.optionManager = optionManager;
            this.queryUser = queryUser;
            this.schemaTreeProvider = new SchemaTreeProvider(context);
            this.viewExpansionContext = new ViewExpansionContext(context.getConfig(), this);
        }

        public ViewExpansionContext getViewExpansionContext() {
            return this.viewExpansionContext;
        }

        public SchemaPlus getRootSchema(String userName) {
            return this.schemaTreeProvider.createRootSchema(userName, (SchemaConfig.SchemaConfigInfoProvider)this);
        }

        public String getQueryUserName() {
            return this.queryUser;
        }

        public OptionValue getOption(String optionKey) {
            return this.optionManager.getOption(optionKey);
        }
    }
}

