/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.time.Instant;
import java.time.ZoneId;
import oadd.org.apache.drill.exec.expr.fn.impl.DateUtility;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public class ContextInformation {
    private final String queryUser;
    private final String currentDefaultSchema;
    private final long queryStartTime;
    private final int rootFragmentTimeZone;
    private final String sessionId;

    public ContextInformation(UserBitShared.UserCredentials userCredentials, BitControl.QueryContextInformation queryContextInfo) {
        this.queryUser = userCredentials.getUserName();
        this.currentDefaultSchema = queryContextInfo.getDefaultSchemaName();
        this.queryStartTime = queryContextInfo.getQueryStartTime();
        this.rootFragmentTimeZone = queryContextInfo.getTimeZone();
        this.sessionId = queryContextInfo.getSessionId();
    }

    public String getQueryUser() {
        return this.queryUser;
    }

    public String getCurrentDefaultSchema() {
        return this.currentDefaultSchema;
    }

    public long getQueryStartTime() {
        return this.queryStartTime;
    }

    public Instant getQueryStartInstant() {
        return Instant.ofEpochMilli(this.queryStartTime);
    }

    public ZoneId getRootFragmentTimeZone() {
        String zoneId = DateUtility.getTimeZone((int)this.rootFragmentTimeZone);
        return ZoneId.of(zoneId);
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

