/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.net.telnet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oadd.org.apache.commons.net.telnet.InvalidTelnetOptionException;
import oadd.org.apache.commons.net.telnet.Telnet;
import oadd.org.apache.commons.net.telnet.TelnetInputListener;
import oadd.org.apache.commons.net.telnet.TelnetInputStream;
import oadd.org.apache.commons.net.telnet.TelnetNotificationHandler;
import oadd.org.apache.commons.net.telnet.TelnetOptionHandler;
import oadd.org.apache.commons.net.telnet.TelnetOutputStream;

public class TelnetClient
extends Telnet {
    private static final int DEFAULT_MAX_SUBNEGOTIATION_LENGTH = 512;
    final int maxSubnegotiationLength;
    private InputStream input = null;
    private OutputStream output = null;
    protected boolean readerThread = true;
    private TelnetInputListener inputListener;

    public TelnetClient() {
        this("VT100", 512);
    }

    public TelnetClient(int maxSubnegotiationLength) {
        this("VT100", maxSubnegotiationLength);
    }

    public TelnetClient(String termtype) {
        this(termtype, 512);
    }

    public TelnetClient(String termtype, int maxSubnegotiationLength) {
        super(termtype);
        this.maxSubnegotiationLength = maxSubnegotiationLength;
    }

    @Override
    protected void _connectAction_() throws IOException {
        super._connectAction_();
        TelnetInputStream tmp = new TelnetInputStream(this._input_, this, this.readerThread);
        if (this.readerThread) {
            tmp.start();
        }
        this.input = new BufferedInputStream(tmp);
        this.output = new TelnetOutputStream(this);
    }

    @Override
    public void addOptionHandler(TelnetOptionHandler opthand) throws InvalidTelnetOptionException, IOException {
        super.addOptionHandler(opthand);
    }

    void closeOutputStream() throws IOException {
        if (this._output_ == null) {
            return;
        }
        try {
            this._output_.close();
        }
        finally {
            this._output_ = null;
        }
    }

    @Override
    public void deleteOptionHandler(int optcode) throws InvalidTelnetOptionException, IOException {
        super.deleteOptionHandler(optcode);
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        finally {
            this.output = null;
            this.input = null;
            super.disconnect();
        }
    }

    void flushOutputStream() throws IOException {
        if (this._output_ == null) {
            throw new IOException("Stream closed");
        }
        this._output_.flush();
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public boolean getLocalOptionState(int option) {
        return this.stateIsWill(option) && this.requestedWill(option);
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public boolean getReaderThread() {
        return this.readerThread;
    }

    public boolean getRemoteOptionState(int option) {
        return this.stateIsDo(option) && this.requestedDo(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyInputListener() {
        TelnetInputListener listener;
        TelnetClient telnetClient = this;
        synchronized (telnetClient) {
            listener = this.inputListener;
        }
        if (listener != null) {
            listener.telnetInputAvailable();
        }
    }

    public synchronized void registerInputListener(TelnetInputListener listener) {
        this.inputListener = listener;
    }

    @Override
    public void registerNotifHandler(TelnetNotificationHandler notifhand) {
        super.registerNotifHandler(notifhand);
    }

    public void registerSpyStream(OutputStream spystream) {
        super._registerSpyStream(spystream);
    }

    public boolean sendAYT(long timeout) throws IOException, IllegalArgumentException, InterruptedException {
        return this._sendAYT(timeout);
    }

    public void sendCommand(byte command) throws IOException, IllegalArgumentException {
        this._sendCommand(command);
    }

    public void sendSubnegotiation(int[] message) throws IOException, IllegalArgumentException {
        if (message.length < 1) {
            throw new IllegalArgumentException("zero length message");
        }
        this._sendSubnegotiation(message);
    }

    public void setReaderThread(boolean flag) {
        this.readerThread = flag;
    }

    public void stopSpyStream() {
        super._stopSpyStream();
    }

    public synchronized void unregisterInputListener() {
        this.inputListener = null;
    }

    @Override
    public void unregisterNotifHandler() {
        super.unregisterNotifHandler();
    }
}

